/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok;

import io.freefair.gradle.plugins.lombok.LombokBasePlugin;
import io.freefair.gradle.plugins.lombok.internal.ConfigUtil;
import io.freefair.gradle.plugins.lombok.tasks.CheckLombokConfig;
import io.freefair.gradle.plugins.lombok.tasks.Delombok;
import io.freefair.gradle.plugins.lombok.tasks.LombokConfig;
import java.io.File;
import java.util.Map;
import lombok.Generated;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;

public class LombokPlugin
implements Plugin<Project> {
    private static final String LOMBOK_MAPSTRUCT_VERSION = "0.2.0";
    private static final String SPOTBUG_DEFAULT_VERSION = "4.1.3";
    private LombokBasePlugin lombokBasePlugin;
    private Project project;
    private boolean spotbugConfigured;
    private TaskProvider<Task> checkLombokConfigs;

    public void apply(Project project) {
        this.project = project;
        this.lombokBasePlugin = (LombokBasePlugin)project.getPlugins().apply(LombokBasePlugin.class);
        project.getTasks().withType(Delombok.class).configureEach(this::configureDelombokDefaults);
        this.checkLombokConfigs = project.getTasks().register("checkLombokConfigs");
        project.getPlugins().withType(LifecycleBasePlugin.class, lifecycleBasePlugin -> project.getTasks().named("check").configure(check -> check.dependsOn(new Object[]{this.checkLombokConfigs})));
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> this.configureJavaPluginDefaults());
    }

    private void configureJavaPluginDefaults() {
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class);
        javaPluginExtension.getSourceSets().all(this::configureSourceSetDefaults);
        this.project.getTasks().named("javadoc", Javadoc.class, javadoc -> {
            SourceSet mainSourceSet = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
            javadoc.setSource(mainSourceSet.getExtensions().getByName("delombokTask"));
        });
        this.project.getPlugins().withId("com.github.spotbugs", spotBugsPlugin -> this.configureForSpotbugs(javaPluginExtension));
        this.project.getPlugins().withId("org.sonarqube", sonarPlugin -> this.configureForSpotbugs(javaPluginExtension));
    }

    private void configureSourceSetDefaults(SourceSet sourceSet) {
        this.project.getConfigurations().getByName(sourceSet.getCompileOnlyConfigurationName()).extendsFrom(new Configuration[]{this.lombokBasePlugin.getLombokConfiguration()});
        this.project.getConfigurations().getByName(sourceSet.getAnnotationProcessorConfigurationName()).extendsFrom(new Configuration[]{this.lombokBasePlugin.getLombokConfiguration()});
        TaskProvider delombokTaskProvider = this.project.getTasks().register(sourceSet.getTaskName("delombok", ""), Delombok.class, delombok -> {
            delombok.setDescription("Runs delombok on the " + sourceSet.getName() + " source-set");
            String delombokDir = "generated/sources/delombok/" + sourceSet.getJava().getName() + "/" + sourceSet.getName();
            delombok.getTarget().convention(this.project.getLayout().getBuildDirectory().dir(delombokDir));
        });
        sourceSet.getExtensions().add("delombokTask", (Object)delombokTaskProvider);
        TaskProvider compileTaskProvider = this.project.getTasks().named(sourceSet.getCompileJavaTaskName(), JavaCompile.class, compileJava -> compileJava.getOptions().getCompilerArgs().add("-Xlint:-processing"));
        this.project.afterEvaluate(p -> {
            this.handleMapstructSupport(sourceSet);
            this.handleLombokConfig(sourceSet, (TaskProvider<JavaCompile>)compileTaskProvider);
            delombokTaskProvider.configure(delombok -> {
                delombok.getEncoding().set((Object)((JavaCompile)compileTaskProvider.get()).getOptions().getEncoding());
                delombok.getClasspath().from(new Object[]{sourceSet.getCompileClasspath()});
                delombok.getInput().from(new Object[]{sourceSet.getJava().getSourceDirectories()});
            });
        });
    }

    private void configureForSpotbugs(JavaPluginExtension javaPluginExtension) {
        if (this.spotbugConfigured) {
            return;
        }
        this.spotbugConfigured = true;
        this.project.afterEvaluate(p -> {
            String toolVersion = this.resolveSpotBugVersion();
            javaPluginExtension.getSourceSets().all(sourceSet -> this.project.getDependencies().add(sourceSet.getCompileOnlyConfigurationName(), (Object)("com.github.spotbugs:spotbugs-annotations:" + toolVersion)));
        });
    }

    private String resolveSpotBugVersion() {
        if (!this.project.getPlugins().hasPlugin("com.github.spotbugs")) {
            return SPOTBUG_DEFAULT_VERSION;
        }
        Object spotbugsExtension = this.project.getExtensions().getByName("spotbugs");
        if (spotbugsExtension instanceof CodeQualityExtension) {
            return ((CodeQualityExtension)spotbugsExtension).getToolVersion();
        }
        Property toolVersionProperty = (Property)new DslObject(spotbugsExtension).getAsDynamicObject().getProperty("toolVersion");
        return (String)toolVersionProperty.get();
    }

    private void configureDelombokDefaults(Delombok delombok) {
        delombok.setGroup("lombok");
        delombok.getFormat().put("pretty", null);
    }

    private void handleLombokConfig(SourceSet sourceSet, TaskProvider<JavaCompile> compileTaskProvider) {
        if (((Boolean)this.lombokBasePlugin.getLombokExtension().getDisableConfig().get()).booleanValue()) {
            return;
        }
        Map<File, TaskProvider<LombokConfig>> lombokConfigTasks = ConfigUtil.getLombokConfigTasks(this.project, sourceSet.getName(), sourceSet.getJava().getSrcDirs());
        TaskProvider generateConfigsTask = this.project.getTasks().register(sourceSet.getTaskName("generate", "EffectiveLombokConfigs"), genConfigsTask -> {
            genConfigsTask.setGroup("lombok");
            genConfigsTask.setDescription("Generate effective Lombok configurations for source-set '" + sourceSet.getName() + "'");
            lombokConfigTasks.values().forEach(xva$0 -> genConfigsTask.dependsOn(new Object[]{xva$0}));
        });
        TaskProvider checkLombokConfig = this.project.getTasks().register(sourceSet.getTaskName("check", "lombokConfig"), CheckLombokConfig.class, new Object[]{sourceSet});
        checkLombokConfig.configure(c -> lombokConfigTasks.forEach((file, stringProvider) -> {
            c.getConfigs().put(file, ((LombokConfig)stringProvider.get()).getOutputFile().getAsFile());
            c.dependsOn(new Object[]{stringProvider});
        }));
        this.checkLombokConfigs.configure(c -> c.dependsOn(new Object[]{checkLombokConfig}));
        compileTaskProvider.configure(javaCompile -> {
            lombokConfigTasks.forEach((file, lombokConfigTaskProvider) -> javaCompile.getInputs().file((Object)((LombokConfig)lombokConfigTaskProvider.get()).getOutputFile()).withPathSensitivity(PathSensitivity.NONE).optional());
            javaCompile.dependsOn(new Object[]{checkLombokConfig});
        });
        this.project.getPlugins().withType(JacocoPlugin.class, jacocoPlugin -> checkLombokConfig.configure(c -> c.getExpectedConfigs().add((Object)"lombok.addLombokGeneratedAnnotation = true")));
        this.project.getPlugins().withId("com.github.spotbugs", spotBugsPlugin -> checkLombokConfig.configure(c -> c.getExpectedConfigs().add((Object)"lombok.extern.findbugs.addSuppressFBWarnings = true")));
        this.project.getPlugins().withId("org.sonarqube", spotBugsPlugin -> checkLombokConfig.configure(c -> c.getExpectedConfigs().add((Object)"lombok.extern.findbugs.addSuppressFBWarnings = true")));
    }

    private void handleMapstructSupport(SourceSet sourceSet) {
        Configuration annotationProcessor = this.project.getConfigurations().getByName(sourceSet.getAnnotationProcessorConfigurationName());
        Dependency mapstruct = null;
        boolean hasBinding = false;
        for (Dependency aptDependency : annotationProcessor.getAllDependencies()) {
            if ("mapstruct-processor".equals(aptDependency.getName()) && "org.mapstruct".equals(aptDependency.getGroup())) {
                mapstruct = aptDependency;
            }
            if (!"lombok-mapstruct-binding".equals(aptDependency.getName())) continue;
            hasBinding = true;
        }
        if (mapstruct != null && !hasBinding) {
            this.project.getLogger().info("Adding lombok-mapstruct-binding for source set {} because {} was found", (Object)sourceSet.getName(), mapstruct);
            this.project.getDependencies().add(sourceSet.getAnnotationProcessorConfigurationName(), (Object)"org.projectlombok:lombok-mapstruct-binding:0.2.0");
        }
    }

    @Generated
    public LombokBasePlugin getLombokBasePlugin() {
        return this.lombokBasePlugin;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public boolean isSpotbugConfigured() {
        return this.spotbugConfigured;
    }

    @Generated
    public TaskProvider<Task> getCheckLombokConfigs() {
        return this.checkLombokConfigs;
    }
}

