/*
 * Decompiled with CFR 0.152.
 */
package io.freefair.gradle.plugins.lombok;

import io.freefair.gradle.plugins.lombok.LombokBasePlugin;
import io.freefair.gradle.plugins.lombok.tasks.Delombok;
import io.freefair.gradle.plugins.lombok.tasks.GenerateLombokConfig;
import lombok.Generated;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;

public class LombokPlugin
implements Plugin<Project> {
    private static final String LOMBOK_MAPSTRUCT_VERSION = "0.2.0";
    private static final String SPOTBUG_DEFAULT_VERSION = "4.1.3";
    private LombokBasePlugin lombokBasePlugin;
    private Project project;
    private TaskProvider<GenerateLombokConfig> generateLombokConfig;
    private boolean spotbugConfigured;

    public void apply(Project project) {
        this.project = project;
        this.lombokBasePlugin = (LombokBasePlugin)project.getPlugins().apply(LombokBasePlugin.class);
        this.lombokBasePlugin.getLombokExtension().getConfig().put((Object)"config.stopBubbling", (Object)"true");
        this.generateLombokConfig = project.getTasks().register("generateLombokConfig", GenerateLombokConfig.class, genConfig -> {
            genConfig.getProperties().convention(this.lombokBasePlugin.getLombokExtension().getConfig());
            genConfig.setGroup("lombok");
        });
        project.getTasks().withType(Delombok.class).configureEach(this::configureDelombokDefaults);
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> this.configureJavaPluginDefaults());
    }

    private void configureJavaPluginDefaults() {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class);
        javaPluginConvention.getSourceSets().all(sourceSet -> {
            this.project.getConfigurations().getByName(sourceSet.getCompileOnlyConfigurationName()).extendsFrom(new Configuration[]{this.lombokBasePlugin.getLombokConfiguration()});
            this.project.getConfigurations().getByName(sourceSet.getAnnotationProcessorConfigurationName()).extendsFrom(new Configuration[]{this.lombokBasePlugin.getLombokConfiguration()});
            TaskProvider delombokTaskProvider = this.project.getTasks().register(sourceSet.getTaskName("delombok", ""), Delombok.class, delombok -> {
                delombok.setDescription("Runs delombok on the " + sourceSet.getName() + " source-set");
                String delombokDir = "generated/sources/delombok/" + sourceSet.getJava().getName() + "/" + sourceSet.getName();
                delombok.getTarget().convention(this.project.getLayout().getBuildDirectory().dir(delombokDir));
            });
            sourceSet.getExtensions().add("delombokTask", (Object)delombokTaskProvider);
            TaskProvider compileTaskProvider = this.project.getTasks().named(sourceSet.getCompileJavaTaskName(), JavaCompile.class, compileJava -> {
                compileJava.dependsOn(new Object[]{this.generateLombokConfig});
                compileJava.getOptions().getCompilerArgs().add("-Xlint:-processing");
                compileJava.getInputs().file(() -> {
                    GenerateLombokConfig generateLombokConfig = (GenerateLombokConfig)((Object)((Object)((Object)((Object)this.generateLombokConfig.get()))));
                    if (generateLombokConfig.isEnabled()) {
                        return generateLombokConfig.getOutputFile();
                    }
                    return null;
                }).withPropertyName("lombok.config").withPathSensitivity(PathSensitivity.RELATIVE).optional();
            });
            this.project.afterEvaluate(p -> {
                this.handleMapstructSupport((SourceSet)sourceSet);
                delombokTaskProvider.configure(delombok -> {
                    delombok.getEncoding().set((Object)((JavaCompile)compileTaskProvider.get()).getOptions().getEncoding());
                    delombok.getClasspath().from(new Object[]{sourceSet.getCompileClasspath()});
                    delombok.getInput().from(new Object[]{sourceSet.getJava().getSourceDirectories()});
                });
            });
        });
        this.project.getTasks().named("javadoc", Javadoc.class, javadoc -> {
            SourceSet mainSourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName("main");
            javadoc.setSource(mainSourceSet.getExtensions().getByName("delombokTask"));
        });
        this.project.getPlugins().withType(JacocoPlugin.class, jacocoPlugin -> this.configureForJacoco());
        this.project.getPlugins().withId("com.github.spotbugs", spotBugsPlugin -> this.configureForSpotbugs(javaPluginConvention));
        this.project.getPlugins().withId("org.sonarqube", sonarPlugin -> this.configureForSpotbugs(javaPluginConvention));
    }

    private void configureForSpotbugs(JavaPluginConvention javaPluginConvention) {
        if (this.spotbugConfigured) {
            return;
        }
        this.spotbugConfigured = true;
        this.lombokBasePlugin.getLombokExtension().getConfig().put((Object)"lombok.extern.findbugs.addSuppressFBWarnings", (Object)"true");
        this.project.afterEvaluate(p -> {
            String toolVersion = this.resolveSpotBugVersion();
            javaPluginConvention.getSourceSets().all(sourceSet -> this.project.getDependencies().add(sourceSet.getCompileOnlyConfigurationName(), (Object)("com.github.spotbugs:spotbugs-annotations:" + toolVersion)));
        });
    }

    private String resolveSpotBugVersion() {
        if (!this.project.getPlugins().hasPlugin("com.github.spotbugs")) {
            return SPOTBUG_DEFAULT_VERSION;
        }
        Object spotbugsExtension = this.project.getExtensions().getByName("spotbugs");
        if (spotbugsExtension instanceof CodeQualityExtension) {
            return ((CodeQualityExtension)spotbugsExtension).getToolVersion();
        }
        Property toolVersionProperty = (Property)new DslObject(spotbugsExtension).getAsDynamicObject().getProperty("toolVersion");
        return (String)toolVersionProperty.get();
    }

    private void configureForJacoco() {
        this.lombokBasePlugin.getLombokExtension().getConfig().put((Object)"lombok.addLombokGeneratedAnnotation", (Object)"true");
    }

    private void configureDelombokDefaults(Delombok delombok) {
        delombok.setGroup("lombok");
        delombok.getFormat().put("pretty", null);
    }

    private void handleMapstructSupport(SourceSet sourceSet) {
        Configuration annotationProcessor = this.project.getConfigurations().getByName(sourceSet.getAnnotationProcessorConfigurationName());
        Dependency mapstruct = null;
        boolean hasBinding = false;
        for (Dependency aptDependency : annotationProcessor.getAllDependencies()) {
            if ("mapstruct-processor".equals(aptDependency.getName()) && "org.mapstruct".equals(aptDependency.getGroup())) {
                mapstruct = aptDependency;
            }
            if (!"lombok-mapstruct-binding".equals(aptDependency.getName())) continue;
            hasBinding = true;
        }
        if (mapstruct != null && !hasBinding) {
            this.project.getLogger().info("Adding lombok-mapstruct-binding for source set {} because {} was found", (Object)sourceSet.getName(), mapstruct);
            this.project.getDependencies().add(sourceSet.getAnnotationProcessorConfigurationName(), (Object)"org.projectlombok:lombok-mapstruct-binding:0.2.0");
        }
    }

    @Generated
    public LombokBasePlugin getLombokBasePlugin() {
        return this.lombokBasePlugin;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public TaskProvider<GenerateLombokConfig> getGenerateLombokConfig() {
        return this.generateLombokConfig;
    }

    @Generated
    public boolean isSpotbugConfigured() {
        return this.spotbugConfigured;
    }
}

