package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CustomResourceSubresourceScaleBuilder extends CustomResourceSubresourceScaleFluent<CustomResourceSubresourceScaleBuilder> implements VisitableBuilder<CustomResourceSubresourceScale,CustomResourceSubresourceScaleBuilder>{
  public CustomResourceSubresourceScaleBuilder() {
    this(new CustomResourceSubresourceScale());
  }
  
  public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScaleFluent<?> fluent) {
    this(fluent, new CustomResourceSubresourceScale());
  }
  
  public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScaleFluent<?> fluent,CustomResourceSubresourceScale instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CustomResourceSubresourceScaleBuilder(CustomResourceSubresourceScale instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CustomResourceSubresourceScaleFluent<?> fluent;
  
  public CustomResourceSubresourceScale build() {
    CustomResourceSubresourceScale buildable = new CustomResourceSubresourceScale(fluent.getLabelSelectorPath(),fluent.getSpecReplicasPath(),fluent.getStatusReplicasPath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}