/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.authentication.TokenReviewStatus;
import io.fabric8.kubernetes.api.model.authentication.UserInfo;
import io.fabric8.kubernetes.api.model.authentication.UserInfoBuilder;
import io.fabric8.kubernetes.api.model.authentication.UserInfoFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TokenReviewStatusFluent<A extends TokenReviewStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<String> audiences = new ArrayList<String>();
    private Boolean authenticated;
    private String error;
    private UserInfoBuilder user;

    public TokenReviewStatusFluent() {
    }

    public TokenReviewStatusFluent(TokenReviewStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)((Object)this);
    }

    public UserInfo buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    protected void copyInstance(TokenReviewStatus instance) {
        TokenReviewStatus tokenReviewStatus = instance = instance != null ? instance : new TokenReviewStatus();
        if (instance != null) {
            this.withAudiences(instance.getAudiences());
            this.withAuthenticated(instance.getAuthenticated());
            this.withError(instance.getError());
            this.withUser(instance.getUser());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public UserNested<A> editOrNewUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(new UserInfoBuilder().build()));
    }

    public UserNested<A> editOrNewUserLike(UserInfo item) {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(item));
    }

    public UserNested<A> editUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenReviewStatusFluent that = (TokenReviewStatusFluent)((Object)o);
        if (!Objects.equals(this.audiences, that.audiences)) {
            return false;
        }
        if (!Objects.equals(this.authenticated, that.authenticated)) {
            return false;
        }
        if (!Objects.equals(this.error, that.error)) {
            return false;
        }
        if (!Objects.equals((Object)this.user, (Object)that.user)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getAudience(int index) {
        return this.audiences.get(index);
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public String getError() {
        return this.error;
    }

    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    public boolean hasAuthenticated() {
        return this.authenticated != null;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public boolean hasMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.audiences, this.authenticated, this.error, this.user, this.additionalProperties});
    }

    public A removeAllFromAudiences(Collection<String> items) {
        if (this.audiences == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.audiences.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAudiences(String ... items) {
        if (this.audiences == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.audiences.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.audiences != null && !this.audiences.isEmpty()) {
            sb.append("audiences:");
            sb.append(this.audiences);
            sb.append(",");
        }
        if (this.authenticated != null) {
            sb.append("authenticated:");
            sb.append(this.authenticated);
            sb.append(",");
        }
        if (this.error != null) {
            sb.append("error:");
            sb.append(this.error);
            sb.append(",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append((Object)this.user);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAudiences(List<String> audiences) {
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)((Object)this);
    }

    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
            this._visitables.remove((Object)"audiences");
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)((Object)this);
    }

    public A withAuthenticated() {
        return this.withAuthenticated(true);
    }

    public A withAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return (A)((Object)this);
    }

    public A withError(String error) {
        this.error = error;
        return (A)((Object)this);
    }

    public UserNested<A> withNewUser() {
        return new UserNested(null);
    }

    public UserNested<A> withNewUserLike(UserInfo item) {
        return new UserNested(item);
    }

    public A withUser(UserInfo user) {
        this._visitables.remove((Object)"user");
        if (user != null) {
            this.user = new UserInfoBuilder(user);
            this._visitables.get((Object)"user").add(this.user);
        } else {
            this.user = null;
            this._visitables.get((Object)"user").remove((Object)this.user);
        }
        return (A)((Object)this);
    }

    public class UserNested<N>
    extends UserInfoFluent<UserNested<N>>
    implements Nested<N> {
        UserInfoBuilder builder;

        UserNested(UserInfo item) {
            this.builder = new UserInfoBuilder(this, item);
        }

        public N and() {
            return (N)TokenReviewStatusFluent.this.withUser(this.builder.build());
        }

        public N endUser() {
            return this.and();
        }
    }
}

