
package io.fabric8.kubernetes.api.model.authorization.v1;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.FieldSelectorRequirement;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Accessors;

/**
 * FieldSelectorAttributes indicates a field limited access. Webhook authors are encouraged to &#42; ensure rawSelector and requirements are not both set &#42; consider the requirements field if set &#42; not try to parse or consider the rawSelector field if set. This is to avoid another CVE-2022-2880 (i.e. getting different systems to agree on how exactly to parse a query is not something we want), see https://www.oxeye.io/resources/golang-parameter-smuggling-attack for more details. For the &#42;SubjectAccessReview endpoints of the kube-apiserver: &#42; If rawSelector is empty and requirements are empty, the request is not limited. &#42; If rawSelector is present and requirements are empty, the rawSelector will be parsed and limited if the parsing succeeds. &#42; If rawSelector is empty and requirements are present, the requirements should be honored &#42; If rawSelector is present and requirements are present, the request is invalid.
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "rawSelector",
    "requirements"
})
@ToString
@EqualsAndHashCode
@Accessors(prefix = {
    "_",
    ""
})
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
@Generated("io.fabric8.kubernetes.schema.generator.model.ModelGenerator")
public class FieldSelectorAttributes implements Editable<FieldSelectorAttributesBuilder>, KubernetesResource
{

    @JsonProperty("rawSelector")
    private String rawSelector;
    @JsonProperty("requirements")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<FieldSelectorRequirement> requirements = new ArrayList<>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     */
    public FieldSelectorAttributes() {
    }

    public FieldSelectorAttributes(String rawSelector, List<FieldSelectorRequirement> requirements) {
        super();
        this.rawSelector = rawSelector;
        this.requirements = requirements;
    }

    /**
     * rawSelector is the serialization of a field selector that would be included in a query parameter. Webhook implementations are encouraged to ignore rawSelector. The kube-apiserver's &#42;SubjectAccessReview will parse the rawSelector as long as the requirements are not present.
     */
    @JsonProperty("rawSelector")
    public String getRawSelector() {
        return rawSelector;
    }

    /**
     * rawSelector is the serialization of a field selector that would be included in a query parameter. Webhook implementations are encouraged to ignore rawSelector. The kube-apiserver's &#42;SubjectAccessReview will parse the rawSelector as long as the requirements are not present.
     */
    @JsonProperty("rawSelector")
    public void setRawSelector(String rawSelector) {
        this.rawSelector = rawSelector;
    }

    /**
     * requirements is the parsed interpretation of a field selector. All requirements must be met for a resource instance to match the selector. Webhook implementations should handle requirements, but how to handle them is up to the webhook. Since requirements can only limit the request, it is safe to authorize as unlimited request if the requirements are not understood.
     */
    @JsonProperty("requirements")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public List<FieldSelectorRequirement> getRequirements() {
        return requirements;
    }

    /**
     * requirements is the parsed interpretation of a field selector. All requirements must be met for a resource instance to match the selector. Webhook implementations should handle requirements, but how to handle them is up to the webhook. Since requirements can only limit the request, it is safe to authorize as unlimited request if the requirements are not understood.
     */
    @JsonProperty("requirements")
    public void setRequirements(List<FieldSelectorRequirement> requirements) {
        this.requirements = requirements;
    }

    @JsonIgnore
    public FieldSelectorAttributesBuilder edit() {
        return new FieldSelectorAttributesBuilder(this);
    }

    @JsonIgnore
    public FieldSelectorAttributesBuilder toBuilder() {
        return edit();
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

}
