package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MutationFluent<A extends MutationFluent<A>> extends BaseFluent<A>{
  public MutationFluent() {
  }
  
  public MutationFluent(Mutation instance) {
    this.copyInstance(instance);
  }
  private ApplyConfigurationBuilder applyConfiguration;
  private JSONPatchBuilder jsonPatch;
  private String patchType;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Mutation instance) {
    instance = (instance != null ? instance : new Mutation());
    if (instance != null) {
          this.withApplyConfiguration(instance.getApplyConfiguration());
          this.withJsonPatch(instance.getJsonPatch());
          this.withPatchType(instance.getPatchType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ApplyConfiguration buildApplyConfiguration() {
    return this.applyConfiguration != null ? this.applyConfiguration.build() : null;
  }
  
  public A withApplyConfiguration(ApplyConfiguration applyConfiguration) {
    this._visitables.remove("applyConfiguration");
    if (applyConfiguration != null) {
        this.applyConfiguration = new ApplyConfigurationBuilder(applyConfiguration);
        this._visitables.get("applyConfiguration").add(this.applyConfiguration);
    } else {
        this.applyConfiguration = null;
        this._visitables.get("applyConfiguration").remove(this.applyConfiguration);
    }
    return (A) this;
  }
  
  public boolean hasApplyConfiguration() {
    return this.applyConfiguration != null;
  }
  
  public A withNewApplyConfiguration(String expression) {
    return (A)withApplyConfiguration(new ApplyConfiguration(expression));
  }
  
  public ApplyConfigurationNested<A> withNewApplyConfiguration() {
    return new ApplyConfigurationNested(null);
  }
  
  public ApplyConfigurationNested<A> withNewApplyConfigurationLike(ApplyConfiguration item) {
    return new ApplyConfigurationNested(item);
  }
  
  public ApplyConfigurationNested<A> editApplyConfiguration() {
    return withNewApplyConfigurationLike(java.util.Optional.ofNullable(buildApplyConfiguration()).orElse(null));
  }
  
  public ApplyConfigurationNested<A> editOrNewApplyConfiguration() {
    return withNewApplyConfigurationLike(java.util.Optional.ofNullable(buildApplyConfiguration()).orElse(new ApplyConfigurationBuilder().build()));
  }
  
  public ApplyConfigurationNested<A> editOrNewApplyConfigurationLike(ApplyConfiguration item) {
    return withNewApplyConfigurationLike(java.util.Optional.ofNullable(buildApplyConfiguration()).orElse(item));
  }
  
  public JSONPatch buildJsonPatch() {
    return this.jsonPatch != null ? this.jsonPatch.build() : null;
  }
  
  public A withJsonPatch(JSONPatch jsonPatch) {
    this._visitables.remove("jsonPatch");
    if (jsonPatch != null) {
        this.jsonPatch = new JSONPatchBuilder(jsonPatch);
        this._visitables.get("jsonPatch").add(this.jsonPatch);
    } else {
        this.jsonPatch = null;
        this._visitables.get("jsonPatch").remove(this.jsonPatch);
    }
    return (A) this;
  }
  
  public boolean hasJsonPatch() {
    return this.jsonPatch != null;
  }
  
  public A withNewJsonPatch(String expression) {
    return (A)withJsonPatch(new JSONPatch(expression));
  }
  
  public JsonPatchNested<A> withNewJsonPatch() {
    return new JsonPatchNested(null);
  }
  
  public JsonPatchNested<A> withNewJsonPatchLike(JSONPatch item) {
    return new JsonPatchNested(item);
  }
  
  public JsonPatchNested<A> editJsonPatch() {
    return withNewJsonPatchLike(java.util.Optional.ofNullable(buildJsonPatch()).orElse(null));
  }
  
  public JsonPatchNested<A> editOrNewJsonPatch() {
    return withNewJsonPatchLike(java.util.Optional.ofNullable(buildJsonPatch()).orElse(new JSONPatchBuilder().build()));
  }
  
  public JsonPatchNested<A> editOrNewJsonPatchLike(JSONPatch item) {
    return withNewJsonPatchLike(java.util.Optional.ofNullable(buildJsonPatch()).orElse(item));
  }
  
  public String getPatchType() {
    return this.patchType;
  }
  
  public A withPatchType(String patchType) {
    this.patchType = patchType;
    return (A) this;
  }
  
  public boolean hasPatchType() {
    return this.patchType != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MutationFluent that = (MutationFluent) o;
    if (!java.util.Objects.equals(applyConfiguration, that.applyConfiguration)) return false;
    if (!java.util.Objects.equals(jsonPatch, that.jsonPatch)) return false;
    if (!java.util.Objects.equals(patchType, that.patchType)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(applyConfiguration,  jsonPatch,  patchType,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (applyConfiguration != null) { sb.append("applyConfiguration:"); sb.append(applyConfiguration + ","); }
    if (jsonPatch != null) { sb.append("jsonPatch:"); sb.append(jsonPatch + ","); }
    if (patchType != null) { sb.append("patchType:"); sb.append(patchType + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ApplyConfigurationNested<N> extends ApplyConfigurationFluent<ApplyConfigurationNested<N>> implements Nested<N>{
    ApplyConfigurationNested(ApplyConfiguration item) {
      this.builder = new ApplyConfigurationBuilder(this, item);
    }
    ApplyConfigurationBuilder builder;
    
    public N and() {
      return (N) MutationFluent.this.withApplyConfiguration(builder.build());
    }
    
    public N endApplyConfiguration() {
      return and();
    }
    
  
  }
  public class JsonPatchNested<N> extends JSONPatchFluent<JsonPatchNested<N>> implements Nested<N>{
    JsonPatchNested(JSONPatch item) {
      this.builder = new JSONPatchBuilder(this, item);
    }
    JSONPatchBuilder builder;
    
    public N and() {
      return (N) MutationFluent.this.withJsonPatch(builder.build());
    }
    
    public N endJsonPatch() {
      return and();
    }
    
  
  }

}