package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class JSONPatchBuilder extends JSONPatchFluent<JSONPatchBuilder> implements VisitableBuilder<JSONPatch,JSONPatchBuilder>{
  public JSONPatchBuilder() {
    this(new JSONPatch());
  }
  
  public JSONPatchBuilder(JSONPatchFluent<?> fluent) {
    this(fluent, new JSONPatch());
  }
  
  public JSONPatchBuilder(JSONPatchFluent<?> fluent,JSONPatch instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public JSONPatchBuilder(JSONPatch instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  JSONPatchFluent<?> fluent;
  
  public JSONPatch build() {
    JSONPatch buildable = new JSONPatch(fluent.getExpression());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}