/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crdv2.generator;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.crdv2.generator.AbstractCustomResourceHandler;
import io.fabric8.crdv2.generator.CRDGenerationInfo;
import io.fabric8.crdv2.generator.CustomResourceInfo;
import io.fabric8.crdv2.generator.ResolvingContext;
import io.fabric8.crdv2.generator.v1.CustomResourceHandler;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRDGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CRDGenerator.class);
    private final Map<String, AbstractCustomResourceHandler> handlers = new HashMap<String, AbstractCustomResourceHandler>(2);
    private CRDOutput<? extends OutputStream> output;
    private boolean parallel;
    private boolean implicitPreserveUnknownFields;
    private ObjectMapper objectMapper;
    private KubernetesSerialization kubernetesSerialization;
    private Map<String, CustomResourceInfo> infos;

    public CRDGenerator inOutputDir(File outputDir) {
        this.output = new DirCRDOutput(outputDir);
        return this;
    }

    public CRDGenerator withOutput(CRDOutput<? extends OutputStream> output) {
        this.output = output;
        return this;
    }

    public CRDGenerator withImplicitPreserveUnknownFields(boolean implicitPreserveUnknownFields) {
        this.implicitPreserveUnknownFields = implicitPreserveUnknownFields;
        return this;
    }

    public CRDGenerator withParallelGenerationEnabled(boolean parallel) {
        this.parallel = parallel;
        return this;
    }

    public CRDGenerator withObjectMapper(ObjectMapper mapper, KubernetesSerialization kubernetesSerialization) {
        this.objectMapper = mapper;
        this.kubernetesSerialization = kubernetesSerialization;
        return this;
    }

    public CRDGenerator forCRDVersions(List<String> versions) {
        return versions != null && !versions.isEmpty() ? this.forCRDVersions(versions.toArray(new String[0])) : this;
    }

    public CRDGenerator forCRDVersions(String ... versions) {
        if (versions != null) {
            block6: for (String version : versions) {
                if (version == null) continue;
                switch (version) {
                    case "v1": {
                        this.handlers.computeIfAbsent("v1", s -> new CustomResourceHandler());
                        continue block6;
                    }
                    default: {
                        LOGGER.warn("Ignoring unsupported CRD version: {}", (Object)version);
                    }
                }
            }
        }
        return this;
    }

    Map<String, AbstractCustomResourceHandler> getHandlers() {
        return this.handlers;
    }

    public final CRDGenerator customResourceClasses(Class<? extends HasMetadata> ... crClasses) {
        if (crClasses == null) {
            return this;
        }
        return this.customResourceClasses(Arrays.asList(crClasses));
    }

    public CRDGenerator customResourceClasses(Collection<Class<? extends HasMetadata>> crClasses) {
        if (crClasses == null) {
            return this;
        }
        return this.customResources((CustomResourceInfo[])crClasses.stream().filter(Objects::nonNull).map(CustomResourceInfo::fromClass).toArray(CustomResourceInfo[]::new));
    }

    public CRDGenerator customResources(Collection<CustomResourceInfo> infos) {
        if (infos == null) {
            return this;
        }
        return this.customResources(infos.toArray(new CustomResourceInfo[0]));
    }

    public CRDGenerator customResources(CustomResourceInfo ... infos) {
        if (infos != null && infos.length > 0) {
            if (this.infos == null) {
                this.infos = new HashMap<String, CustomResourceInfo>(infos.length);
            }
            Arrays.stream(infos).filter(Objects::nonNull).forEach(info -> this.infos.put(CRDGenerator.getOutputName(info.crdName(), info.version()), (CustomResourceInfo)info));
        }
        return this;
    }

    Set<CustomResourceInfo> getCustomResourceInfos() {
        return this.infos == null ? Collections.emptySet() : new HashSet<CustomResourceInfo>(this.infos.values());
    }

    public int generate() {
        return this.detailedGenerate().numberOfGeneratedCRDs();
    }

    public CRDGenerationInfo detailedGenerate() {
        ResolvingContext context;
        if (this.getCustomResourceInfos().isEmpty()) {
            LOGGER.warn("No resources were registered with the 'customResources' method to be generated");
            return CRDGenerationInfo.EMPTY;
        }
        if (this.output == null) {
            LOGGER.warn("No output option was selected either using 'inOutputDir' or 'withOutput' methods. Skipping generation.");
            return CRDGenerationInfo.EMPTY;
        }
        if (this.handlers.isEmpty()) {
            this.forCRDVersions("v1");
        }
        if (this.objectMapper == null) {
            context = ResolvingContext.defaultResolvingContext(this.implicitPreserveUnknownFields);
            this.kubernetesSerialization = context.kubernetesSerialization;
        } else {
            context = new ResolvingContext(this.objectMapper, this.kubernetesSerialization, this.implicitPreserveUnknownFields);
        }
        for (CustomResourceInfo info : this.infos.values()) {
            if (info == null) continue;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Generating '{}' version '{}' with {} (spec: {} / status {})...", new Object[]{info.crdName(), info.version(), info.crClassName(), info.specClassName().orElse("undetermined"), info.statusClassName().orElse("undetermined")});
            }
            if (this.parallel) {
                this.handlers.values().stream().map(h -> ForkJoinPool.commonPool().submit(() -> h.handle(info, context.forkContext()))).collect(Collectors.toList()).stream().forEach(ForkJoinTask::join);
                continue;
            }
            this.handlers.values().stream().forEach(h -> h.handle(info, context.forkContext()));
        }
        CRDGenerationInfo crdGenerationInfo = new CRDGenerationInfo();
        this.handlers.values().stream().flatMap(AbstractCustomResourceHandler::finish).forEach(crd -> this.emitCrd((HasMetadata)crd.getKey(), (Set)crd.getValue(), crdGenerationInfo));
        return crdGenerationInfo;
    }

    public void emitCrd(HasMetadata crd, Set<String> dependentClassNames, CRDGenerationInfo crdGenerationInfo) {
        String version = ApiVersionUtil.trimVersion((String)crd.getApiVersion());
        String crdName = crd.getMetadata().getName();
        try {
            String outputName = CRDGenerator.getOutputName(crdName, version);
            try (OutputStreamWriter writer = new OutputStreamWriter(this.output.outputFor(outputName), StandardCharsets.UTF_8);){
                writer.write("# Generated by Fabric8 CRDGenerator, manual edits might get overwritten!\n");
                String yaml = this.kubernetesSerialization.asYaml((Object)crd);
                writer.write(yaml.substring(4));
                URI fileURI = this.output.crdURI(outputName);
                crdGenerationInfo.add(crdName, version, fileURI, dependentClassNames);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getOutputName(String crdName, String crdSpecVersion) {
        return crdName + "-" + crdSpecVersion;
    }

    static class DirCRDOutput
    extends AbstractCRDOutput<FileOutputStream> {
        private final File dir;

        public DirCRDOutput(File dir) {
            if (!(dir.isDirectory() && dir.canWrite() && dir.exists())) {
                throw new IllegalArgumentException(dir + " must exist, be a writeable output directory");
            }
            this.dir = dir;
        }

        @Override
        protected FileOutputStream createStreamFor(String crdName) throws IOException {
            File file = this.getCRDFile(crdName);
            return new FileOutputStream(file);
        }

        private File getCRDFile(String crdName) {
            return new File(this.dir, crdName + ".yml");
        }

        @Override
        public URI crdURI(String crdName) {
            return this.getCRDFile(crdName).toURI();
        }
    }

    public static abstract class AbstractCRDOutput<T extends OutputStream>
    implements CRDOutput<T> {
        private final Map<String, T> crds = new HashMap<String, T>();

        @Override
        public T outputFor(String crdName) throws IOException {
            T outputStream = this.createStreamFor(crdName);
            this.crds.put(crdName, outputStream);
            return outputStream;
        }

        protected abstract T createStreamFor(String var1) throws IOException;

        protected T getStreamFor(String crdName) {
            return (T)((OutputStream)this.crds.get(crdName));
        }

        @Override
        public void close() throws IOException {
            for (OutputStream stream : this.crds.values()) {
                stream.close();
            }
        }
    }

    public static interface CRDOutput<T extends OutputStream>
    extends Closeable {
        public T outputFor(String var1) throws IOException;

        default public URI crdURI(String crdName) {
            return URI.create("file:///" + crdName);
        }
    }
}

