/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.client;

import com.perforce.p4java.Log;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.impl.generic.client.ClientOptions;
import com.perforce.p4java.impl.generic.client.ClientSubmitOptions;
import com.perforce.p4java.impl.generic.core.ServerResource;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSummary
extends ServerResource
implements IClientSummary {
    protected String name = null;
    protected Date accessed = null;
    protected Date updated = null;
    protected String description = null;
    protected String hostName = null;
    protected String ownerName = null;
    protected String root = null;
    protected IClientSummary.ClientLineEnd lineEnd = IClientSummary.ClientLineEnd.LOCAL;
    protected IClientSummary.IClientOptions options = null;
    protected IClientSummary.IClientSubmitOptions submitOptions = null;
    protected List<String> alternateRoots = null;
    protected String stream = null;
    protected String serverId = null;
    protected int streamAtChange = -1;
    protected boolean unloaded = false;

    public ClientSummary() {
        super(false, false);
    }

    public ClientSummary(boolean summaryOnly) {
        super(!summaryOnly, !summaryOnly);
    }

    public ClientSummary(String name, Date accessed, Date updated, String description, String hostName, String ownerName, String root, IClientSummary.ClientLineEnd lineEnd, IClientSummary.IClientOptions options, IClientSummary.IClientSubmitOptions submitOptions, List<String> alternateRoots) {
        super(false, false);
        this.name = name;
        this.accessed = accessed;
        this.updated = updated;
        this.description = description;
        this.hostName = hostName;
        this.ownerName = ownerName;
        this.root = root;
        this.lineEnd = lineEnd;
        this.options = options;
        this.submitOptions = submitOptions;
        this.alternateRoots = alternateRoots;
    }

    public ClientSummary(String name, Date accessed, Date updated, String description, String hostName, String ownerName, String root, IClientSummary.ClientLineEnd lineEnd, IClientSummary.IClientOptions options, IClientSummary.IClientSubmitOptions submitOptions, List<String> alternateRoots, String stream) {
        super(false, false);
        this.name = name;
        this.accessed = accessed;
        this.updated = updated;
        this.description = description;
        this.hostName = hostName;
        this.ownerName = ownerName;
        this.root = root;
        this.lineEnd = lineEnd;
        this.options = options;
        this.submitOptions = submitOptions;
        this.alternateRoots = alternateRoots;
        this.stream = stream;
    }

    public ClientSummary(IClientSummary clientSummary) {
        super(false, false);
        this.name = clientSummary.getName();
        this.accessed = clientSummary.getAccessed();
        this.updated = clientSummary.getUpdated();
        this.description = clientSummary.getDescription();
        this.hostName = clientSummary.getHostName();
        this.ownerName = clientSummary.getOwnerName();
        this.root = clientSummary.getRoot();
        this.lineEnd = clientSummary.getLineEnd();
        this.options = clientSummary.getOptions();
        this.submitOptions = clientSummary.getSubmitOptions();
        this.alternateRoots = clientSummary.getAlternateRoots();
        this.stream = clientSummary.getStream();
        this.serverId = clientSummary.getServerId();
        this.streamAtChange = clientSummary.getStreamAtChange();
    }

    public ClientSummary(Map<String, Object> map, boolean summaryOnly) {
        super(false, false);
        if (map != null) {
            try {
                String altRoot;
                if (summaryOnly) {
                    this.name = (String)map.get("client");
                    this.updated = new Date(Long.parseLong((String)map.get("Update")) * 1000L);
                    this.accessed = new Date(Long.parseLong((String)map.get("Access")) * 1000L);
                    this.description = (String)map.get("Description");
                }
                this.hostName = (String)map.get("Host");
                this.ownerName = (String)map.get("Owner");
                this.root = (String)map.get("Root");
                this.lineEnd = IClientSummary.ClientLineEnd.getValue((String)map.get("LineEnd"));
                this.options = new ClientOptions((String)map.get("Options"));
                String submitOptions = (String)map.get("SubmitOptions");
                if (submitOptions != null) {
                    this.submitOptions = new ClientSubmitOptions(submitOptions);
                }
                int i = 0;
                while ((altRoot = (String)map.get("AltRoots" + i)) != null) {
                    if (this.alternateRoots == null) {
                        this.alternateRoots = new ArrayList<String>();
                    }
                    this.alternateRoots.add((String)map.get("AltRoots" + i));
                    ++i;
                }
                if (map.get("Stream") != null) {
                    this.stream = (String)map.get("Stream");
                }
                this.serverId = (String)map.get("ServerID");
                if (map.get("AtChange") != null) {
                    this.streamAtChange = new Integer((String)map.get("AtChange"));
                }
                if (map.get("IsUnloaded") != null && ((String)map.get("IsUnloaded")).equals("1")) {
                    this.unloaded = true;
                }
            }
            catch (Exception exc) {
                Log.error("Format error in ClientSummary constructor: " + exc.getLocalizedMessage());
                Log.exception(exc);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Date getAccessed() {
        return this.accessed;
    }

    @Override
    public void setAccessed(Date accessed) {
        this.accessed = accessed;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public String getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(String root) {
        this.root = root;
    }

    @Override
    public IClientSummary.ClientLineEnd getLineEnd() {
        return this.lineEnd;
    }

    @Override
    public void setLineEnd(IClientSummary.ClientLineEnd lineEnd) {
        this.lineEnd = lineEnd;
    }

    @Override
    public IClientSummary.IClientOptions getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(IClientSummary.IClientOptions options) {
        this.options = options;
    }

    @Override
    public IClientSummary.IClientSubmitOptions getSubmitOptions() {
        return this.submitOptions;
    }

    @Override
    public void setSubmitOptions(IClientSummary.IClientSubmitOptions submitOptions) {
        this.submitOptions = submitOptions;
    }

    @Override
    public List<String> getAlternateRoots() {
        return this.alternateRoots;
    }

    @Override
    public void setAlternateRoots(List<String> alternateRoots) {
        this.alternateRoots = alternateRoots;
    }

    @Override
    public String getStream() {
        return this.stream;
    }

    @Override
    public void setStream(String stream) {
        this.stream = stream;
    }

    @Override
    public boolean isStream() {
        return this.stream != null && this.stream.startsWith("//");
    }

    @Override
    public String getServerId() {
        return this.serverId;
    }

    @Override
    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    @Override
    public int getStreamAtChange() {
        return this.streamAtChange;
    }

    @Override
    public void setStreamAtChange(int streamAtChange) {
        this.streamAtChange = streamAtChange;
    }

    @Override
    public boolean isUnloaded() {
        return this.unloaded;
    }
}

