/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.impl.generic.core.MapEntry;
import com.perforce.p4java.impl.generic.core.ServerResource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Depot
extends ServerResource
implements IDepot {
    private String name = null;
    private String ownerName = null;
    private Date modDate = null;
    private String description = null;
    private IDepot.DepotType depotType = null;
    private String address = null;
    private String suffix = null;
    private String streamDepth = null;
    private String map = null;
    private ViewMap<IMapEntry> specMap = null;

    public Depot() {
        super(false, false);
    }

    public Depot(String name, String ownerName, Date modDate, String description, IDepot.DepotType depotType, String address, String suffix, String map) {
        this(name, ownerName, modDate, description, depotType, address, suffix, null, map);
    }

    public Depot(String name, String ownerName, Date modDate, String description, IDepot.DepotType depotType, String address, String suffix, String streamDepth, String map) {
        this.name = name;
        this.ownerName = ownerName;
        this.modDate = modDate;
        this.description = description;
        this.depotType = depotType;
        this.address = address;
        this.suffix = suffix;
        this.streamDepth = streamDepth;
        this.map = map;
    }

    public Depot(String name, String ownerName, Date modDate, String description, IDepot.DepotType depotType, String address, String suffix, String streamDepth, String map, ViewMap<IMapEntry> specMap) {
        this.name = name;
        this.ownerName = ownerName;
        this.modDate = modDate;
        this.description = description;
        this.depotType = depotType;
        this.address = address;
        this.suffix = suffix;
        this.streamDepth = streamDepth;
        this.map = map;
        this.specMap = specMap;
    }

    public Depot(Map<String, Object> map) {
        super(false, false);
        if (map != null) {
            try {
                this.name = (String)map.get("name");
                if (this.name == null) {
                    this.name = (String)map.get("Depot");
                }
                this.ownerName = (String)map.get("owner");
                if (this.ownerName == null) {
                    this.ownerName = (String)map.get("Owner");
                }
                try {
                    if (map.get("time") != null) {
                        this.modDate = new Date(new Long((String)map.get("time")));
                    } else if (map.get("Date") != null) {
                        this.modDate = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse((String)map.get("Date"));
                    }
                }
                catch (Throwable thr) {
                    Log.error("Unexpected exception in Depot constructor: " + thr.getLocalizedMessage());
                    Log.exception(thr);
                }
                this.description = (String)map.get("desc");
                if (this.description == null) {
                    this.description = (String)map.get("Description");
                }
                if (this.description != null && this.description.length() > 1 && this.description.endsWith("\n")) {
                    this.description = this.description.substring(0, this.description.length() - 1);
                }
                if (map.get("type") != null) {
                    this.depotType = IDepot.DepotType.fromString(((String)map.get("type")).toUpperCase());
                } else if (map.get("Type") != null) {
                    this.depotType = IDepot.DepotType.fromString(((String)map.get("Type")).toUpperCase());
                }
                switch (this.depotType) {
                    case REMOTE: {
                        this.address = (String)map.get("extra");
                        if (this.address != null) break;
                        this.address = (String)map.get("Address");
                        break;
                    }
                    case SPEC: {
                        this.suffix = (String)map.get("extra");
                        if (this.suffix == null) {
                            this.suffix = (String)map.get("Suffix");
                        }
                        this.specMap = map.containsKey("SpecMap0") ? new ViewMap() : null;
                        int i = 0;
                        while (map.containsKey("SpecMap" + i)) {
                            if (map.get("SpecMap" + i) != null) {
                                try {
                                    String path = (String)map.get("SpecMap" + i);
                                    this.specMap.getEntryList().add(new MapEntry(i, path));
                                }
                                catch (Throwable thr) {
                                    Log.error("Unexpected exception in depot spec map-based constructor: " + thr.getLocalizedMessage());
                                    Log.exception(thr);
                                }
                            }
                            ++i;
                        }
                        break;
                    }
                    case STREAM: {
                        this.streamDepth = (String)map.get("depth");
                        if (this.streamDepth != null) break;
                        this.streamDepth = (String)map.get("StreamDepth");
                        break;
                    }
                }
                this.map = (String)map.get("map");
                if (this.map == null) {
                    this.map = (String)map.get("Map");
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in Depot constructor: " + thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public Date getModDate() {
        return this.modDate;
    }

    public void setModDate(Date modDate) {
        this.modDate = modDate;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public IDepot.DepotType getDepotType() {
        return this.depotType;
    }

    public void setDepotType(IDepot.DepotType depotType) {
        this.depotType = depotType;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public String getStreamDepth() {
        return this.streamDepth;
    }

    public void setStreamDepth(String streamDepth) {
        this.streamDepth = streamDepth;
    }

    @Override
    public String getMap() {
        return this.map;
    }

    public void setMap(String map) {
        this.map = map;
    }

    @Override
    public ViewMap<IMapEntry> getSpecMap() {
        return this.specMap;
    }

    public void setSpecMap(ViewMap<IMapEntry> specMap) {
        this.specMap = specMap;
    }
}

