/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.transport;

import com.netflix.nebula.lint.jgit.errors.TransportException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.transport.RemoteSession;
import com.netflix.nebula.lint.jgit.transport.SshSessionFactory;
import com.netflix.nebula.lint.jgit.transport.TcpTransport;
import com.netflix.nebula.lint.jgit.transport.URIish;
import com.netflix.nebula.lint.jgit.util.FS;

public abstract class SshTransport
extends TcpTransport {
    private SshSessionFactory sch = SshSessionFactory.getInstance();
    private RemoteSession sock;

    protected SshTransport(Repository local, URIish uri) {
        super(local, uri);
    }

    protected SshTransport(URIish uri) {
        super(uri);
    }

    public void setSshSessionFactory(SshSessionFactory factory) {
        if (factory == null) {
            throw new NullPointerException(JGitText.get().theFactoryMustNotBeNull);
        }
        if (this.sock != null) {
            throw new IllegalStateException(JGitText.get().anSSHSessionHasBeenAlreadyCreated);
        }
        this.sch = factory;
    }

    public SshSessionFactory getSshSessionFactory() {
        return this.sch;
    }

    protected RemoteSession getSession() throws TransportException {
        if (this.sock != null) {
            return this.sock;
        }
        int tms = this.getTimeout() > 0 ? this.getTimeout() * 1000 : 0;
        FS fs = this.local == null ? FS.detect() : this.local.getFS();
        this.sock = this.sch.getSession(this.uri, this.getCredentialsProvider(), fs, tms);
        return this.sock;
    }

    @Override
    public void close() {
        if (this.sock != null) {
            try {
                this.sch.releaseSession(this.sock);
            }
            finally {
                this.sock = null;
            }
        }
    }
}

