/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.nls;

import com.netflix.nebula.lint.jgit.nls.GlobalBundleCache;
import com.netflix.nebula.lint.jgit.nls.TranslationBundle;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

public class NLS {
    public static final Locale ROOT_LOCALE = new Locale("", "", "");
    private static final InheritableThreadLocal<NLS> local = new InheritableThreadLocal();
    private final Locale locale;
    private final ConcurrentHashMap<Class, TranslationBundle> map = new ConcurrentHashMap();

    public static void setLocale(Locale locale) {
        local.set(new NLS(locale));
    }

    public static void useJVMDefaultLocale() {
        NLS.useJVMDefaultInternal();
    }

    private static NLS useJVMDefaultInternal() {
        NLS b = new NLS(Locale.getDefault());
        local.set(b);
        return b;
    }

    public static <T extends TranslationBundle> T getBundleFor(Class<T> type) {
        NLS b = (NLS)local.get();
        if (b == null) {
            b = NLS.useJVMDefaultInternal();
        }
        return b.get(type);
    }

    private NLS(Locale locale) {
        this.locale = locale;
    }

    private <T extends TranslationBundle> T get(Class<T> type) {
        TranslationBundle old;
        TranslationBundle bundle = this.map.get(type);
        if (bundle == null && (old = this.map.putIfAbsent(type, bundle = GlobalBundleCache.lookupBundle(this.locale, type))) != null) {
            bundle = old;
        }
        return (T)bundle;
    }
}

