/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.file;

import com.netflix.nebula.lint.jgit.internal.storage.file.LockFile;
import com.netflix.nebula.lint.jgit.lib.Constants;
import com.netflix.nebula.lint.jgit.util.FS;
import com.netflix.nebula.lint.jgit.util.FileUtils;
import java.io.File;
import java.io.IOException;

public class PackLock {
    private final File keepFile;

    public PackLock(File packFile, FS fs) {
        File p = packFile.getParentFile();
        String n = packFile.getName();
        this.keepFile = new File(p, String.valueOf(n.substring(0, n.length() - 5)) + ".keep");
    }

    public boolean lock(String msg) throws IOException {
        LockFile lf;
        if (msg == null) {
            return false;
        }
        if (!msg.endsWith("\n")) {
            msg = String.valueOf(msg) + "\n";
        }
        if (!(lf = new LockFile(this.keepFile)).lock()) {
            return false;
        }
        lf.write(Constants.encode(msg));
        return lf.commit();
    }

    public void unlock() throws IOException {
        FileUtils.delete(this.keepFile);
    }
}

