/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.InvalidRefNameException;
import com.netflix.nebula.lint.jgit.api.errors.RefNotFoundException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.ReflogEntry;
import com.netflix.nebula.lint.jgit.lib.ReflogReader;
import com.netflix.nebula.lint.jgit.lib.Repository;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;

public class ReflogCommand
extends GitCommand<Collection<ReflogEntry>> {
    private String ref = "HEAD";

    public ReflogCommand(Repository repo) {
        super(repo);
    }

    public ReflogCommand setRef(String ref) {
        this.checkCallable();
        this.ref = ref;
        return this;
    }

    @Override
    public Collection<ReflogEntry> call() throws GitAPIException, InvalidRefNameException {
        this.checkCallable();
        try {
            ReflogReader reader = this.repo.getReflogReader(this.ref);
            if (reader == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.ref));
            }
            return reader.getReverseEntries();
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, this.ref), e);
        }
    }
}

