/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.IJavaElement;
import com.netflix.nebula.lint.jdt.core.IJavaModelStatus;
import com.netflix.nebula.lint.jdt.core.IPackageFragmentRoot;
import com.netflix.nebula.lint.jdt.core.JavaConventions;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.internal.core.JavaElementDelta;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelOperation;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelStatus;
import com.netflix.nebula.lint.jdt.internal.core.PackageFragment;
import com.netflix.nebula.lint.jdt.internal.core.PackageFragmentRoot;
import com.netflix.nebula.lint.jdt.internal.core.util.Messages;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CreatePackageFragmentOperation
extends JavaModelOperation {
    protected String[] pkgName;

    public CreatePackageFragmentOperation(IPackageFragmentRoot parentElement, String packageName, boolean force) {
        super(null, new IJavaElement[]{parentElement}, force);
        this.pkgName = packageName == null ? null : Util.getTrimmedSimpleNames(packageName);
    }

    protected void executeOperation() throws JavaModelException {
        JavaElementDelta delta = null;
        PackageFragmentRoot root = (PackageFragmentRoot)this.getParentElement();
        this.beginTask(Messages.operation_createPackageFragmentProgress, this.pkgName.length);
        IContainer parentFolder = (IContainer)root.getResource();
        String[] sideEffectPackageName = CharOperation.NO_STRINGS;
        ArrayList<PackageFragment> results = new ArrayList<PackageFragment>(this.pkgName.length);
        char[][] inclusionPatterns = root.fullInclusionPatternChars();
        char[][] exclusionPatterns = root.fullExclusionPatternChars();
        int i = 0;
        while (i < this.pkgName.length) {
            String subFolderName = this.pkgName[i];
            sideEffectPackageName = Util.arrayConcat(sideEffectPackageName, subFolderName);
            IResource subFolder = parentFolder.findMember(subFolderName);
            if (subFolder == null) {
                this.createFolder(parentFolder, subFolderName, this.force);
                parentFolder = parentFolder.getFolder((IPath)new Path(subFolderName));
                PackageFragment addedFrag = root.getPackageFragment(sideEffectPackageName);
                if (!Util.isExcluded((IResource)parentFolder, inclusionPatterns, exclusionPatterns)) {
                    if (delta == null) {
                        delta = this.newJavaElementDelta();
                    }
                    delta.added(addedFrag);
                }
                results.add(addedFrag);
            } else {
                parentFolder = (IContainer)subFolder;
            }
            this.worked(1);
            ++i;
        }
        if (results.size() > 0) {
            this.resultElements = new IJavaElement[results.size()];
            results.toArray(this.resultElements);
            if (delta != null) {
                this.addDelta(delta);
            }
        }
        this.done();
    }

    public IJavaModelStatus verify() {
        String packageName;
        if (this.getParentElement() == null) {
            return new JavaModelStatus(968);
        }
        String string = packageName = this.pkgName == null ? null : Util.concatWith(this.pkgName, '.');
        if (this.pkgName == null || this.pkgName.length > 0 && JavaConventions.validatePackageName(packageName).getSeverity() == 4) {
            return new JavaModelStatus(983, packageName);
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getParentElement();
        if (root.isReadOnly()) {
            return new JavaModelStatus(976, root);
        }
        IContainer parentFolder = (IContainer)root.getResource();
        int i = 0;
        while (i < this.pkgName.length) {
            IResource subFolder = parentFolder.findMember(this.pkgName[i]);
            if (subFolder != null) {
                if (subFolder.getType() != 2) {
                    return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, subFolder.getFullPath().toString()));
                }
                parentFolder = (IContainer)subFolder;
            }
            ++i;
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

