/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.codegen;

import com.netflix.nebula.lint.jdt.internal.compiler.codegen.CodeStream;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.Label;

public class CaseLabel
extends Label {
    public int instructionPosition = -1;
    public int backwardsBranch = -1;

    public CaseLabel(CodeStream codeStream) {
        super(codeStream);
    }

    void branch() {
        if (this.position == -1) {
            this.addForwardReference(this.codeStream.position);
            this.codeStream.position += 4;
            this.codeStream.classFileOffset += 4;
        } else {
            this.codeStream.writeSignedWord(this.position - this.codeStream.position + 1);
        }
    }

    void branchWide() {
        if (this.position == -1) {
            this.addForwardReference(this.codeStream.position);
            this.codeStream.position += 4;
        } else {
            this.codeStream.writeSignedWord(this.position - this.codeStream.position + 1);
        }
    }

    public boolean isStandardLabel() {
        return false;
    }

    public void place() {
        this.position = this.codeStream.position;
        if (this.instructionPosition == -1) {
            this.backwardsBranch = this.position;
        } else {
            int offset = this.position - this.instructionPosition;
            int i = 0;
            while (i < this.forwardReferenceCount) {
                this.codeStream.writeSignedWord(this.forwardReferences[i], offset);
                ++i;
            }
            this.codeStream.addLabel(this);
        }
    }

    void placeInstruction() {
        if (this.instructionPosition == -1) {
            this.instructionPosition = this.codeStream.position;
            if (this.backwardsBranch != -1) {
                int offset = this.backwardsBranch - this.instructionPosition;
                int i = 0;
                while (i < this.forwardReferenceCount) {
                    this.codeStream.writeSignedWord(this.forwardReferences[i], offset);
                    ++i;
                }
                this.backwardsBranch = -1;
            }
        }
    }
}

