/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.ast;

import com.netflix.nebula.lint.jdt.internal.compiler.ASTVisitor;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.CharLiteral;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.StringLiteral;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;

public class ExtendedStringLiteral
extends StringLiteral {
    public ExtendedStringLiteral(StringLiteral str, CharLiteral character) {
        super(str.source, str.sourceStart, str.sourceEnd);
        this.extendWith(character);
    }

    public ExtendedStringLiteral(StringLiteral str1, StringLiteral str2) {
        super(str1.source, str1.sourceStart, str1.sourceEnd);
        this.extendWith(str2);
    }

    public ExtendedStringLiteral extendWith(CharLiteral lit) {
        int length = this.source.length;
        this.source = new char[length + 1];
        System.arraycopy(this.source, 0, this.source, 0, length);
        this.source[length] = lit.value;
        this.sourceEnd = lit.sourceEnd;
        return this;
    }

    public ExtendedStringLiteral extendWith(StringLiteral lit) {
        int length = this.source.length;
        this.source = new char[length + lit.source.length];
        System.arraycopy(this.source, 0, this.source, 0, length);
        System.arraycopy(lit.source, 0, this.source, length, lit.source.length);
        this.sourceEnd = lit.sourceEnd;
        return this;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        return output.append("ExtendedStringLiteral{").append(this.source).append('}');
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

