/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.core.dom;

import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.core.compiler.InvalidInputException;
import com.netflix.nebula.lint.jdt.core.dom.AST;
import com.netflix.nebula.lint.jdt.core.dom.ASTNode;
import com.netflix.nebula.lint.jdt.core.dom.Javadoc;
import com.netflix.nebula.lint.jdt.core.dom.MemberRef;
import com.netflix.nebula.lint.jdt.core.dom.MethodRef;
import com.netflix.nebula.lint.jdt.core.dom.MethodRefParameter;
import com.netflix.nebula.lint.jdt.core.dom.Name;
import com.netflix.nebula.lint.jdt.core.dom.PrimitiveType;
import com.netflix.nebula.lint.jdt.core.dom.QualifiedName;
import com.netflix.nebula.lint.jdt.core.dom.SimpleName;
import com.netflix.nebula.lint.jdt.core.dom.TagElement;
import com.netflix.nebula.lint.jdt.core.dom.TextElement;
import com.netflix.nebula.lint.jdt.core.dom.Type;
import com.netflix.nebula.lint.jdt.internal.compiler.parser.AbstractCommentParser;
import com.netflix.nebula.lint.jdt.internal.compiler.parser.Scanner;
import java.util.List;
import java.util.ListIterator;

class DocCommentParser
extends AbstractCommentParser {
    private Javadoc docComment;
    private AST ast;

    DocCommentParser(AST ast, Scanner scanner, boolean check) {
        super(null);
        this.ast = ast;
        this.scanner = scanner;
        this.jdk15 = this.ast.apiLevel() >= 3;
        this.checkDocComment = check;
        this.kind = 2;
    }

    public Javadoc parse(int[] positions) {
        return this.parse(positions[0], positions[1] - positions[0]);
    }

    public Javadoc parse(int start, int length) {
        this.source = this.scanner.source;
        this.lineEnds = this.scanner.lineEnds;
        this.docComment = new Javadoc(this.ast);
        if (this.checkDocComment) {
            this.javadocStart = start;
            this.javadocEnd = start + length - 1;
            this.firstTagPosition = this.javadocStart;
            this.commentParse();
        }
        this.docComment.setSourceRange(start, length);
        if (this.ast.apiLevel == 2) {
            this.setComment(start, length);
        }
        return this.docComment;
    }

    private void setComment(int start, int length) {
        this.docComment.setComment(new String(this.source, start, length));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("javadoc: ").append(this.docComment).append("\n");
        buffer.append(super.toString());
        return buffer.toString();
    }

    protected Object createArgumentReference(char[] name, int dim, boolean isVarargs, Object typeRef, long[] dimPositions, long argNamePos) throws InvalidInputException {
        try {
            MethodRefParameter argument = this.ast.newMethodRefParameter();
            ASTNode node = (ASTNode)typeRef;
            int argStart = node.getStartPosition();
            int argEnd = node.getStartPosition() + node.getLength() - 1;
            if (dim > 0) {
                argEnd = (int)dimPositions[dim - 1];
            }
            if (argNamePos >= 0L) {
                argEnd = (int)argNamePos;
            }
            if (name.length != 0) {
                SimpleName argName = new SimpleName(this.ast);
                argName.internalSetIdentifier(new String(name));
                argument.setName(argName);
                int argNameStart = (int)(argNamePos >>> 32);
                argName.setSourceRange(argNameStart, argEnd - argNameStart + 1);
            }
            Type argType = null;
            if (node.getNodeType() == 39) {
                argType = (PrimitiveType)node;
            } else {
                Name argTypeName = (Name)node;
                argType = this.ast.newSimpleType(argTypeName);
                argType.setSourceRange(argStart, node.getLength());
            }
            if (dim > 0 && !isVarargs) {
                int i = 0;
                while (i < dim) {
                    argType = this.ast.newArrayType(argType);
                    argType.setSourceRange(argStart, (int)dimPositions[i] - argStart + 1);
                    ++i;
                }
            }
            argument.setType(argType);
            argument.setSourceRange(argStart, argEnd - argStart + 1);
            return argument;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException();
        }
    }

    protected Object createFieldReference(Object receiver) throws InvalidInputException {
        try {
            MemberRef fieldRef = this.ast.newMemberRef();
            SimpleName fieldName = new SimpleName(this.ast);
            fieldName.internalSetIdentifier(new String(this.identifierStack[0]));
            fieldRef.setName(fieldName);
            int start = (int)(this.identifierPositionStack[0] >>> 32);
            int end = (int)this.identifierPositionStack[0];
            fieldName.setSourceRange(start, end - start + 1);
            if (receiver == null) {
                start = this.memberStart;
                fieldRef.setSourceRange(start, end - start + 1);
            } else {
                Name typeRef = (Name)receiver;
                fieldRef.setQualifier(typeRef);
                start = typeRef.getStartPosition();
                end = fieldName.getStartPosition() + fieldName.getLength() - 1;
                fieldRef.setSourceRange(start, end - start + 1);
            }
            return fieldRef;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException();
        }
    }

    protected Object createMethodReference(Object receiver, List arguments) throws InvalidInputException {
        try {
            MethodRef methodRef = this.ast.newMethodRef();
            SimpleName methodName = new SimpleName(this.ast);
            methodName.internalSetIdentifier(new String(this.identifierStack[0]));
            methodRef.setName(methodName);
            int start = (int)(this.identifierPositionStack[0] >>> 32);
            int end = (int)this.identifierPositionStack[0];
            methodName.setSourceRange(start, end - start + 1);
            if (receiver == null) {
                start = this.memberStart;
                methodRef.setSourceRange(start, end - start + 1);
            } else {
                Name typeRef = (Name)receiver;
                methodRef.setQualifier(typeRef);
                start = typeRef.getStartPosition();
            }
            if (arguments != null) {
                ListIterator parameters = arguments.listIterator();
                while (parameters.hasNext()) {
                    MethodRefParameter param = (MethodRefParameter)parameters.next();
                    methodRef.parameters().add(param);
                }
            }
            methodRef.setSourceRange(start, this.scanner.getCurrentTokenEndPosition() - start + 1);
            return methodRef;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException();
        }
    }

    protected void createTag() {
        TagElement tagElement = this.ast.newTagElement();
        int start = this.tagSourceStart;
        String tagName = new String(this.source, start, this.tagSourceEnd - start + 1);
        switch (tagName.charAt(0)) {
            case 'a': {
                if (!tagName.equals("@author")) break;
                tagName = "@author";
                break;
            }
            case 'd': {
                if (!tagName.equals("@docRoot")) break;
                tagName = "@docRoot";
                break;
            }
            case 'r': {
                if (!tagName.equals("@return")) break;
                tagName = "@return";
                break;
            }
            case 's': {
                if (tagName.equals("@serial")) {
                    tagName = "@serial";
                    break;
                }
                if (tagName.equals("@serialData")) {
                    tagName = "@serialData";
                    break;
                }
                if (!tagName.equals("@serialField")) break;
                tagName = "@serialField";
                break;
            }
            case 'v': {
                if (!tagName.equals("@version")) break;
                tagName = "@version";
            }
        }
        tagElement.setTagName(tagName);
        if (this.inlineTagStarted) {
            start = this.inlineTagStart;
            TagElement previousTag = null;
            if (this.astPtr == -1) {
                previousTag = this.ast.newTagElement();
                previousTag.setSourceRange(start, this.tagSourceEnd - start + 1);
                this.pushOnAstStack(previousTag, true);
            } else {
                previousTag = (TagElement)this.astStack[this.astPtr];
            }
            int previousStart = previousTag.getStartPosition();
            previousTag.fragments().add(tagElement);
            previousTag.setSourceRange(previousStart, this.tagSourceEnd - previousStart + 1);
        } else {
            this.pushOnAstStack(tagElement, true);
        }
        tagElement.setSourceRange(start, this.tagSourceEnd - start + 1);
    }

    protected Object createTypeReference(int primitiveToken) {
        int size = this.identifierLengthStack[this.identifierLengthPtr--];
        String[] identifiers = new String[size];
        int pos = this.identifierPtr - size + 1;
        int i = 0;
        while (i < size) {
            identifiers[i] = new String(this.identifierStack[pos + i]);
            ++i;
        }
        ASTNode typeRef = null;
        if (primitiveToken == -1) {
            typeRef = this.ast.internalNewName(identifiers);
        } else {
            switch (primitiveToken) {
                case 40: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.VOID);
                    break;
                }
                case 32: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.BOOLEAN);
                    break;
                }
                case 33: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.BYTE);
                    break;
                }
                case 34: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.CHAR);
                    break;
                }
                case 35: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.DOUBLE);
                    break;
                }
                case 36: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.FLOAT);
                    break;
                }
                case 37: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.INT);
                    break;
                }
                case 38: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.LONG);
                    break;
                }
                case 39: {
                    typeRef = this.ast.newPrimitiveType(PrimitiveType.SHORT);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        int start = (int)(this.identifierPositionStack[pos] >>> 32);
        if (size > 1) {
            ASTNode name = typeRef;
            int nameIndex = size;
            int i2 = this.identifierPtr;
            while (i2 > pos) {
                int s = (int)(this.identifierPositionStack[i2] >>> 32);
                int e = (int)this.identifierPositionStack[i2];
                ((Name)name).index = nameIndex;
                SimpleName simpleName = ((QualifiedName)name).getName();
                simpleName.index = nameIndex--;
                simpleName.setSourceRange(s, e - s + 1);
                name.setSourceRange(start, e - start + 1);
                name = ((QualifiedName)name).getQualifier();
                --i2;
            }
            int end = (int)this.identifierPositionStack[pos];
            name.setSourceRange(start, end - start + 1);
            ((Name)name).index = nameIndex;
        } else {
            int end = (int)this.identifierPositionStack[pos];
            typeRef.setSourceRange(start, end - start + 1);
        }
        this.identifierPtr -= size;
        return typeRef;
    }

    protected boolean parseReturn() {
        this.createTag();
        return true;
    }

    protected boolean parseTag(int previousPosition) throws InvalidInputException {
        int token = this.readTokenAndConsume();
        this.tagSourceStart = this.scanner.getCurrentTokenStartPosition();
        this.tagSourceEnd = this.scanner.getCurrentTokenEndPosition();
        int tk = token;
        char pc = this.peekChar();
        block18: while (tk != 66) {
            this.tagSourceEnd = this.scanner.getCurrentTokenEndPosition();
            token = tk;
            switch (pc) {
                case '!': 
                case '\"': 
                case '#': 
                case '%': 
                case '&': 
                case '\'': 
                case '*': 
                case ':': 
                case '<': 
                case '>': 
                case '}': {
                    break block18;
                }
                default: {
                    if (pc == ' ' || Character.isWhitespace(pc)) break block18;
                    tk = this.readTokenAndConsume();
                    pc = this.peekChar();
                }
            }
        }
        int length = this.tagSourceEnd - this.tagSourceStart + 1;
        char[] tag = new char[length];
        System.arraycopy(this.source, this.tagSourceStart, tag, 0, length);
        this.index = this.tagSourceEnd + 1;
        this.scanner.currentPosition = this.tagSourceEnd + 1;
        this.tagSourceStart = previousPosition;
        this.tagValue = 0;
        boolean valid = true;
        block3 : switch (token) {
            case 26: {
                switch (tag[0]) {
                    case 'd': {
                        if (CharOperation.equals(tag, TAG_DEPRECATED)) {
                            this.deprecated = true;
                            this.tagValue = 1;
                        } else {
                            this.tagValue = 11;
                        }
                        this.createTag();
                        break block3;
                    }
                    case 'i': {
                        if (CharOperation.equals(tag, TAG_INHERITDOC)) {
                            if (this.astPtr == -1) {
                                this.inheritedPositions = ((long)this.tagSourceStart << 32) + (long)this.tagSourceEnd;
                            }
                            this.tagValue = 9;
                        } else {
                            this.tagValue = 11;
                        }
                        this.createTag();
                        break block3;
                    }
                    case 'p': {
                        if (CharOperation.equals(tag, TAG_PARAM)) {
                            this.tagValue = 2;
                            valid = this.parseParam();
                            break block3;
                        }
                        this.tagValue = 11;
                        this.createTag();
                        break block3;
                    }
                    case 'e': {
                        if (CharOperation.equals(tag, TAG_EXCEPTION)) {
                            this.tagValue = 5;
                            valid = this.parseThrows();
                            break block3;
                        }
                        this.tagValue = 11;
                        this.createTag();
                        break block3;
                    }
                    case 's': {
                        if (CharOperation.equals(tag, TAG_SEE)) {
                            this.tagValue = 6;
                            if (this.inlineTagStarted) {
                                valid = false;
                                break block3;
                            }
                            valid = this.parseReference();
                            break block3;
                        }
                        this.tagValue = 11;
                        this.createTag();
                        break block3;
                    }
                    case 'l': {
                        if (CharOperation.equals(tag, TAG_LINK)) {
                            this.tagValue = 7;
                        } else if (CharOperation.equals(tag, TAG_LINKPLAIN)) {
                            this.tagValue = 8;
                        }
                        if (this.tagValue != 0) {
                            if (this.inlineTagStarted) {
                                valid = this.parseReference();
                                break block3;
                            }
                            valid = false;
                            break block3;
                        }
                        this.tagValue = 11;
                        this.createTag();
                        break block3;
                    }
                    case 'v': {
                        if (this.jdk15 && CharOperation.equals(tag, TAG_VALUE)) {
                            this.tagValue = 10;
                            if (this.inlineTagStarted) {
                                valid = this.parseReference();
                                break block3;
                            }
                            valid = false;
                            break block3;
                        }
                        this.tagValue = 11;
                        this.createTag();
                        break block3;
                    }
                }
                this.tagValue = 11;
                this.createTag();
                break;
            }
            case 80: {
                this.tagValue = 3;
                valid = this.parseReturn();
                break;
            }
            case 105: {
                this.tagValue = 4;
                valid = this.parseThrows();
                break;
            }
            case 15: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: {
                this.tagValue = 11;
                this.createTag();
            }
        }
        this.textStart = this.index;
        return valid;
    }

    protected boolean pushParamName(boolean isTypeParam) {
        int idIndex = isTypeParam ? 1 : 0;
        SimpleName name = new SimpleName(this.ast);
        name.internalSetIdentifier(new String(this.identifierStack[idIndex]));
        int nameStart = (int)(this.identifierPositionStack[idIndex] >>> 32);
        int nameEnd = (int)(this.identifierPositionStack[idIndex] & 0xFFFFFFFFL);
        name.setSourceRange(nameStart, nameEnd - nameStart + 1);
        TagElement paramTag = this.ast.newTagElement();
        paramTag.setTagName("@param");
        if (isTypeParam) {
            TextElement text = this.ast.newTextElement();
            text.setText(new String(this.identifierStack[0]));
            int txtStart = (int)(this.identifierPositionStack[0] >>> 32);
            int txtEnd = (int)(this.identifierPositionStack[0] & 0xFFFFFFFFL);
            text.setSourceRange(txtStart, txtEnd - txtStart + 1);
            paramTag.fragments().add(text);
            paramTag.fragments().add(name);
            text = this.ast.newTextElement();
            text.setText(new String(this.identifierStack[2]));
            txtStart = (int)(this.identifierPositionStack[2] >>> 32);
            txtEnd = (int)(this.identifierPositionStack[2] & 0xFFFFFFFFL);
            text.setSourceRange(txtStart, txtEnd - txtStart + 1);
            paramTag.fragments().add(text);
            paramTag.setSourceRange(this.tagSourceStart, txtEnd - this.tagSourceStart + 1);
        } else {
            paramTag.setSourceRange(this.tagSourceStart, nameEnd - this.tagSourceStart + 1);
            paramTag.fragments().add(name);
        }
        this.pushOnAstStack(paramTag, true);
        return true;
    }

    protected boolean pushSeeRef(Object statement) {
        TagElement seeTag = this.ast.newTagElement();
        ASTNode node = (ASTNode)statement;
        seeTag.fragments().add(node);
        int end = node.getStartPosition() + node.getLength() - 1;
        if (this.inlineTagStarted) {
            seeTag.setSourceRange(this.inlineTagStart, end - this.inlineTagStart + 1);
            switch (this.tagValue) {
                case 7: {
                    seeTag.setTagName("@link");
                    break;
                }
                case 8: {
                    seeTag.setTagName("@linkplain");
                    break;
                }
                case 10: {
                    seeTag.setTagName("@value");
                }
            }
            TagElement previousTag = null;
            int previousStart = this.inlineTagStart;
            if (this.astPtr == -1) {
                previousTag = this.ast.newTagElement();
                this.pushOnAstStack(previousTag, true);
            } else {
                previousTag = (TagElement)this.astStack[this.astPtr];
                previousStart = previousTag.getStartPosition();
            }
            previousTag.fragments().add(seeTag);
            previousTag.setSourceRange(previousStart, end - previousStart + 1);
        } else {
            seeTag.setTagName("@see");
            seeTag.setSourceRange(this.tagSourceStart, end - this.tagSourceStart + 1);
            this.pushOnAstStack(seeTag, true);
        }
        return true;
    }

    protected void pushText(int start, int end) {
        TextElement text = this.ast.newTextElement();
        text.setText(new String(this.source, start, end - start));
        text.setSourceRange(start, end - start);
        TagElement previousTag = null;
        int previousStart = start;
        if (this.astPtr == -1) {
            previousTag = this.ast.newTagElement();
            previousTag.setSourceRange(start, end - start);
            this.pushOnAstStack(previousTag, true);
        } else {
            previousTag = (TagElement)this.astStack[this.astPtr];
            previousStart = previousTag.getStartPosition();
        }
        if (this.inlineTagStarted) {
            if (previousTag.fragments().size() == 0) {
                TagElement inlineTag = this.ast.newTagElement();
                previousTag.fragments().add(inlineTag);
                previousTag = inlineTag;
            } else {
                ASTNode inlineTag = (ASTNode)previousTag.fragments().get(previousTag.fragments().size() - 1);
                if (inlineTag.getNodeType() == 65) {
                    previousTag = (TagElement)inlineTag;
                    previousStart = previousTag.getStartPosition();
                }
            }
        }
        previousTag.fragments().add(text);
        previousTag.setSourceRange(previousStart, end - previousStart);
        this.textStart = -1;
    }

    protected void refreshInlineTagPosition(int previousPosition) {
        if (this.astPtr != -1) {
            TagElement previousTag = (TagElement)this.astStack[this.astPtr];
            if (this.inlineTagStarted) {
                ASTNode inlineTag;
                int previousStart = previousTag.getStartPosition();
                previousTag.setSourceRange(previousStart, previousPosition - previousStart + 1);
                if (previousTag.fragments().size() > 0 && (inlineTag = (ASTNode)previousTag.fragments().get(previousTag.fragments().size() - 1)).getNodeType() == 65) {
                    int inlineStart = inlineTag.getStartPosition();
                    inlineTag.setSourceRange(inlineStart, previousPosition - inlineStart + 1);
                }
            }
        }
    }

    protected boolean pushThrowName(Object typeRef) {
        TagElement throwsTag = this.ast.newTagElement();
        switch (this.tagValue) {
            case 4: {
                throwsTag.setTagName("@throws");
                break;
            }
            case 5: {
                throwsTag.setTagName("@exception");
            }
        }
        throwsTag.setSourceRange(this.tagSourceStart, this.scanner.getCurrentTokenEndPosition() - this.tagSourceStart + 1);
        throwsTag.fragments().add(typeRef);
        this.pushOnAstStack(throwsTag, true);
        return true;
    }

    protected void updateDocComment() {
        int idx = 0;
        while (idx <= this.astPtr) {
            this.docComment.tags().add(this.astStack[idx]);
            ++idx;
        }
    }
}

