/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish.upload;

import com.gradle.publish.plugin.dep.org.apache.commons.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class Uploader {
    public static void putFile(File file, String targetUrl) throws IOException {
        Uploader.putStream(new FileInputStream(file), file.getAbsolutePath(), targetUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putStream(InputStream src, String srcDesc, String targetUrl) throws IOException {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(targetUrl).openConnection();
            conn.setRequestMethod("PUT");
            conn.setDoOutput(true);
            conn.connect();
            try (OutputStream os = conn.getOutputStream();){
                IOUtils.copy(src, os);
            }
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                String msg = conn.getResponseMessage();
                throw new IOException("Unexpected HTTP response while uploading " + srcDesc + ": " + responseCode + (msg != null && !msg.isEmpty() ? " " + msg : ""));
            }
        }
        finally {
            try {
                src.close();
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
    }
}

