/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish.plugin.dep.oauth.signpost;

import com.gradle.publish.plugin.dep.oauth.signpost.OAuth;
import com.gradle.publish.plugin.dep.oauth.signpost.OAuthConsumer;
import com.gradle.publish.plugin.dep.oauth.signpost.OAuthProvider;
import com.gradle.publish.plugin.dep.oauth.signpost.OAuthProviderListener;
import com.gradle.publish.plugin.dep.oauth.signpost.exception.OAuthCommunicationException;
import com.gradle.publish.plugin.dep.oauth.signpost.exception.OAuthExpectationFailedException;
import com.gradle.publish.plugin.dep.oauth.signpost.exception.OAuthMessageSignerException;
import com.gradle.publish.plugin.dep.oauth.signpost.exception.OAuthNotAuthorizedException;
import com.gradle.publish.plugin.dep.oauth.signpost.http.HttpParameters;
import com.gradle.publish.plugin.dep.oauth.signpost.http.HttpRequest;
import com.gradle.publish.plugin.dep.oauth.signpost.http.HttpResponse;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOAuthProvider
implements OAuthProvider {
    private static final long serialVersionUID = 1L;
    private String requestTokenEndpointUrl;
    private String accessTokenEndpointUrl;
    private String authorizationWebsiteUrl;
    private HttpParameters responseParameters;
    private Map<String, String> defaultHeaders;
    private boolean isOAuth10a;
    private transient OAuthProviderListener listener;

    public AbstractOAuthProvider(String requestTokenEndpointUrl, String accessTokenEndpointUrl, String authorizationWebsiteUrl) {
        this.requestTokenEndpointUrl = requestTokenEndpointUrl;
        this.accessTokenEndpointUrl = accessTokenEndpointUrl;
        this.authorizationWebsiteUrl = authorizationWebsiteUrl;
        this.responseParameters = new HttpParameters();
        this.defaultHeaders = new HashMap<String, String>();
    }

    @Override
    public synchronized String retrieveRequestToken(OAuthConsumer consumer, String callbackUrl, String ... customOAuthParams) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException {
        consumer.setTokenWithSecret(null, null);
        HttpParameters params = new HttpParameters();
        params.putAll(customOAuthParams, true);
        params.put("oauth_callback", callbackUrl, true);
        this.retrieveToken(consumer, this.requestTokenEndpointUrl, params);
        String callbackConfirmed = this.responseParameters.getFirst("oauth_callback_confirmed");
        this.responseParameters.remove("oauth_callback_confirmed");
        this.isOAuth10a = Boolean.TRUE.toString().equals(callbackConfirmed);
        if (this.isOAuth10a) {
            return OAuth.addQueryParameters(this.authorizationWebsiteUrl, "oauth_token", consumer.getToken());
        }
        return OAuth.addQueryParameters(this.authorizationWebsiteUrl, "oauth_token", consumer.getToken(), "oauth_callback", callbackUrl);
    }

    @Override
    public synchronized void retrieveAccessToken(OAuthConsumer consumer, String oauthVerifier, String ... customOAuthParams) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException {
        if (consumer.getToken() == null || consumer.getTokenSecret() == null) {
            throw new OAuthExpectationFailedException("Authorized request token or token secret not set. Did you retrieve an authorized request token before?");
        }
        HttpParameters params = new HttpParameters();
        params.putAll(customOAuthParams, true);
        if (this.isOAuth10a && oauthVerifier != null) {
            params.put("oauth_verifier", oauthVerifier, true);
        }
        this.retrieveToken(consumer, this.accessTokenEndpointUrl, params);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void retrieveToken(OAuthConsumer consumer, String endpointUrl, HttpParameters customOAuthParams) throws OAuthMessageSignerException, OAuthCommunicationException, OAuthNotAuthorizedException, OAuthExpectationFailedException {
        int statusCode;
        HttpResponse response;
        HttpRequest request;
        block21: {
            Map<String, String> defaultHeaders = this.getRequestHeaders();
            if (consumer.getConsumerKey() == null) throw new OAuthExpectationFailedException("Consumer key or secret not set");
            if (consumer.getConsumerSecret() == null) {
                throw new OAuthExpectationFailedException("Consumer key or secret not set");
            }
            request = null;
            response = null;
            request = this.createRequest(endpointUrl);
            for (String header : defaultHeaders.keySet()) {
                request.setHeader(header, defaultHeaders.get(header));
            }
            if (customOAuthParams != null && !customOAuthParams.isEmpty()) {
                consumer.setAdditionalParameters(customOAuthParams);
            }
            if (this.listener != null) {
                this.listener.prepareRequest(request);
            }
            consumer.sign(request);
            if (this.listener != null) {
                this.listener.prepareSubmission(request);
            }
            response = this.sendRequest(request);
            statusCode = response.getStatusCode();
            boolean requestHandled = false;
            if (this.listener != null) {
                requestHandled = this.listener.onResponseReceived(request, response);
            }
            if (!requestHandled) break block21;
            try {
                this.closeConnection(request, response);
                return;
            }
            catch (Exception e) {
                throw new OAuthCommunicationException(e);
            }
        }
        if (statusCode >= 300) {
            this.handleUnexpectedResponse(statusCode, response);
        }
        HttpParameters responseParams = OAuth.decodeForm(response.getContent());
        String token = responseParams.getFirst("oauth_token");
        String secret = responseParams.getFirst("oauth_token_secret");
        responseParams.remove("oauth_token");
        responseParams.remove("oauth_token_secret");
        this.setResponseParameters(responseParams);
        if (token == null) throw new OAuthExpectationFailedException("Request token or token secret not set in server reply. The service provider you use is probably buggy.");
        if (secret == null) {
            throw new OAuthExpectationFailedException("Request token or token secret not set in server reply. The service provider you use is probably buggy.");
        }
        consumer.setTokenWithSecret(token, secret);
        try {
            this.closeConnection(request, response);
            return;
        }
        catch (Exception e) {
            throw new OAuthCommunicationException(e);
        }
        catch (OAuthNotAuthorizedException e) {
            try {
                throw e;
                catch (OAuthExpectationFailedException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new OAuthCommunicationException(e3);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.closeConnection(request, response);
                    throw throwable;
                }
                catch (Exception e4) {
                    throw new OAuthCommunicationException(e4);
                }
            }
        }
    }

    protected void handleUnexpectedResponse(int statusCode, HttpResponse response) throws Exception {
        if (response == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getContent()));
        StringBuilder responseBody = new StringBuilder();
        String line = reader.readLine();
        while (line != null) {
            responseBody.append(line);
            line = reader.readLine();
        }
        switch (statusCode) {
            case 401: {
                throw new OAuthNotAuthorizedException(responseBody.toString());
            }
        }
        throw new OAuthCommunicationException("Service provider responded in error: " + statusCode + " (" + response.getReasonPhrase() + ")", responseBody.toString());
    }

    protected abstract HttpRequest createRequest(String var1) throws Exception;

    protected abstract HttpResponse sendRequest(HttpRequest var1) throws Exception;

    protected void closeConnection(HttpRequest request, HttpResponse response) throws Exception {
    }

    @Override
    public HttpParameters getResponseParameters() {
        return this.responseParameters;
    }

    protected String getResponseParameter(String key) {
        return this.responseParameters.getFirst(key);
    }

    @Override
    public void setResponseParameters(HttpParameters parameters) {
        this.responseParameters = parameters;
    }

    @Override
    public void setOAuth10a(boolean isOAuth10aProvider) {
        this.isOAuth10a = isOAuth10aProvider;
    }

    @Override
    public boolean isOAuth10a() {
        return this.isOAuth10a;
    }

    @Override
    public String getRequestTokenEndpointUrl() {
        return this.requestTokenEndpointUrl;
    }

    @Override
    public String getAccessTokenEndpointUrl() {
        return this.accessTokenEndpointUrl;
    }

    @Override
    public String getAuthorizationWebsiteUrl() {
        return this.authorizationWebsiteUrl;
    }

    @Override
    public void setRequestHeader(String header, String value) {
        this.defaultHeaders.put(header, value);
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.defaultHeaders;
    }

    @Override
    public void setListener(OAuthProviderListener listener) {
        this.listener = listener;
    }

    @Override
    public void removeListener(OAuthProviderListener listener) {
        this.listener = null;
    }
}

