/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish.plugin.dep.com.google.gson.internal.bind;

import com.gradle.publish.plugin.dep.com.google.gson.Gson;
import com.gradle.publish.plugin.dep.com.google.gson.TypeAdapter;
import com.gradle.publish.plugin.dep.com.google.gson.TypeAdapterFactory;
import com.gradle.publish.plugin.dep.com.google.gson.internal.$Gson$Types;
import com.gradle.publish.plugin.dep.com.google.gson.internal.ConstructorConstructor;
import com.gradle.publish.plugin.dep.com.google.gson.internal.ObjectConstructor;
import com.gradle.publish.plugin.dep.com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.gradle.publish.plugin.dep.com.google.gson.reflect.TypeToken;
import com.gradle.publish.plugin.dep.com.google.gson.stream.JsonReader;
import com.gradle.publish.plugin.dep.com.google.gson.stream.JsonToken;
import com.gradle.publish.plugin.dep.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public CollectionTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class<T> rawType = typeToken.getRawType();
        if (!Collection.class.isAssignableFrom(rawType)) {
            return null;
        }
        Type elementType = $Gson$Types.getCollectionElementType(type, rawType);
        TypeAdapter<?> elementTypeAdapter = gson.getAdapter(TypeToken.get(elementType));
        ObjectConstructor<T> constructor = this.constructorConstructor.get(typeToken);
        Adapter result = new Adapter(gson, elementType, elementTypeAdapter, constructor);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Adapter<E>
    extends TypeAdapter<Collection<E>> {
        private final TypeAdapter<E> elementTypeAdapter;
        private final ObjectConstructor<? extends Collection<E>> constructor;

        public Adapter(Gson context, Type elementType, TypeAdapter<E> elementTypeAdapter, ObjectConstructor<? extends Collection<E>> constructor) {
            this.elementTypeAdapter = new TypeAdapterRuntimeTypeWrapper<E>(context, elementTypeAdapter, elementType);
            this.constructor = constructor;
        }

        @Override
        public Collection<E> read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            Collection<E> collection = this.constructor.construct();
            in.beginArray();
            while (in.hasNext()) {
                E instance = this.elementTypeAdapter.read(in);
                collection.add(instance);
            }
            in.endArray();
            return collection;
        }

        @Override
        public void write(JsonWriter out, Collection<E> collection) throws IOException {
            if (collection == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (E element : collection) {
                this.elementTypeAdapter.write(out, element);
            }
            out.endArray();
        }
    }
}

