/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin;

import com.gradle.enterprise.version.a.c;
import com.gradle.enterprise.version.buildagent.BuildAgentToolVersion;
import com.gradle.obfuscation.Keep;
import com.gradle.scan.plugin.BuildScanException;
import com.gradle.scan.plugin.internal.a;
import com.gradle.scan.plugin.internal.d;
import com.gradle.scan.plugin.internal.i;
import javax.annotation.Nonnull;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;

public final class BuildScanPlugin
implements Plugin<Object> {
    private static final d a = new d(BuildScanPlugin.class, "build scan");

    @Keep
    public void apply(@Nonnull Object object) {
        BuildAgentToolVersion buildAgentToolVersion;
        Gradle gradle;
        Project project;
        if (object instanceof Project) {
            project = (Project)object;
            gradle = project.getGradle();
            buildAgentToolVersion = com.gradle.scan.plugin.internal.a.a(gradle);
            BuildScanPlugin.a(buildAgentToolVersion);
            BuildScanPlugin.b(project);
            BuildScanPlugin.c(project);
            if (BuildScanPlugin.a(project)) {
                return;
            }
        } else {
            throw new BuildScanException("The build scan plugin must be applied to the root project (was applied to " + BuildScanPlugin.pluginApplicationTargetDisplayName(object) + ")");
        }
        com.gradle.scan.plugin.internal.a.a(a.a.FIRST_OF_FIRST, buildAgentToolVersion, gradle, project.getRootDir(), null, a, action -> action.execute((Object)project));
    }

    public static String pluginApplicationTargetDisplayName(@Nonnull Object object) {
        if (object instanceof Project) {
            return "a project";
        }
        if (object instanceof Settings) {
            return "settings";
        }
        if (object instanceof Gradle) {
            return "init script";
        }
        return object.getClass().getName();
    }

    private static boolean a(Project project) {
        return project.getPlugins().stream().anyMatch(plugin -> plugin.getClass().getName().equals(BuildScanPlugin.class.getName()));
    }

    private static void b(Project project) {
        if (!project.equals(project.getRootProject())) {
            throw new BuildScanException("The Gradle Enterprise plugin can only be applied to the root project.");
        }
    }

    private static void c(Project rootProject) {
        if (rootProject.getState().getExecuted()) {
            throw new BuildScanException(i.a("The Gradle Enterprise plugin must be applied early in the build lifecycle.", "Fixing this problem requires changing how you are applying the Gradle Enterprise plugin to your build.", "", "Please see https://gradle.com/help/plugin-late-apply for how to resolve this problem."));
        }
    }

    private static void a(BuildAgentToolVersion buildAgentToolVersion) {
        if (buildAgentToolVersion.a(c.I)) {
            throw new BuildScanException(i.a(new String[]{"The build scan plugin is not compatible with Gradle 6.0 and later.", "Please use the Gradle Enterprise plugin instead."}));
        }
        if (!buildAgentToolVersion.a(c.X)) {
            if (buildAgentToolVersion.a(c.aF)) {
                throw new BuildScanException(i.a(new String[]{"This version of the build scan plugin is not compatible with less than Gradle 5.0.", "Please use version 1.16 of the build scan plugin."}));
            }
            throw new BuildScanException(i.a(new String[]{"Build scans are not supported for Gradle 1.x.", "Please use a newer version of Gradle."}));
        }
    }
}

