/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.eventmodel;

import com.gradle.scan.eventmodel.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public final class Preconditions {
    public static void a(@Nullable Object reference) {
        if (reference != null) {
            throw new IllegalArgumentException(reference + " is not null!");
        }
    }

    public static <T> T b(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T a(T reference, Supplier<Object> errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage.get().toString());
        }
        return reference;
    }

    public static void a(boolean expression, Supplier<Object> errorMessage) {
        if (!expression) {
            throw new IllegalStateException(errorMessage.get().toString());
        }
    }

    public static void a(Object o1, Object o2) {
        if (!Objects.equals(o1, o2)) {
            throw new IllegalStateException(o1 + " != " + o2);
        }
    }

    public static void b(boolean expression, Supplier<Object> errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage.get().toString());
        }
    }

    public static int a(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + " cannot be negative but was: " + value);
        }
        return value;
    }

    public static String a(String value, String name) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("'" + name + "' cannot be empty");
        }
        return value;
    }

    public static <T extends Collection<?>> T a(T values, Supplier<Object> errorMessage) {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException(errorMessage.get().toString());
        }
        return values;
    }

    public static <T> List<T> a(@Nullable List<T> list) {
        if (list != null) {
            list.forEach(Preconditions::b);
        }
        return list;
    }

    public static <K, V> Map<K, V> a(@Nullable Map<K, V> map) {
        if (map != null) {
            map.forEach((k2, v2) -> {
                Preconditions.b(k2);
                if (v2 instanceof Map) {
                    Preconditions.a((Map)v2);
                } else {
                    Preconditions.b(v2);
                }
            });
        }
        return map;
    }

    private Preconditions() {
    }
}

