/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Utf8StringBuilder;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.WebSocketConnectionListener;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.WebSocketFrameListener;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.WebSocketListener;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.WebSocketPartialListener;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.WebSocketPingPongListener;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.CloseInfo;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.events.AbstractEventDriver;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.frames.ReadOnlyDelegatedFrame;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.message.SimpleBinaryMessage;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.message.SimpleTextMessage;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.util.TextUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class JettyListenerEventDriver
extends AbstractEventDriver {
    private static final Logger LOG = Log.getLogger(JettyListenerEventDriver.class);
    private final WebSocketConnectionListener listener;
    private Utf8StringBuilder utf8Partial;
    private PartialMode partialMode = PartialMode.NONE;
    private boolean hasCloseBeenCalled = false;

    public JettyListenerEventDriver(WebSocketPolicy webSocketPolicy, WebSocketConnectionListener webSocketConnectionListener) {
        super(webSocketPolicy, webSocketConnectionListener);
        this.listener = Objects.requireNonNull(webSocketConnectionListener, "Listener may not be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("ctor / listener={}, policy={}", webSocketConnectionListener.getClass().getName(), webSocketPolicy);
        }
    }

    @Override
    public void onBinaryFrame(ByteBuffer byteBuffer, boolean bl2) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBinaryFrame({}, {}) - webSocketListener={}, webSocketPartialListener={}, listener={}, activeMessage={}", BufferUtil.toDetailString(byteBuffer), bl2, this.listener instanceof WebSocketListener, this.listener instanceof WebSocketPartialListener, this.listener.getClass().getName(), this.activeMessage);
        }
        if (this.listener instanceof WebSocketListener) {
            if (this.activeMessage == null) {
                this.activeMessage = new SimpleBinaryMessage(this);
            }
            this.appendMessage(byteBuffer, bl2);
        }
        if (this.listener instanceof WebSocketPartialListener) {
            switch (this.partialMode) {
                case NONE: {
                    this.partialMode = PartialMode.BINARY;
                }
                case BINARY: {
                    ((WebSocketPartialListener)this.listener).onWebSocketPartialBinary(byteBuffer.slice().asReadOnlyBuffer(), bl2);
                    break;
                }
                case TEXT: {
                    throw new IOException("Out of order binary frame encountered");
                }
            }
            if (bl2) {
                this.partialMode = PartialMode.NONE;
            }
        }
    }

    @Override
    public void onBinaryMessage(byte[] byArray) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onBinaryMessage([{}]) - webSocketListener={}, listener={}", byArray.length, this.listener instanceof WebSocketListener, this.listener.getClass().getName());
        }
        if (this.listener instanceof WebSocketListener) {
            ((WebSocketListener)this.listener).onWebSocketBinary(byArray, 0, byArray.length);
        }
    }

    @Override
    public void onClose(CloseInfo closeInfo) {
        if (this.hasCloseBeenCalled) {
            return;
        }
        this.hasCloseBeenCalled = true;
        int n2 = closeInfo.getStatusCode();
        String string = closeInfo.getReason();
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClose({},{}) - listener={}", n2, string, this.listener.getClass().getName());
        }
        this.listener.onWebSocketClose(n2, string);
    }

    @Override
    public void onConnect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onConnect({}) - listener={}", this.session, this.listener.getClass().getName());
        }
        this.listener.onWebSocketConnect(this.session);
    }

    @Override
    public void onError(Throwable throwable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onError({}) - listener={}", throwable.getClass().getName(), this.listener.getClass().getName());
        }
        this.listener.onWebSocketError(throwable);
    }

    @Override
    public void onFrame(Frame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFrame({}) - frameListener={}, pingPongListener={}, listener={}", frame, this.listener instanceof WebSocketFrameListener, this.listener instanceof WebSocketPingPongListener, this.listener.getClass().getName());
        }
        if (this.listener instanceof WebSocketFrameListener) {
            ((WebSocketFrameListener)this.listener).onWebSocketFrame(new ReadOnlyDelegatedFrame(frame));
        }
        if (this.listener instanceof WebSocketPingPongListener) {
            if (frame.getType() == Frame.Type.PING) {
                ((WebSocketPingPongListener)this.listener).onWebSocketPing(frame.getPayload().asReadOnlyBuffer());
            } else if (frame.getType() == Frame.Type.PONG) {
                ((WebSocketPingPongListener)this.listener).onWebSocketPong(frame.getPayload().asReadOnlyBuffer());
            }
        }
    }

    @Override
    public void onTextFrame(ByteBuffer byteBuffer, boolean bl2) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onTextFrame({}, {}) - webSocketListener={}, webSocketPartialListener={}, listener={}, activeMessage={}", BufferUtil.toDetailString(byteBuffer), bl2, this.listener instanceof WebSocketListener, this.listener instanceof WebSocketPartialListener, this.listener.getClass().getName(), this.activeMessage);
        }
        if (this.listener instanceof WebSocketListener) {
            if (this.activeMessage == null) {
                this.activeMessage = new SimpleTextMessage(this);
            }
            this.appendMessage(byteBuffer, bl2);
        }
        if (this.listener instanceof WebSocketPartialListener) {
            switch (this.partialMode) {
                case NONE: {
                    this.partialMode = PartialMode.TEXT;
                }
                case TEXT: {
                    if (this.utf8Partial == null) {
                        this.utf8Partial = new Utf8StringBuilder();
                    }
                    String string = "";
                    if (byteBuffer != null) {
                        this.utf8Partial.append(byteBuffer);
                        string = this.utf8Partial.takePartialString();
                    }
                    ((WebSocketPartialListener)this.listener).onWebSocketPartialText(string, bl2);
                    if (!bl2) break;
                    this.utf8Partial = null;
                    break;
                }
                case BINARY: {
                    throw new IOException("Out of order text frame encountered");
                }
            }
            if (bl2) {
                this.partialMode = PartialMode.NONE;
            }
        }
    }

    @Override
    public void onTextMessage(String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onTextMessage([{}] \"{}\") - webSocketListener={}, listener={}", string.length(), TextUtil.maxStringLength(60, string), this.listener instanceof WebSocketListener, this.listener.getClass().getName());
        }
        if (this.listener instanceof WebSocketListener) {
            ((WebSocketListener)this.listener).onWebSocketText(string);
        }
    }

    @Override
    public void onContinuationFrame(ByteBuffer byteBuffer, boolean bl2) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onContinuationFrame({}, {}) - webSocketListener={}, webSocketPartialListener={}, listener={}, activeMessage={}", BufferUtil.toDetailString(byteBuffer), bl2, this.listener instanceof WebSocketListener, this.listener instanceof WebSocketPartialListener, this.listener.getClass().getName(), this.activeMessage);
        }
        if (this.listener instanceof WebSocketPartialListener) {
            switch (this.partialMode) {
                case NONE: {
                    throw new IOException("Out of order Continuation frame encountered");
                }
                case TEXT: {
                    this.onTextFrame(byteBuffer, bl2);
                    break;
                }
                case BINARY: {
                    this.onBinaryFrame(byteBuffer, bl2);
                }
            }
            return;
        }
        if (this.listener instanceof WebSocketListener) {
            super.onContinuationFrame(byteBuffer, bl2);
        }
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", JettyListenerEventDriver.class.getSimpleName(), this.listener.getClass().getName());
    }

    private static enum PartialMode {
        NONE,
        TEXT,
        BINARY;

    }
}

