/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class QuotedStringTokenizer
extends StringTokenizer {
    private String _string;
    private String _delim = "\t\n\r";
    private boolean _returnQuotes = false;
    private boolean _returnDelimiters = false;
    private StringBuffer _token;
    private boolean _hasToken = false;
    private int _i = 0;
    private int _lastStart = 0;
    private boolean _double = true;
    private boolean _single = true;
    private static final char[] escapes = new char[32];

    public QuotedStringTokenizer(String string, String string2, boolean bl2, boolean bl3) {
        super("");
        this._string = string;
        if (string2 != null) {
            this._delim = string2;
        }
        this._returnDelimiters = bl2;
        this._returnQuotes = bl3;
        if (this._delim.indexOf(39) >= 0 || this._delim.indexOf(34) >= 0) {
            throw new Error("Can't use quotes as delimiters: " + this._delim);
        }
        this._token = new StringBuffer(this._string.length() > 1024 ? 512 : this._string.length() / 2);
    }

    public QuotedStringTokenizer(String string, String string2) {
        this(string, string2, false, false);
    }

    @Override
    public boolean hasMoreTokens() {
        if (this._hasToken) {
            return true;
        }
        this._lastStart = this._i;
        int n2 = 0;
        boolean bl2 = false;
        while (this._i < this._string.length()) {
            char c2 = this._string.charAt(this._i++);
            switch (n2) {
                case 0: {
                    if (this._delim.indexOf(c2) >= 0) {
                        if (!this._returnDelimiters) break;
                        this._token.append(c2);
                        this._hasToken = true;
                        return true;
                    }
                    if (c2 == '\'' && this._single) {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        n2 = 2;
                        break;
                    }
                    if (c2 == '\"' && this._double) {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        n2 = 3;
                        break;
                    }
                    this._token.append(c2);
                    this._hasToken = true;
                    n2 = 1;
                    break;
                }
                case 1: {
                    this._hasToken = true;
                    if (this._delim.indexOf(c2) >= 0) {
                        if (this._returnDelimiters) {
                            --this._i;
                        }
                        return this._hasToken;
                    }
                    if (c2 == '\'' && this._single) {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        n2 = 2;
                        break;
                    }
                    if (c2 == '\"' && this._double) {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        n2 = 3;
                        break;
                    }
                    this._token.append(c2);
                    break;
                }
                case 2: {
                    this._hasToken = true;
                    if (bl2) {
                        bl2 = false;
                        this._token.append(c2);
                        break;
                    }
                    if (c2 == '\'') {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        n2 = 1;
                        break;
                    }
                    if (c2 == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        bl2 = true;
                        break;
                    }
                    this._token.append(c2);
                    break;
                }
                case 3: {
                    this._hasToken = true;
                    if (bl2) {
                        bl2 = false;
                        this._token.append(c2);
                        break;
                    }
                    if (c2 == '\"') {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        n2 = 1;
                        break;
                    }
                    if (c2 == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c2);
                        }
                        bl2 = true;
                        break;
                    }
                    this._token.append(c2);
                }
            }
        }
        return this._hasToken;
    }

    @Override
    public String nextToken() throws NoSuchElementException {
        if (!this.hasMoreTokens() || this._token == null) {
            throw new NoSuchElementException();
        }
        String string = this._token.toString();
        this._token.setLength(0);
        this._hasToken = false;
        return string;
    }

    @Override
    public String nextToken(String string) throws NoSuchElementException {
        this._delim = string;
        this._i = this._lastStart;
        this._token.setLength(0);
        this._hasToken = false;
        return this.nextToken();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    @Override
    public Object nextElement() throws NoSuchElementException {
        return this.nextToken();
    }

    @Override
    public int countTokens() {
        return -1;
    }

    static {
        Arrays.fill(escapes, '\uffff');
        QuotedStringTokenizer.escapes[8] = 98;
        QuotedStringTokenizer.escapes[9] = 116;
        QuotedStringTokenizer.escapes[10] = 110;
        QuotedStringTokenizer.escapes[12] = 102;
        QuotedStringTokenizer.escapes[13] = 114;
    }
}

