/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.ConstantThrowable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class FutureCallback
implements Future<Void>,
Callback {
    private static final Throwable COMPLETED = new ConstantThrowable();
    public static final FutureCallback SUCCEEDED = new FutureCallback(true);
    private final AtomicBoolean _done = new AtomicBoolean(false);
    private final CountDownLatch _latch = new CountDownLatch(1);
    private Throwable _cause;

    public FutureCallback() {
    }

    public FutureCallback(boolean bl2) {
        if (bl2) {
            this._cause = COMPLETED;
            this._done.set(true);
            this._latch.countDown();
        }
    }

    @Override
    public void succeeded() {
        if (this._done.compareAndSet(false, true)) {
            this._cause = COMPLETED;
            this._latch.countDown();
        }
    }

    @Override
    public void failed(Throwable throwable) {
        if (this._done.compareAndSet(false, true)) {
            this._cause = throwable;
            this._latch.countDown();
        }
    }

    @Override
    public boolean cancel(boolean bl2) {
        if (this._done.compareAndSet(false, true)) {
            this._cause = new CancellationException();
            this._latch.countDown();
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        if (this._done.get()) {
            try {
                this._latch.await();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            return this._cause instanceof CancellationException;
        }
        return false;
    }

    @Override
    public boolean isDone() {
        return this._done.get() && this._latch.getCount() == 0L;
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        this._latch.await();
        if (this._cause == COMPLETED) {
            return null;
        }
        if (this._cause instanceof CancellationException) {
            throw (CancellationException)new CancellationException().initCause(this._cause);
        }
        throw new ExecutionException(this._cause);
    }

    @Override
    public Void get(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this._latch.await(l2, timeUnit)) {
            throw new TimeoutException();
        }
        if (this._cause == COMPLETED) {
            return null;
        }
        if (this._cause instanceof TimeoutException) {
            throw (TimeoutException)this._cause;
        }
        if (this._cause instanceof CancellationException) {
            throw (CancellationException)new CancellationException().initCause(this._cause);
        }
        throw new ExecutionException(this._cause);
    }

    public String toString() {
        return String.format("FutureCallback@%x{%b,%b}", this.hashCode(), this._done.get(), this._cause == COMPLETED);
    }
}

