/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.BadMessageException;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HostPortHttpField;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpCompliance;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpComplianceSection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpHeaderValue;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpMethod;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpTokens;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpVersion;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.PreEncodedHttpField;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.QuotedCSV;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.ArrayTernaryTrie;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.ArrayTrie;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Trie;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Utf8StringBuilder;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;

public class HttpParser {
    public static final Logger LOG = Log.getLogger(HttpParser.class);
    public static final Trie<HttpField> CACHE = new ArrayTrie<HttpField>(2048);
    private static final Trie<HttpField> NO_CACHE = Trie.empty(true);
    private static final EnumSet<State> __idleStates = EnumSet.of(State.START, State.END, State.CLOSE, State.CLOSED);
    private static final EnumSet<State> __completeStates = EnumSet.of(State.END, State.CLOSE, State.CLOSED);
    private static final EnumSet<State> __terminatedStates = EnumSet.of(State.CLOSE, State.CLOSED);
    private final boolean debug = LOG.isDebugEnabled();
    private final HttpHandler _handler;
    private final RequestHandler _requestHandler;
    private final ResponseHandler _responseHandler;
    private final ComplianceHandler _complianceHandler;
    private final int _maxHeaderBytes;
    private final HttpCompliance _compliance;
    private final EnumSet<HttpComplianceSection> _compliances;
    private final Utf8StringBuilder _uri = new Utf8StringBuilder(256);
    private HttpField _field;
    private HttpHeader _header;
    private String _headerString;
    private String _valueString;
    private int _responseStatus;
    private int _headerBytes;
    private boolean _host;
    private boolean _headerComplete;
    private volatile State _state = State.START;
    private volatile FieldState _fieldState = FieldState.FIELD;
    private volatile boolean _eof;
    private HttpMethod _method;
    private String _methodString;
    private HttpVersion _version;
    private HttpTokens.EndOfContent _endOfContent;
    private boolean _hasContentLength;
    private boolean _hasTransferEncoding;
    private long _contentLength = -1L;
    private long _contentPosition;
    private int _chunkLength;
    private int _chunkPosition;
    private boolean _headResponse;
    private boolean _cr;
    private ByteBuffer _contentChunk;
    private Trie<HttpField> _fieldCache;
    private int _length;
    private final StringBuilder _string = new StringBuilder();

    private static HttpCompliance compliance() {
        boolean bl2 = Boolean.getBoolean("com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpParser.STRICT");
        if (bl2) {
            LOG.warn("Deprecated property used: org.eclipse.jetty.http.HttpParser.STRICT", new Object[0]);
            return HttpCompliance.LEGACY;
        }
        return HttpCompliance.RFC7230;
    }

    public HttpParser(ResponseHandler responseHandler, int n2, HttpCompliance httpCompliance) {
        this(null, responseHandler, n2, httpCompliance == null ? HttpParser.compliance() : httpCompliance);
    }

    private HttpParser(RequestHandler requestHandler, ResponseHandler responseHandler, int n2, HttpCompliance httpCompliance) {
        this._handler = requestHandler != null ? requestHandler : responseHandler;
        this._requestHandler = requestHandler;
        this._responseHandler = responseHandler;
        this._maxHeaderBytes = n2;
        this._compliance = httpCompliance;
        this._compliances = httpCompliance.sections();
        this._complianceHandler = (ComplianceHandler)(this._handler instanceof ComplianceHandler ? this._handler : null);
    }

    protected boolean complianceViolation(HttpComplianceSection httpComplianceSection) {
        return this.complianceViolation(httpComplianceSection, null);
    }

    protected boolean complianceViolation(HttpComplianceSection httpComplianceSection, String string) {
        if (this._compliances.contains((Object)httpComplianceSection)) {
            return true;
        }
        if (string == null) {
            string = httpComplianceSection.description;
        }
        if (this._complianceHandler != null) {
            this._complianceHandler.onComplianceViolation(this._compliance, httpComplianceSection, string);
        }
        return false;
    }

    protected void handleViolation(HttpComplianceSection httpComplianceSection, String string) {
        if (this._complianceHandler != null) {
            this._complianceHandler.onComplianceViolation(this._compliance, httpComplianceSection, string);
        }
    }

    protected String caseInsensitiveHeader(String string, String string2) {
        if (this._compliances.contains((Object)HttpComplianceSection.FIELD_NAME_CASE_INSENSITIVE)) {
            return string2;
        }
        if (!string.equals(string2)) {
            this.handleViolation(HttpComplianceSection.FIELD_NAME_CASE_INSENSITIVE, string);
        }
        return string;
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public long getContentRead() {
        return this._contentPosition;
    }

    public void setHeadResponse(boolean bl2) {
        this._headResponse = bl2;
    }

    protected void setResponseStatus(int n2) {
        this._responseStatus = n2;
    }

    public boolean isTerminated() {
        return __terminatedStates.contains((Object)this._state);
    }

    private HttpTokens.Token next(ByteBuffer byteBuffer) {
        byte by2 = byteBuffer.get();
        HttpTokens.Token token = HttpTokens.TOKENS[0xFF & by2];
        switch (token.getType()) {
            case CNTL: {
                throw new IllegalCharacterException(this._state, token, byteBuffer);
            }
            case LF: {
                this._cr = false;
                break;
            }
            case CR: {
                if (this._cr) {
                    throw new BadMessageException("Bad EOL");
                }
                this._cr = true;
                if (byteBuffer.hasRemaining()) {
                    if (this._maxHeaderBytes > 0 && (this._state == State.HEADER || this._state == State.TRAILER)) {
                        ++this._headerBytes;
                    }
                    return this.next(byteBuffer);
                }
                return null;
            }
            case ALPHA: 
            case DIGIT: 
            case TCHAR: 
            case VCHAR: 
            case HTAB: 
            case SPACE: 
            case OTEXT: 
            case COLON: {
                if (!this._cr) break;
                throw new BadMessageException("Bad EOL");
            }
        }
        return token;
    }

    private void quickStart(ByteBuffer byteBuffer) {
        HttpTokens.Token token;
        if (this._requestHandler != null) {
            this._method = HttpMethod.lookAheadGet(byteBuffer);
            if (this._method != null) {
                this._methodString = this._method.asString();
                byteBuffer.position(byteBuffer.position() + this._methodString.length() + 1);
                this.setState(State.SPACE1);
                return;
            }
        } else if (this._responseHandler != null) {
            this._version = HttpVersion.lookAheadGet(byteBuffer);
            if (this._version != null) {
                byteBuffer.position(byteBuffer.position() + this._version.asString().length() + 1);
                this.setState(State.SPACE1);
                return;
            }
        }
        while (this._state == State.START && byteBuffer.hasRemaining() && (token = this.next(byteBuffer)) != null) {
            switch (token.getType()) {
                case ALPHA: 
                case DIGIT: 
                case TCHAR: 
                case VCHAR: {
                    this._string.setLength(0);
                    this._string.append(token.getChar());
                    this.setState(this._requestHandler != null ? State.METHOD : State.RESPONSE_VERSION);
                    return;
                }
                case HTAB: 
                case SPACE: 
                case OTEXT: {
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
            }
            if (this._maxHeaderBytes <= 0 || ++this._headerBytes <= this._maxHeaderBytes) continue;
            LOG.warn("padding is too large >" + this._maxHeaderBytes, new Object[0]);
            throw new BadMessageException(400);
        }
    }

    private void setString(String string) {
        this._string.setLength(0);
        this._string.append(string);
        this._length = string.length();
    }

    private String takeString() {
        this._string.setLength(this._length);
        String string = this._string.toString();
        this._string.setLength(0);
        this._length = -1;
        return string;
    }

    private boolean handleHeaderContentMessage() {
        boolean bl2 = this._handler.headerComplete();
        this._headerComplete = true;
        if (bl2) {
            return true;
        }
        this.setState(State.CONTENT_END);
        return this.handleContentMessage();
    }

    private boolean handleContentMessage() {
        boolean bl2 = this._handler.contentComplete();
        if (bl2) {
            return true;
        }
        this.setState(State.END);
        return this._handler.messageComplete();
    }

    private boolean parseLine(ByteBuffer byteBuffer) {
        HttpTokens.Token token;
        boolean bl2 = false;
        block47: while (this._state.ordinal() < State.HEADER.ordinal() && byteBuffer.hasRemaining() && !bl2 && (token = this.next(byteBuffer)) != null) {
            if (this._maxHeaderBytes > 0 && ++this._headerBytes > this._maxHeaderBytes) {
                if (this._state == State.URI) {
                    LOG.warn("URI is too large >" + this._maxHeaderBytes, new Object[0]);
                    throw new BadMessageException(414);
                }
                if (this._requestHandler != null) {
                    LOG.warn("request is too large >" + this._maxHeaderBytes, new Object[0]);
                } else {
                    LOG.warn("response is too large >" + this._maxHeaderBytes, new Object[0]);
                }
                throw new BadMessageException(431);
            }
            block0 : switch (this._state) {
                case METHOD: {
                    Object object;
                    switch (token.getType()) {
                        case SPACE: {
                            this._length = this._string.length();
                            this._methodString = this.takeString();
                            if (this._compliances.contains((Object)HttpComplianceSection.METHOD_CASE_SENSITIVE)) {
                                object = HttpMethod.CACHE.get(this._methodString);
                                if (object != null) {
                                    this._methodString = ((HttpMethod)((Object)object)).asString();
                                }
                            } else {
                                object = HttpMethod.INSENSITIVE_CACHE.get(this._methodString);
                                if (object != null) {
                                    if (!((HttpMethod)((Object)object)).asString().equals(this._methodString)) {
                                        this.handleViolation(HttpComplianceSection.METHOD_CASE_SENSITIVE, this._methodString);
                                    }
                                    this._methodString = ((HttpMethod)((Object)object)).asString();
                                }
                            }
                            this.setState(State.SPACE1);
                            break block0;
                        }
                        case LF: {
                            throw new BadMessageException("No URI");
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: {
                            this._string.append(token.getChar());
                            break block0;
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
                case RESPONSE_VERSION: {
                    Object object;
                    switch (token.getType()) {
                        case SPACE: {
                            this._length = this._string.length();
                            object = this.takeString();
                            this._version = HttpVersion.CACHE.get((String)object);
                            this.checkVersion();
                            this.setState(State.SPACE1);
                            break block0;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case COLON: {
                            this._string.append(token.getChar());
                            break block0;
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
                case SPACE1: {
                    int n2;
                    int n3;
                    Object object;
                    switch (token.getType()) {
                        case SPACE: {
                            break block0;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case COLON: {
                            if (this._responseHandler != null) {
                                if (token.getType() != HttpTokens.Type.DIGIT) {
                                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                                }
                                this.setState(State.STATUS);
                                this.setResponseStatus(token.getByte() - 48);
                                break block0;
                            }
                            this._uri.reset();
                            this.setState(State.URI);
                            if (byteBuffer.hasArray()) {
                                int n4;
                                object = byteBuffer.array();
                                n3 = byteBuffer.arrayOffset() + byteBuffer.position();
                                n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
                                for (n4 = n3; n4 < n2 && object[n4] > 32; ++n4) {
                                }
                                int n5 = n4 - n3;
                                this._headerBytes += n5;
                                if (this._maxHeaderBytes > 0 && ++this._headerBytes > this._maxHeaderBytes) {
                                    LOG.warn("URI is too large >" + this._maxHeaderBytes, new Object[0]);
                                    throw new BadMessageException(414);
                                }
                                this._uri.append((byte[])object, n3 - 1, n5 + 1);
                                byteBuffer.position(n4 - byteBuffer.arrayOffset());
                                break block0;
                            }
                            this._uri.append(token.getByte());
                            break block0;
                        }
                    }
                    throw new BadMessageException(400, this._requestHandler != null ? "No URI" : "No Status");
                }
                case STATUS: {
                    switch (token.getType()) {
                        case SPACE: {
                            this.setState(State.SPACE2);
                            break block0;
                        }
                        case DIGIT: {
                            this._responseStatus = this._responseStatus * 10 + (token.getByte() - 48);
                            if (this._responseStatus < 1000) continue block47;
                            throw new BadMessageException("Bad status");
                        }
                        case LF: {
                            this.setState(State.HEADER);
                            this._responseHandler.startResponse(this._version, this._responseStatus, null);
                            break block0;
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
                case URI: {
                    switch (token.getType()) {
                        case SPACE: {
                            this.setState(State.SPACE2);
                            break block0;
                        }
                        case LF: {
                            if (this.complianceViolation(HttpComplianceSection.NO_HTTP_0_9, "No request version")) {
                                throw new BadMessageException(505, "HTTP/0.9 not supported");
                            }
                            this._requestHandler.startRequest(this._methodString, this._uri.toString(), HttpVersion.HTTP_0_9);
                            this.setState(State.CONTENT);
                            this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
                            BufferUtil.clear(byteBuffer);
                            bl2 = this.handleHeaderContentMessage();
                            break block0;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case OTEXT: 
                        case COLON: {
                            this._uri.append(token.getByte());
                            break block0;
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
                case SPACE2: {
                    int n2;
                    int n3;
                    Object object;
                    switch (token.getType()) {
                        case SPACE: {
                            break block0;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case COLON: {
                            this._string.setLength(0);
                            this._string.append(token.getChar());
                            if (this._responseHandler != null) {
                                this._length = 1;
                                this.setState(State.REASON);
                                break block0;
                            }
                            this.setState(State.REQUEST_VERSION);
                            object = byteBuffer.position() > 0 && byteBuffer.hasArray() ? HttpVersion.lookAheadGet(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position() - 1, byteBuffer.arrayOffset() + byteBuffer.limit()) : HttpVersion.CACHE.getBest(byteBuffer, 0, byteBuffer.remaining());
                            if (object == null || (n3 = byteBuffer.position() + ((HttpVersion)((Object)object)).asString().length() - 1) >= byteBuffer.limit()) continue block47;
                            n2 = byteBuffer.get(n3);
                            if (n2 == 13) {
                                this._cr = true;
                                this._version = object;
                                this.checkVersion();
                                this._string.setLength(0);
                                byteBuffer.position(n3 + 1);
                                break block0;
                            }
                            if (n2 != 10) continue block47;
                            this._version = object;
                            this.checkVersion();
                            this._string.setLength(0);
                            byteBuffer.position(n3);
                            break block0;
                        }
                        case LF: {
                            if (this._responseHandler != null) {
                                this.setState(State.HEADER);
                                this._responseHandler.startResponse(this._version, this._responseStatus, null);
                                break block0;
                            }
                            if (this.complianceViolation(HttpComplianceSection.NO_HTTP_0_9, "No request version")) {
                                throw new BadMessageException("HTTP/0.9 not supported");
                            }
                            this._requestHandler.startRequest(this._methodString, this._uri.toString(), HttpVersion.HTTP_0_9);
                            this.setState(State.CONTENT);
                            this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
                            BufferUtil.clear(byteBuffer);
                            bl2 = this.handleHeaderContentMessage();
                            break block0;
                        }
                        default: {
                            throw new IllegalCharacterException(this._state, token, byteBuffer);
                        }
                    }
                }
                case REQUEST_VERSION: {
                    switch (token.getType()) {
                        case LF: {
                            if (this._version == null) {
                                this._length = this._string.length();
                                this._version = HttpVersion.CACHE.get(this.takeString());
                            }
                            this.checkVersion();
                            this.setState(State.HEADER);
                            this._requestHandler.startRequest(this._methodString, this._uri.toString(), this._version);
                            continue block47;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case COLON: {
                            this._string.append(token.getChar());
                            break block0;
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
                case REASON: {
                    Object object;
                    switch (token.getType()) {
                        case LF: {
                            object = this.takeString();
                            this.setState(State.HEADER);
                            this._responseHandler.startResponse(this._version, this._responseStatus, (String)object);
                            continue block47;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case OTEXT: 
                        case COLON: {
                            this._string.append(token.getChar());
                            this._length = this._string.length();
                            break block0;
                        }
                        case HTAB: 
                        case SPACE: {
                            this._string.append(token.getChar());
                            break block0;
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
                default: {
                    throw new IllegalStateException(this._state.toString());
                }
            }
        }
        return bl2;
    }

    private void checkVersion() {
        if (this._version == null) {
            throw new BadMessageException(505, "Unknown Version");
        }
        if (this._version.getVersion() < 10 || this._version.getVersion() > 20) {
            throw new BadMessageException(505, "Unsupported Version");
        }
    }

    private void parsedHeader() {
        if (this._headerString != null || this._valueString != null) {
            if (this._header != null) {
                boolean bl2 = false;
                switch (this._header) {
                    case CONTENT_LENGTH: {
                        if (this._hasTransferEncoding && this.complianceViolation(HttpComplianceSection.TRANSFER_ENCODING_WITH_CONTENT_LENGTH)) {
                            throw new BadMessageException(400, "Transfer-Encoding and Content-Length");
                        }
                        long l2 = this.convertContentLength(this._valueString);
                        if (this._hasContentLength) {
                            if (this.complianceViolation(HttpComplianceSection.MULTIPLE_CONTENT_LENGTHS)) {
                                throw new BadMessageException(400, HttpComplianceSection.MULTIPLE_CONTENT_LENGTHS.description);
                            }
                            if (l2 != this._contentLength) {
                                throw new BadMessageException(400, HttpComplianceSection.MULTIPLE_CONTENT_LENGTHS.getDescription());
                            }
                        }
                        this._hasContentLength = true;
                        if (this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT) break;
                        this._contentLength = l2;
                        this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
                        break;
                    }
                    case TRANSFER_ENCODING: {
                        this._hasTransferEncoding = true;
                        if (this._hasContentLength && this.complianceViolation(HttpComplianceSection.TRANSFER_ENCODING_WITH_CONTENT_LENGTH)) {
                            throw new BadMessageException(400, "Transfer-Encoding and Content-Length");
                        }
                        if (this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT) {
                            throw new BadMessageException(400, "Bad Transfer-Encoding, chunked not last");
                        }
                        if (HttpHeaderValue.CHUNKED.is(this._valueString)) {
                            this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
                            this._contentLength = -1L;
                            break;
                        }
                        List<String> list = new QuotedCSV(this._valueString).getValues();
                        int n2 = -1;
                        int n3 = list.size();
                        for (int i2 = 0; i2 < n3; ++i2) {
                            if (HttpHeaderValue.CHUNKED.is(list.get(i2))) {
                                if (n2 != -1) {
                                    throw new BadMessageException(400, "Bad Transfer-Encoding, multiple chunked tokens");
                                }
                                n2 = i2;
                                this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
                                this._contentLength = -1L;
                                continue;
                            }
                            if (this._endOfContent != HttpTokens.EndOfContent.CHUNKED_CONTENT) continue;
                            throw new BadMessageException(400, "Bad Transfer-Encoding, chunked not last");
                        }
                        break;
                    }
                    case HOST: {
                        this._host = true;
                        if (this._field instanceof HostPortHttpField || this._valueString == null || this._valueString.isEmpty()) break;
                        this._field = new HostPortHttpField(this._header, this._compliances.contains((Object)HttpComplianceSection.FIELD_NAME_CASE_INSENSITIVE) ? this._header.asString() : this._headerString, this._valueString);
                        bl2 = true;
                        break;
                    }
                    case CONNECTION: {
                        if (this._field == null) {
                            this._field = new HttpField(this._header, this.caseInsensitiveHeader(this._headerString, this._header.asString()), this._valueString);
                        }
                        if (this._handler.getHeaderCacheSize() <= 0 || !this._field.contains(HttpHeaderValue.CLOSE.asString())) break;
                        this._fieldCache = NO_CACHE;
                        break;
                    }
                    case AUTHORIZATION: 
                    case ACCEPT: 
                    case ACCEPT_CHARSET: 
                    case ACCEPT_ENCODING: 
                    case ACCEPT_LANGUAGE: 
                    case COOKIE: 
                    case CACHE_CONTROL: 
                    case USER_AGENT: {
                        bl2 = this._field == null;
                        break;
                    }
                }
                if (bl2 && this._header != null && this._valueString != null) {
                    if (this._fieldCache == null) {
                        Trie<Object> trie = this._fieldCache = this._handler.getHeaderCacheSize() > 0 && this._version != null && this._version == HttpVersion.HTTP_1_1 ? new ArrayTernaryTrie(this._handler.getHeaderCacheSize()) : NO_CACHE;
                    }
                    if (!this._fieldCache.isFull()) {
                        if (this._field == null) {
                            this._field = new HttpField(this._header, this.caseInsensitiveHeader(this._headerString, this._header.asString()), this._valueString);
                        }
                        this._fieldCache.put(this._field);
                    }
                }
            }
            this._handler.parsedHeader(this._field != null ? this._field : new HttpField(this._header, this._headerString, this._valueString));
        }
        this._valueString = null;
        this._headerString = null;
        this._header = null;
        this._field = null;
    }

    private void parsedTrailer() {
        if (this._headerString != null || this._valueString != null) {
            this._handler.parsedTrailer(this._field != null ? this._field : new HttpField(this._header, this._headerString, this._valueString));
        }
        this._valueString = null;
        this._headerString = null;
        this._header = null;
        this._field = null;
    }

    private long convertContentLength(String string) {
        if (string == null || string.length() == 0) {
            throw new BadMessageException("Invalid Content-Length Value", new NumberFormatException());
        }
        long l2 = 0L;
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < '0' || c2 > '9') {
                throw new BadMessageException("Invalid Content-Length Value", new NumberFormatException());
            }
            l2 = Math.addExact(Math.multiplyExact(l2, 10L), (long)(c2 - 48));
        }
        return l2;
    }

    protected boolean parseFields(ByteBuffer byteBuffer) {
        HttpTokens.Token token;
        block37: while ((this._state == State.HEADER || this._state == State.TRAILER) && byteBuffer.hasRemaining() && (token = this.next(byteBuffer)) != null) {
            if (this._maxHeaderBytes > 0 && ++this._headerBytes > this._maxHeaderBytes) {
                boolean bl2 = this._state == State.HEADER;
                LOG.warn("{} is too large {}>{}", bl2 ? "Header" : "Trailer", this._headerBytes, this._maxHeaderBytes);
                throw new BadMessageException(bl2 ? 431 : 413);
            }
            switch (this._fieldState) {
                case FIELD: {
                    switch (token.getType()) {
                        case HTAB: 
                        case SPACE: 
                        case COLON: {
                            if (this.complianceViolation(HttpComplianceSection.NO_FIELD_FOLDING, this._headerString)) {
                                throw new BadMessageException(400, "Header Folding");
                            }
                            if (StringUtil.isEmpty(this._valueString)) {
                                this._string.setLength(0);
                                this._length = 0;
                            } else {
                                this.setString(this._valueString);
                                this._string.append(' ');
                                ++this._length;
                                this._valueString = null;
                            }
                            this.setState(FieldState.VALUE);
                            continue block37;
                        }
                        case LF: {
                            if (this._state == State.HEADER) {
                                this.parsedHeader();
                            } else {
                                this.parsedTrailer();
                            }
                            this._contentPosition = 0L;
                            if (this._state == State.TRAILER) {
                                this.setState(State.END);
                                return this._handler.messageComplete();
                            }
                            if (this._hasTransferEncoding && this._endOfContent != HttpTokens.EndOfContent.CHUNKED_CONTENT && (this._responseHandler == null || this._endOfContent != HttpTokens.EndOfContent.EOF_CONTENT)) {
                                throw new BadMessageException(400, "Bad Transfer-Encoding, chunked not last");
                            }
                            if (!this._host && this._version == HttpVersion.HTTP_1_1 && this._requestHandler != null) {
                                throw new BadMessageException(400, "No Host");
                            }
                            if (this._responseHandler != null && (this._responseStatus == 304 || this._responseStatus == 204 || this._responseStatus < 200)) {
                                this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
                            } else if (this._endOfContent == HttpTokens.EndOfContent.UNKNOWN_CONTENT) {
                                this._endOfContent = this._responseStatus == 0 || this._responseStatus == 304 || this._responseStatus == 204 || this._responseStatus < 200 ? HttpTokens.EndOfContent.NO_CONTENT : HttpTokens.EndOfContent.EOF_CONTENT;
                            }
                            switch (this._endOfContent) {
                                case EOF_CONTENT: {
                                    this.setState(State.EOF_CONTENT);
                                    boolean bl3 = this._handler.headerComplete();
                                    this._headerComplete = true;
                                    return bl3;
                                }
                                case CHUNKED_CONTENT: {
                                    this.setState(State.CHUNKED_CONTENT);
                                    boolean bl4 = this._handler.headerComplete();
                                    this._headerComplete = true;
                                    return bl4;
                                }
                            }
                            this.setState(State.CONTENT);
                            boolean bl5 = this._handler.headerComplete();
                            this._headerComplete = true;
                            return bl5;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: {
                            if (this._state == State.HEADER) {
                                this.parsedHeader();
                            } else {
                                this.parsedTrailer();
                            }
                            if (byteBuffer.hasRemaining()) {
                                HttpField httpField;
                                HttpField httpField2 = httpField = this._fieldCache == null ? null : this._fieldCache.getBest(byteBuffer, -1, byteBuffer.remaining());
                                if (httpField == null) {
                                    httpField = CACHE.getBest(byteBuffer, -1, byteBuffer.remaining());
                                }
                                if (httpField != null) {
                                    String string;
                                    String string2 = httpField.getName();
                                    String string3 = httpField.getValue();
                                    if (!this._compliances.contains((Object)HttpComplianceSection.FIELD_NAME_CASE_INSENSITIVE) && !string2.equals(string = BufferUtil.toString(byteBuffer, byteBuffer.position() - 1, string2.length(), StandardCharsets.US_ASCII))) {
                                        this.handleViolation(HttpComplianceSection.FIELD_NAME_CASE_INSENSITIVE, string);
                                        string2 = string;
                                        httpField = new HttpField(httpField.getHeader(), string2, string3);
                                    }
                                    if (string3 != null && !this._compliances.contains((Object)HttpComplianceSection.CASE_INSENSITIVE_FIELD_VALUE_CACHE) && !string3.equals(string = BufferUtil.toString(byteBuffer, byteBuffer.position() + string2.length() + 1, string3.length(), StandardCharsets.ISO_8859_1))) {
                                        this.handleViolation(HttpComplianceSection.CASE_INSENSITIVE_FIELD_VALUE_CACHE, string + "!=" + string3);
                                        string3 = string;
                                        httpField = new HttpField(httpField.getHeader(), string2, string3);
                                    }
                                    this._header = httpField.getHeader();
                                    this._headerString = string2;
                                    if (string3 == null) {
                                        this.setState(FieldState.VALUE);
                                        this._string.setLength(0);
                                        this._length = 0;
                                        byteBuffer.position(byteBuffer.position() + string2.length() + 1);
                                        continue block37;
                                    }
                                    int n2 = byteBuffer.position() + string2.length() + string3.length() + 1;
                                    byte by2 = byteBuffer.get(n2);
                                    if (by2 == 13 || by2 == 10) {
                                        this._field = httpField;
                                        this._valueString = string3;
                                        this.setState(FieldState.IN_VALUE);
                                        if (by2 == 13) {
                                            this._cr = true;
                                            byteBuffer.position(n2 + 1);
                                            continue block37;
                                        }
                                        byteBuffer.position(n2);
                                        continue block37;
                                    }
                                    this.setState(FieldState.IN_VALUE);
                                    this.setString(string3);
                                    byteBuffer.position(n2);
                                    continue block37;
                                }
                            }
                            this.setState(FieldState.IN_NAME);
                            this._string.setLength(0);
                            this._string.append(token.getChar());
                            this._length = 1;
                            continue block37;
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
                case IN_NAME: {
                    switch (token.getType()) {
                        case HTAB: 
                        case SPACE: {
                            if (!this.complianceViolation(HttpComplianceSection.NO_WS_AFTER_FIELD_NAME, null)) {
                                this._headerString = this.takeString();
                                this._header = HttpHeader.CACHE.get(this._headerString);
                                this._length = -1;
                                this.setState(FieldState.WS_AFTER_NAME);
                                continue block37;
                            }
                            throw new IllegalCharacterException(this._state, token, byteBuffer);
                        }
                        case COLON: {
                            this._headerString = this.takeString();
                            this._header = HttpHeader.CACHE.get(this._headerString);
                            this._length = -1;
                            this.setState(FieldState.VALUE);
                            continue block37;
                        }
                        case LF: {
                            this._headerString = this.takeString();
                            this._header = HttpHeader.CACHE.get(this._headerString);
                            this._string.setLength(0);
                            this._valueString = "";
                            this._length = -1;
                            if (!this.complianceViolation(HttpComplianceSection.FIELD_COLON, this._headerString)) {
                                this.setState(FieldState.FIELD);
                                continue block37;
                            }
                            throw new IllegalCharacterException(this._state, token, byteBuffer);
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: {
                            this._string.append(token.getChar());
                            this._length = this._string.length();
                            continue block37;
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
                case WS_AFTER_NAME: {
                    switch (token.getType()) {
                        case HTAB: 
                        case SPACE: {
                            continue block37;
                        }
                        case COLON: {
                            this.setState(FieldState.VALUE);
                            continue block37;
                        }
                        case LF: {
                            if (!this.complianceViolation(HttpComplianceSection.FIELD_COLON, this._headerString)) {
                                this.setState(FieldState.FIELD);
                                continue block37;
                            }
                            throw new IllegalCharacterException(this._state, token, byteBuffer);
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
                case VALUE: {
                    switch (token.getType()) {
                        case LF: {
                            this._string.setLength(0);
                            this._valueString = "";
                            this._length = -1;
                            this.setState(FieldState.FIELD);
                            continue block37;
                        }
                        case HTAB: 
                        case SPACE: {
                            continue block37;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case OTEXT: 
                        case COLON: {
                            this._string.append(token.getChar());
                            this._length = this._string.length();
                            this.setState(FieldState.IN_VALUE);
                            continue block37;
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
                case IN_VALUE: {
                    switch (token.getType()) {
                        case LF: {
                            if (this._length > 0) {
                                this._valueString = this.takeString();
                                this._length = -1;
                            }
                            this.setState(FieldState.FIELD);
                            continue block37;
                        }
                        case HTAB: 
                        case SPACE: {
                            this._string.append(token.getChar());
                            continue block37;
                        }
                        case ALPHA: 
                        case DIGIT: 
                        case TCHAR: 
                        case VCHAR: 
                        case OTEXT: 
                        case COLON: {
                            this._string.append(token.getChar());
                            this._length = this._string.length();
                            continue block37;
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
            }
            throw new IllegalStateException(this._state.toString());
        }
        return false;
    }

    public boolean parseNext(ByteBuffer byteBuffer) {
        if (this.debug) {
            LOG.debug("parseNext s={} {}", new Object[]{this._state, BufferUtil.toDetailString(byteBuffer)});
        }
        try {
            boolean bl2;
            if (this._state == State.START) {
                this._version = null;
                this._method = null;
                this._methodString = null;
                this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
                this._header = null;
                this.quickStart(byteBuffer);
            }
            if (this._state.ordinal() < State.HEADER.ordinal() && this.parseLine(byteBuffer)) {
                return true;
            }
            if (this._state == State.HEADER && this.parseFields(byteBuffer)) {
                return true;
            }
            if (this._state.ordinal() >= State.CONTENT.ordinal() && this._state.ordinal() < State.TRAILER.ordinal()) {
                if (this._responseStatus > 0 && this._headResponse) {
                    if (this._state != State.CONTENT_END) {
                        this.setState(State.CONTENT_END);
                        return this.handleContentMessage();
                    }
                    this.setState(State.END);
                    return this._handler.messageComplete();
                }
                if (this.parseContent(byteBuffer)) {
                    return true;
                }
            }
            if (this._state == State.TRAILER && this.parseFields(byteBuffer)) {
                return true;
            }
            if (this._state == State.END) {
                byte by2;
                bl2 = false;
                while (byteBuffer.remaining() > 0 && ((by2 = byteBuffer.get(byteBuffer.position())) == 13 || by2 == 10)) {
                    byteBuffer.get();
                    bl2 += 1;
                }
                if (this.debug && bl2 > false) {
                    LOG.debug("Discarded {} CR or LF characters", (long)bl2);
                }
            } else if (this.isTerminated()) {
                BufferUtil.clear(byteBuffer);
            }
            if (this.isAtEOF() && !byteBuffer.hasRemaining()) {
                switch (this._state) {
                    case CLOSED: {
                        break;
                    }
                    case END: 
                    case CLOSE: {
                        this.setState(State.CLOSED);
                        break;
                    }
                    case EOF_CONTENT: 
                    case TRAILER: {
                        if (this._fieldState == FieldState.FIELD) {
                            this.setState(State.CONTENT_END);
                            bl2 = this.handleContentMessage();
                            if (bl2 && this._state == State.CONTENT_END) {
                                return true;
                            }
                            this.setState(State.CLOSED);
                            return bl2;
                        }
                        this.setState(State.CLOSED);
                        this._handler.earlyEOF();
                        break;
                    }
                    case START: 
                    case CONTENT: 
                    case CHUNKED_CONTENT: 
                    case CHUNK_SIZE: 
                    case CHUNK_PARAMS: 
                    case CHUNK: {
                        this.setState(State.CLOSED);
                        this._handler.earlyEOF();
                        break;
                    }
                    default: {
                        if (this.debug) {
                            LOG.debug("{} EOF in {}", new Object[]{this, this._state});
                        }
                        this.setState(State.CLOSED);
                        this._handler.badMessage(new BadMessageException(400));
                    }
                }
            }
        }
        catch (BadMessageException badMessageException) {
            BufferUtil.clear(byteBuffer);
            this.badMessage(badMessageException);
        }
        catch (Throwable throwable) {
            BufferUtil.clear(byteBuffer);
            this.badMessage(new BadMessageException(400, this._requestHandler != null ? "Bad Request" : "Bad Response", throwable));
        }
        return false;
    }

    protected void badMessage(BadMessageException badMessageException) {
        if (this.debug) {
            LOG.debug("Parse exception: " + this + " for " + this._handler, badMessageException);
        }
        this.setState(State.CLOSE);
        if (this._headerComplete) {
            this._handler.earlyEOF();
        } else {
            this._handler.badMessage(badMessageException);
        }
    }

    protected boolean parseContent(ByteBuffer byteBuffer) {
        long l2;
        int n2 = byteBuffer.remaining();
        if (n2 == 0) {
            switch (this._state) {
                case CONTENT: {
                    l2 = this._contentLength - this._contentPosition;
                    if (this._endOfContent != HttpTokens.EndOfContent.NO_CONTENT && l2 != 0L) break;
                    this.setState(State.CONTENT_END);
                    return this.handleContentMessage();
                }
                case CONTENT_END: {
                    this.setState(this._endOfContent == HttpTokens.EndOfContent.EOF_CONTENT ? State.CLOSED : State.END);
                    return this._handler.messageComplete();
                }
                default: {
                    return false;
                }
            }
        }
        while (this._state.ordinal() < State.TRAILER.ordinal() && n2 > 0) {
            block4 : switch (this._state) {
                case EOF_CONTENT: {
                    this._contentChunk = byteBuffer.asReadOnlyBuffer();
                    this._contentPosition += (long)n2;
                    byteBuffer.position(byteBuffer.position() + n2);
                    if (!this._handler.content(this._contentChunk)) break;
                    return true;
                }
                case CONTENT: {
                    l2 = this._contentLength - this._contentPosition;
                    if (this._endOfContent == HttpTokens.EndOfContent.NO_CONTENT || l2 == 0L) {
                        this.setState(State.CONTENT_END);
                        return this.handleContentMessage();
                    }
                    this._contentChunk = byteBuffer.asReadOnlyBuffer();
                    if ((long)n2 > l2) {
                        this._contentChunk.limit(this._contentChunk.position() + (int)l2);
                    }
                    this._contentPosition += (long)this._contentChunk.remaining();
                    byteBuffer.position(byteBuffer.position() + this._contentChunk.remaining());
                    if (this._handler.content(this._contentChunk)) {
                        return true;
                    }
                    if (this._contentPosition != this._contentLength) break;
                    this.setState(State.CONTENT_END);
                    return this.handleContentMessage();
                }
                case CHUNKED_CONTENT: {
                    HttpTokens.Token token = this.next(byteBuffer);
                    if (token == null) break;
                    switch (token.getType()) {
                        case LF: {
                            break block4;
                        }
                        case DIGIT: {
                            this._chunkLength = token.getHexDigit();
                            this._chunkPosition = 0;
                            this.setState(State.CHUNK_SIZE);
                            break block4;
                        }
                        case ALPHA: {
                            if (token.isHexDigit()) {
                                this._chunkLength = token.getHexDigit();
                                this._chunkPosition = 0;
                                this.setState(State.CHUNK_SIZE);
                                break block4;
                            }
                            throw new IllegalCharacterException(this._state, token, byteBuffer);
                        }
                    }
                    throw new IllegalCharacterException(this._state, token, byteBuffer);
                }
                case CHUNK_SIZE: {
                    HttpTokens.Token token = this.next(byteBuffer);
                    if (token == null) break;
                    switch (token.getType()) {
                        case LF: {
                            if (this._chunkLength == 0) {
                                this.setState(State.TRAILER);
                                if (!this._handler.contentComplete()) break block4;
                                return true;
                            }
                            this.setState(State.CHUNK);
                            break block4;
                        }
                        case SPACE: {
                            this.setState(State.CHUNK_PARAMS);
                            break block4;
                        }
                    }
                    if (token.isHexDigit()) {
                        if (this._chunkLength > 0x7FFFFEF) {
                            throw new BadMessageException(413);
                        }
                        this._chunkLength = this._chunkLength * 16 + token.getHexDigit();
                        break;
                    }
                    this.setState(State.CHUNK_PARAMS);
                    break;
                }
                case CHUNK_PARAMS: {
                    HttpTokens.Token token = this.next(byteBuffer);
                    if (token == null) break;
                    switch (token.getType()) {
                        case LF: {
                            if (this._chunkLength == 0) {
                                this.setState(State.TRAILER);
                                if (!this._handler.contentComplete()) break block4;
                                return true;
                            }
                            this.setState(State.CHUNK);
                            break block4;
                        }
                    }
                    break;
                }
                case CHUNK: {
                    int n3 = this._chunkLength - this._chunkPosition;
                    if (n3 == 0) {
                        this.setState(State.CHUNKED_CONTENT);
                        break;
                    }
                    this._contentChunk = byteBuffer.asReadOnlyBuffer();
                    if (n2 > n3) {
                        this._contentChunk.limit(this._contentChunk.position() + n3);
                    }
                    n3 = this._contentChunk.remaining();
                    this._contentPosition += (long)n3;
                    this._chunkPosition += n3;
                    byteBuffer.position(byteBuffer.position() + n3);
                    if (!this._handler.content(this._contentChunk)) break;
                    return true;
                }
                case CONTENT_END: {
                    this.setState(this._endOfContent == HttpTokens.EndOfContent.EOF_CONTENT ? State.CLOSED : State.END);
                    return this._handler.messageComplete();
                }
            }
            n2 = byteBuffer.remaining();
        }
        return false;
    }

    public boolean isAtEOF() {
        return this._eof;
    }

    public void atEOF() {
        if (this.debug) {
            LOG.debug("atEOF {}", this);
        }
        this._eof = true;
    }

    public void close() {
        if (this.debug) {
            LOG.debug("close {}", this);
        }
        this.setState(State.CLOSE);
    }

    public void reset() {
        if (this.debug) {
            LOG.debug("reset {}", this);
        }
        if (this._state == State.CLOSE || this._state == State.CLOSED) {
            return;
        }
        this.setState(State.START);
        this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
        this._contentLength = -1L;
        this._hasContentLength = false;
        this._hasTransferEncoding = false;
        this._contentPosition = 0L;
        this._responseStatus = 0;
        this._contentChunk = null;
        this._headerBytes = 0;
        this._host = false;
        this._headerComplete = false;
    }

    protected void setState(State state) {
        if (this.debug) {
            LOG.debug("{} --> {}", new Object[]{this._state, state});
        }
        this._state = state;
    }

    protected void setState(FieldState fieldState) {
        if (this.debug) {
            LOG.debug("{}:{} --> {}", new Object[]{this._state, this._field != null ? this._field : (this._headerString != null ? this._headerString : this._string), fieldState});
        }
        this._fieldState = fieldState;
    }

    public String toString() {
        return String.format("%s{s=%s,%d of %d}", new Object[]{this.getClass().getSimpleName(), this._state, this.getContentRead(), this.getContentLength()});
    }

    static {
        CACHE.put(new HttpField(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE));
        CACHE.put(new HttpField(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE));
        CACHE.put(new HttpField(HttpHeader.CONNECTION, HttpHeaderValue.UPGRADE));
        CACHE.put(new HttpField(HttpHeader.ACCEPT_ENCODING, "gzip"));
        CACHE.put(new HttpField(HttpHeader.ACCEPT_ENCODING, "gzip, deflate"));
        CACHE.put(new HttpField(HttpHeader.ACCEPT_ENCODING, "gzip, deflate, br"));
        CACHE.put(new HttpField(HttpHeader.ACCEPT_ENCODING, "gzip,deflate,sdch"));
        CACHE.put(new HttpField(HttpHeader.ACCEPT_LANGUAGE, "en-US,en;q=0.5"));
        CACHE.put(new HttpField(HttpHeader.ACCEPT_LANGUAGE, "en-GB,en-US;q=0.8,en;q=0.6"));
        CACHE.put(new HttpField(HttpHeader.ACCEPT_LANGUAGE, "en-AU,en;q=0.9,it-IT;q=0.8,it;q=0.7,en-GB;q=0.6,en-US;q=0.5"));
        CACHE.put(new HttpField(HttpHeader.ACCEPT_CHARSET, "ISO-8859-1,utf-8;q=0.7,*;q=0.3"));
        CACHE.put(new HttpField(HttpHeader.ACCEPT, "*/*"));
        CACHE.put(new HttpField(HttpHeader.ACCEPT, "image/png,image/*;q=0.8,*/*;q=0.5"));
        CACHE.put(new HttpField(HttpHeader.ACCEPT, "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8"));
        CACHE.put(new HttpField(HttpHeader.ACCEPT, "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8"));
        CACHE.put(new HttpField(HttpHeader.ACCEPT_RANGES, HttpHeaderValue.BYTES));
        CACHE.put(new HttpField(HttpHeader.PRAGMA, "no-cache"));
        CACHE.put(new HttpField(HttpHeader.CACHE_CONTROL, "private, no-cache, no-cache=Set-Cookie, proxy-revalidate"));
        CACHE.put(new HttpField(HttpHeader.CACHE_CONTROL, "no-cache"));
        CACHE.put(new HttpField(HttpHeader.CACHE_CONTROL, "max-age=0"));
        CACHE.put(new HttpField(HttpHeader.CONTENT_LENGTH, "0"));
        CACHE.put(new HttpField(HttpHeader.CONTENT_ENCODING, "gzip"));
        CACHE.put(new HttpField(HttpHeader.CONTENT_ENCODING, "deflate"));
        CACHE.put(new HttpField(HttpHeader.TRANSFER_ENCODING, "chunked"));
        CACHE.put(new HttpField(HttpHeader.EXPIRES, "Fri, 01 Jan 1990 00:00:00 GMT"));
        for (String string : new String[]{"text/plain", "text/html", "text/xml", "text/json", "application/json", "application/x-www-form-urlencoded"}) {
            PreEncodedHttpField preEncodedHttpField = new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, string);
            CACHE.put(preEncodedHttpField);
            for (String string2 : new String[]{"utf-8", "iso-8859-1"}) {
                CACHE.put(new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, string + ";charset=" + string2));
                CACHE.put(new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, string + "; charset=" + string2));
                CACHE.put(new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, string + ";charset=" + string2.toUpperCase(Locale.ENGLISH)));
                CACHE.put(new PreEncodedHttpField(HttpHeader.CONTENT_TYPE, string + "; charset=" + string2.toUpperCase(Locale.ENGLISH)));
            }
        }
        for (HttpHeader httpHeader : HttpHeader.values()) {
            if (httpHeader.isPseudo() || CACHE.put(new HttpField(httpHeader, (String)null))) continue;
            throw new IllegalStateException("CACHE FULL");
        }
    }

    private static class IllegalCharacterException
    extends BadMessageException {
        private IllegalCharacterException(State state, HttpTokens.Token token, ByteBuffer byteBuffer) {
            super(400, String.format("Illegal character %s", token));
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Illegal character %s in state=%s for buffer %s", new Object[]{token, state, BufferUtil.toDetailString(byteBuffer)}), new Object[0]);
            }
        }
    }

    public static interface ComplianceHandler
    extends HttpHandler {
        @Deprecated
        default public void onComplianceViolation(HttpCompliance httpCompliance, HttpCompliance httpCompliance2, String string) {
        }

        default public void onComplianceViolation(HttpCompliance httpCompliance, HttpComplianceSection httpComplianceSection, String string) {
            this.onComplianceViolation(httpCompliance, HttpCompliance.requiredCompliance(httpComplianceSection), string);
        }
    }

    public static interface ResponseHandler
    extends HttpHandler {
        public boolean startResponse(HttpVersion var1, int var2, String var3);
    }

    public static interface RequestHandler
    extends HttpHandler {
        public boolean startRequest(String var1, String var2, HttpVersion var3);
    }

    public static interface HttpHandler {
        public boolean content(ByteBuffer var1);

        public boolean headerComplete();

        public boolean contentComplete();

        public boolean messageComplete();

        public void parsedHeader(HttpField var1);

        default public void parsedTrailer(HttpField httpField) {
        }

        public void earlyEOF();

        default public void badMessage(BadMessageException badMessageException) {
            this.badMessage(badMessageException.getCode(), badMessageException.getReason());
        }

        @Deprecated
        default public void badMessage(int n2, String string) {
        }

        public int getHeaderCacheSize();
    }

    public static enum State {
        START,
        METHOD,
        RESPONSE_VERSION,
        SPACE1,
        STATUS,
        URI,
        SPACE2,
        REQUEST_VERSION,
        REASON,
        PROXY,
        HEADER,
        CONTENT,
        EOF_CONTENT,
        CHUNKED_CONTENT,
        CHUNK_SIZE,
        CHUNK_PARAMS,
        CHUNK,
        CONTENT_END,
        TRAILER,
        END,
        CLOSE,
        CLOSED;

    }

    public static enum FieldState {
        FIELD,
        IN_NAME,
        VALUE,
        IN_VALUE,
        WS_AFTER_NAME;

    }
}

