/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.LinkOption;

public final class IOUtils {
    public static final LinkOption[] EMPTY_LINK_OPTIONS = new LinkOption[0];
    private static final byte[] SKIP_BUF = new byte[4096];

    public static long copyRange(InputStream inputStream, long l2, OutputStream outputStream) throws IOException {
        return IOUtils.copyRange(inputStream, l2, outputStream, 8024);
    }

    public static long copyRange(InputStream inputStream, long l2, OutputStream outputStream, int n2) throws IOException {
        long l3;
        if (n2 < 1) {
            throw new IllegalArgumentException("bufferSize must be bigger than 0");
        }
        byte[] byArray = new byte[(int)Math.min((long)n2, l2)];
        int n3 = 0;
        for (l3 = 0L; l3 < l2 && -1 != (n3 = inputStream.read(byArray, 0, (int)Math.min(l2 - l3, (long)byArray.length))); l3 += (long)n3) {
            if (outputStream == null) continue;
            outputStream.write(byArray, 0, n3);
        }
        return l3;
    }

    public static int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        return IOUtils.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static int readFully(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (n3 < 0 || n2 < 0 || n3 + n2 > byArray.length || n3 + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n5 = 0;
        for (n4 = 0; n4 != n3 && (n5 = inputStream.read(byArray, n2 + n4, n3 - n4)) != -1; n4 += n5) {
        }
        return n4;
    }

    public static byte[] readRange(InputStream inputStream, int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copyRange(inputStream, n2, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static long skip(InputStream inputStream, long l2) throws IOException {
        int n2;
        long l3;
        long l4 = l2;
        while (l2 > 0L && (l3 = inputStream.skip(l2)) != 0L) {
            l2 -= l3;
        }
        while (l2 > 0L && (n2 = IOUtils.readFully(inputStream, SKIP_BUF, 0, (int)Math.min(l2, 4096L))) >= 1) {
            l2 -= (long)n2;
        }
        return l4 - l2;
    }
}

