/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.google.common.collect;

import com.gradle.scan.plugin.internal.dep.com.google.common.base.Preconditions;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.Iterators;
import com.gradle.scan.plugin.internal.dep.com.google.common.collect.UnmodifiableIterator;
import javax.annotation.CheckForNull;

final class SingletonImmutableSet<E>
extends ImmutableSet<E> {
    final transient E element;

    SingletonImmutableSet(E e2) {
        this.element = Preconditions.checkNotNull(e2);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(@CheckForNull Object object) {
        return this.element.equals(object);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.singletonIterator(this.element);
    }

    @Override
    public ImmutableList<E> asList() {
        return ImmutableList.of(this.element);
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n2) {
        objectArray[n2] = this.element;
        return n2 + 1;
    }

    @Override
    public final int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public String toString() {
        return '[' + this.element.toString() + ']';
    }
}

