/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.EnumNamingStrategy;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.EnumFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class EnumValues
implements Serializable {
    private final Class<Enum<?>> _enumClass;
    private final Enum<?>[] _values;
    private final SerializableString[] _textual;

    private EnumValues(Class<Enum<?>> clazz, SerializableString[] serializableStringArray) {
        this._enumClass = clazz;
        this._values = clazz.getEnumConstants();
        this._textual = serializableStringArray;
    }

    public static EnumValues constructFromName(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz) {
        Class<Enum<?>> clazz2 = ClassUtil.findEnumType(clazz);
        Enum<?>[] enumArray = clazz2.getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + clazz.getName());
        }
        String[] stringArray = mapperConfig.getAnnotationIntrospector().findEnumValues(clazz2, enumArray, new String[enumArray.length]);
        SerializableString[] serializableStringArray = new SerializableString[enumArray.length];
        int n2 = enumArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum<?> enum_ = enumArray[i2];
            String string = stringArray[i2];
            if (string == null) {
                string = enum_.name();
            }
            if (mapperConfig.isEnabled(EnumFeature.WRITE_ENUMS_TO_LOWERCASE)) {
                string = string.toLowerCase();
            }
            serializableStringArray[enum_.ordinal()] = mapperConfig.compileString(string);
        }
        return EnumValues.construct(clazz, serializableStringArray);
    }

    public static EnumValues constructUsingEnumNamingStrategy(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz, EnumNamingStrategy enumNamingStrategy) {
        Class<Enum<?>> clazz2 = ClassUtil.findEnumType(clazz);
        Enum<?>[] enumArray = clazz2.getEnumConstants();
        if (enumArray == null) {
            throw new IllegalArgumentException("Cannot determine enum constants for Class " + clazz.getName());
        }
        ArrayList<String> arrayList = new ArrayList<String>(enumArray.length);
        for (Enum<?> enum_ : enumArray) {
            arrayList.add(enumNamingStrategy.convertEnumToExternalName(enum_.name()));
        }
        return EnumValues.construct(mapperConfig, clazz, arrayList);
    }

    public static EnumValues construct(MapperConfig<?> mapperConfig, Class<Enum<?>> clazz, List<String> list) {
        int n2 = list.size();
        SerializableString[] serializableStringArray = new SerializableString[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            serializableStringArray[i2] = mapperConfig.compileString(list.get(i2));
        }
        return EnumValues.construct(clazz, serializableStringArray);
    }

    public static EnumValues construct(Class<Enum<?>> clazz, SerializableString[] serializableStringArray) {
        return new EnumValues(clazz, serializableStringArray);
    }

    public SerializableString serializedValueFor(Enum<?> enum_) {
        return this._textual[enum_.ordinal()];
    }

    public Collection<SerializableString> values() {
        return Arrays.asList(this._textual);
    }

    public List<Enum<?>> enums() {
        return Arrays.asList(this._values);
    }

    public Class<Enum<?>> getEnumClass() {
        return this._enumClass;
    }
}

