/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.StreamReadFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std.NullifyingDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.AccessPattern;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;

public class NumberDeserializers {
    private static final HashSet<String> _classNames;

    public static JsonDeserializer<?> find(Class<?> clazz, String string) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return IntegerDeserializer.primitiveInstance;
            }
            if (clazz == Boolean.TYPE) {
                return BooleanDeserializer.primitiveInstance;
            }
            if (clazz == Long.TYPE) {
                return LongDeserializer.primitiveInstance;
            }
            if (clazz == Double.TYPE) {
                return DoubleDeserializer.primitiveInstance;
            }
            if (clazz == Character.TYPE) {
                return CharacterDeserializer.primitiveInstance;
            }
            if (clazz == Byte.TYPE) {
                return ByteDeserializer.primitiveInstance;
            }
            if (clazz == Short.TYPE) {
                return ShortDeserializer.primitiveInstance;
            }
            if (clazz == Float.TYPE) {
                return FloatDeserializer.primitiveInstance;
            }
            if (clazz == Void.TYPE) {
                return NullifyingDeserializer.instance;
            }
        } else if (_classNames.contains(string)) {
            if (clazz == Integer.class) {
                return IntegerDeserializer.wrapperInstance;
            }
            if (clazz == Boolean.class) {
                return BooleanDeserializer.wrapperInstance;
            }
            if (clazz == Long.class) {
                return LongDeserializer.wrapperInstance;
            }
            if (clazz == Double.class) {
                return DoubleDeserializer.wrapperInstance;
            }
            if (clazz == Character.class) {
                return CharacterDeserializer.wrapperInstance;
            }
            if (clazz == Byte.class) {
                return ByteDeserializer.wrapperInstance;
            }
            if (clazz == Short.class) {
                return ShortDeserializer.wrapperInstance;
            }
            if (clazz == Float.class) {
                return FloatDeserializer.wrapperInstance;
            }
            if (clazz == Number.class) {
                return NumberDeserializer.instance;
            }
            if (clazz == BigDecimal.class) {
                return BigDecimalDeserializer.instance;
            }
            if (clazz == BigInteger.class) {
                return BigIntegerDeserializer.instance;
            }
        } else {
            return null;
        }
        throw new IllegalArgumentException("Internal error: can't find deserializer for " + clazz.getName());
    }

    static {
        Class[] classArray;
        _classNames = new HashSet();
        for (Class clazz : classArray = new Class[]{Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, Number.class, BigDecimal.class, BigInteger.class}) {
            _classNames.add(clazz.getName());
        }
    }

    @JacksonStdImpl
    public static class BigDecimalDeserializer
    extends StdScalarDeserializer<BigDecimal> {
        public static final BigDecimalDeserializer instance = new BigDecimalDeserializer();

        public BigDecimalDeserializer() {
            super(BigDecimal.class);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return BigDecimal.ZERO;
        }

        @Override
        public final LogicalType logicalType() {
            return LogicalType.Float;
        }

        @Override
        public BigDecimal deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String string;
            switch (jsonParser.currentTokenId()) {
                case 7: {
                    CoercionAction coercionAction = this._checkIntToFloatCoercion(jsonParser, deserializationContext, this._valueClass);
                    if (coercionAction == CoercionAction.AsNull) {
                        return (BigDecimal)this.getNullValue(deserializationContext);
                    }
                    if (coercionAction == CoercionAction.AsEmpty) {
                        return (BigDecimal)this.getEmptyValue(deserializationContext);
                    }
                }
                case 8: {
                    return jsonParser.getDecimalValue();
                }
                case 6: {
                    string = jsonParser.getText();
                    break;
                }
                case 1: {
                    string = deserializationContext.extractScalarFromObject(jsonParser, this, this._valueClass);
                    break;
                }
                case 3: {
                    return (BigDecimal)this._deserializeFromArray(jsonParser, deserializationContext);
                }
                default: {
                    return (BigDecimal)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                }
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
            if (coercionAction == CoercionAction.AsNull) {
                return (BigDecimal)this.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (BigDecimal)this.getEmptyValue(deserializationContext);
            }
            if (this._hasTextualNull(string = string.trim())) {
                return (BigDecimal)this.getNullValue(deserializationContext);
            }
            jsonParser.streamReadConstraints().validateFPLength(string.length());
            try {
                return NumberInput.parseBigDecimal(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (BigDecimal)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid representation", new Object[0]);
            }
        }
    }

    @JacksonStdImpl
    public static class BigIntegerDeserializer
    extends StdScalarDeserializer<BigInteger> {
        public static final BigIntegerDeserializer instance = new BigIntegerDeserializer();

        public BigIntegerDeserializer() {
            super(BigInteger.class);
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) {
            return BigInteger.ZERO;
        }

        @Override
        public final LogicalType logicalType() {
            return LogicalType.Integer;
        }

        @Override
        public BigInteger deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String string;
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getBigIntegerValue();
            }
            switch (jsonParser.currentTokenId()) {
                case 6: {
                    string = jsonParser.getText();
                    break;
                }
                case 8: {
                    CoercionAction coercionAction = this._checkFloatToIntCoercion(jsonParser, deserializationContext, this._valueClass);
                    if (coercionAction == CoercionAction.AsNull) {
                        return (BigInteger)this.getNullValue(deserializationContext);
                    }
                    if (coercionAction == CoercionAction.AsEmpty) {
                        return (BigInteger)this.getEmptyValue(deserializationContext);
                    }
                    BigDecimal bigDecimal = jsonParser.getDecimalValue();
                    jsonParser.streamReadConstraints().validateBigIntegerScale(bigDecimal.scale());
                    return bigDecimal.toBigInteger();
                }
                case 1: {
                    string = deserializationContext.extractScalarFromObject(jsonParser, this, this._valueClass);
                    break;
                }
                case 3: {
                    return (BigInteger)this._deserializeFromArray(jsonParser, deserializationContext);
                }
                default: {
                    return (BigInteger)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                }
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
            if (coercionAction == CoercionAction.AsNull) {
                return (BigInteger)this.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (BigInteger)this.getEmptyValue(deserializationContext);
            }
            if (this._hasTextualNull(string = string.trim())) {
                return (BigInteger)this.getNullValue(deserializationContext);
            }
            jsonParser.streamReadConstraints().validateIntegerLength(string.length());
            try {
                return NumberInput.parseBigInteger(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (BigInteger)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid representation", new Object[0]);
            }
        }
    }

    @JacksonStdImpl
    public static class NumberDeserializer
    extends StdScalarDeserializer<Object> {
        public static final NumberDeserializer instance = new NumberDeserializer();

        public NumberDeserializer() {
            super(Number.class);
        }

        @Override
        public final LogicalType logicalType() {
            return LogicalType.Integer;
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String string;
            switch (jsonParser.currentTokenId()) {
                case 6: {
                    string = jsonParser.getText();
                    break;
                }
                case 7: {
                    if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                        return this._coerceIntegral(jsonParser, deserializationContext);
                    }
                    return jsonParser.getNumberValue();
                }
                case 8: {
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS) && !jsonParser.isNaN()) {
                        return jsonParser.getDecimalValue();
                    }
                    return jsonParser.getNumberValue();
                }
                case 1: {
                    string = deserializationContext.extractScalarFromObject(jsonParser, this, this._valueClass);
                    break;
                }
                case 3: {
                    return this._deserializeFromArray(jsonParser, deserializationContext);
                }
                default: {
                    return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                }
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
            if (coercionAction == CoercionAction.AsNull) {
                return this.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return this.getEmptyValue(deserializationContext);
            }
            if (this._hasTextualNull(string = string.trim())) {
                return this.getNullValue(deserializationContext);
            }
            if (this._isPosInf(string)) {
                return Double.POSITIVE_INFINITY;
            }
            if (this._isNegInf(string)) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this._isNaN(string)) {
                return Double.NaN;
            }
            try {
                if (!this._isIntNumber(string)) {
                    jsonParser.streamReadConstraints().validateFPLength(string.length());
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                        return NumberInput.parseBigDecimal(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                    }
                    return NumberInput.parseDouble(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
                }
                jsonParser.streamReadConstraints().validateIntegerLength(string.length());
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                    return NumberInput.parseBigInteger(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                }
                long l2 = NumberInput.parseLong(string);
                if (!deserializationContext.isEnabled(DeserializationFeature.USE_LONG_FOR_INTS) && l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
                    return (int)l2;
                }
                return l2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid number", new Object[0]);
            }
        }

        @Override
        public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
            switch (jsonParser.currentTokenId()) {
                case 6: 
                case 7: 
                case 8: {
                    return this.deserialize(jsonParser, deserializationContext);
                }
            }
            return typeDeserializer.deserializeTypedFromScalar(jsonParser, deserializationContext);
        }
    }

    @JacksonStdImpl
    public static class DoubleDeserializer
    extends PrimitiveOrWrapperDeserializer<Double> {
        static final DoubleDeserializer primitiveInstance = new DoubleDeserializer(Double.TYPE, 0.0);
        static final DoubleDeserializer wrapperInstance = new DoubleDeserializer(Double.class, null);

        public DoubleDeserializer(Class<Double> clazz, Double d2) {
            super(clazz, LogicalType.Float, d2, 0.0);
        }

        @Override
        public Double deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
                return jsonParser.getDoubleValue();
            }
            if (this._primitive) {
                return this._parseDoublePrimitive(jsonParser, deserializationContext);
            }
            return this._parseDouble(jsonParser, deserializationContext);
        }

        @Override
        public Double deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
                return jsonParser.getDoubleValue();
            }
            if (this._primitive) {
                return this._parseDoublePrimitive(jsonParser, deserializationContext);
            }
            return this._parseDouble(jsonParser, deserializationContext);
        }

        protected final Double _parseDouble(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String string;
            switch (jsonParser.currentTokenId()) {
                case 6: {
                    string = jsonParser.getText();
                    break;
                }
                case 11: {
                    return (Double)this.getNullValue(deserializationContext);
                }
                case 7: {
                    CoercionAction coercionAction = this._checkIntToFloatCoercion(jsonParser, deserializationContext, this._valueClass);
                    if (coercionAction == CoercionAction.AsNull) {
                        return (Double)this.getNullValue(deserializationContext);
                    }
                    if (coercionAction == CoercionAction.AsEmpty) {
                        return (Double)this.getEmptyValue(deserializationContext);
                    }
                }
                case 8: {
                    return jsonParser.getDoubleValue();
                }
                case 1: {
                    string = deserializationContext.extractScalarFromObject(jsonParser, this, this._valueClass);
                    break;
                }
                case 3: {
                    return (Double)this._deserializeFromArray(jsonParser, deserializationContext);
                }
                default: {
                    return (Double)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                }
            }
            Object object = this._checkDoubleSpecialValue(string);
            if (object != null) {
                return object;
            }
            object = this._checkFromStringCoercion(deserializationContext, string);
            if (object == CoercionAction.AsNull) {
                return (Double)this.getNullValue(deserializationContext);
            }
            if (object == CoercionAction.AsEmpty) {
                return (Double)this.getEmptyValue(deserializationContext);
            }
            if (this._checkTextualNull(deserializationContext, string = string.trim())) {
                return (Double)this.getNullValue(deserializationContext);
            }
            jsonParser.streamReadConstraints().validateFPLength(string.length());
            try {
                return DoubleDeserializer._parseDouble(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Double)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid `Double` value", new Object[0]);
            }
        }
    }

    @JacksonStdImpl
    public static class FloatDeserializer
    extends PrimitiveOrWrapperDeserializer<Float> {
        static final FloatDeserializer primitiveInstance = new FloatDeserializer(Float.TYPE, Float.valueOf(0.0f));
        static final FloatDeserializer wrapperInstance = new FloatDeserializer(Float.class, null);

        public FloatDeserializer(Class<Float> clazz, Float f2) {
            super(clazz, LogicalType.Float, f2, Float.valueOf(0.0f));
        }

        @Override
        public Float deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
                return Float.valueOf(jsonParser.getFloatValue());
            }
            if (this._primitive) {
                return Float.valueOf(this._parseFloatPrimitive(jsonParser, deserializationContext));
            }
            return this._parseFloat(jsonParser, deserializationContext);
        }

        protected final Float _parseFloat(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String string;
            switch (jsonParser.currentTokenId()) {
                case 6: {
                    string = jsonParser.getText();
                    break;
                }
                case 11: {
                    return (Float)this.getNullValue(deserializationContext);
                }
                case 7: {
                    CoercionAction coercionAction = this._checkIntToFloatCoercion(jsonParser, deserializationContext, this._valueClass);
                    if (coercionAction == CoercionAction.AsNull) {
                        return (Float)this.getNullValue(deserializationContext);
                    }
                    if (coercionAction == CoercionAction.AsEmpty) {
                        return (Float)this.getEmptyValue(deserializationContext);
                    }
                }
                case 8: {
                    return Float.valueOf(jsonParser.getFloatValue());
                }
                case 1: {
                    string = deserializationContext.extractScalarFromObject(jsonParser, this, this._valueClass);
                    break;
                }
                case 3: {
                    return (Float)this._deserializeFromArray(jsonParser, deserializationContext);
                }
                default: {
                    return (Float)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                }
            }
            Object object = this._checkFloatSpecialValue(string);
            if (object != null) {
                return object;
            }
            object = this._checkFromStringCoercion(deserializationContext, string);
            if (object == CoercionAction.AsNull) {
                return (Float)this.getNullValue(deserializationContext);
            }
            if (object == CoercionAction.AsEmpty) {
                return (Float)this.getEmptyValue(deserializationContext);
            }
            if (this._checkTextualNull(deserializationContext, string = string.trim())) {
                return (Float)this.getNullValue(deserializationContext);
            }
            try {
                return Float.valueOf(NumberInput.parseFloat(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Float)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid `Float` value", new Object[0]);
            }
        }
    }

    @JacksonStdImpl
    public static final class LongDeserializer
    extends PrimitiveOrWrapperDeserializer<Long> {
        static final LongDeserializer primitiveInstance = new LongDeserializer(Long.TYPE, 0L);
        static final LongDeserializer wrapperInstance = new LongDeserializer(Long.class, null);

        public LongDeserializer(Class<Long> clazz, Long l2) {
            super(clazz, LogicalType.Integer, l2, 0L);
        }

        @Override
        public boolean isCachable() {
            return true;
        }

        @Override
        public Long deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getLongValue();
            }
            if (this._primitive) {
                return this._parseLongPrimitive(jsonParser, deserializationContext);
            }
            return this._parseLong(jsonParser, deserializationContext, Long.class);
        }
    }

    @JacksonStdImpl
    public static final class IntegerDeserializer
    extends PrimitiveOrWrapperDeserializer<Integer> {
        static final IntegerDeserializer primitiveInstance = new IntegerDeserializer(Integer.TYPE, 0);
        static final IntegerDeserializer wrapperInstance = new IntegerDeserializer(Integer.class, null);

        public IntegerDeserializer(Class<Integer> clazz, Integer n2) {
            super(clazz, LogicalType.Integer, n2, 0);
        }

        @Override
        public boolean isCachable() {
            return true;
        }

        @Override
        public Integer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getIntValue();
            }
            if (this._primitive) {
                return this._parseIntPrimitive(jsonParser, deserializationContext);
            }
            return this._parseInteger(jsonParser, deserializationContext, Integer.class);
        }

        @Override
        public Integer deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getIntValue();
            }
            if (this._primitive) {
                return this._parseIntPrimitive(jsonParser, deserializationContext);
            }
            return this._parseInteger(jsonParser, deserializationContext, Integer.class);
        }
    }

    @JacksonStdImpl
    public static class CharacterDeserializer
    extends PrimitiveOrWrapperDeserializer<Character> {
        static final CharacterDeserializer primitiveInstance = new CharacterDeserializer(Character.TYPE, Character.valueOf('\u0000'));
        static final CharacterDeserializer wrapperInstance = new CharacterDeserializer(Character.class, null);

        public CharacterDeserializer(Class<Character> clazz, Character c2) {
            super(clazz, LogicalType.Integer, c2, Character.valueOf('\u0000'));
        }

        @Override
        public Character deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String string;
            switch (jsonParser.currentTokenId()) {
                case 6: {
                    string = jsonParser.getText();
                    break;
                }
                case 7: {
                    CoercionAction coercionAction = deserializationContext.findCoercionAction(this.logicalType(), this._valueClass, CoercionInputShape.Integer);
                    switch (coercionAction) {
                        case Fail: {
                            this._checkCoercionFail(deserializationContext, coercionAction, this._valueClass, jsonParser.getNumberValue(), "Integer value (" + jsonParser.getText() + ")");
                        }
                        case AsNull: {
                            return (Character)this.getNullValue(deserializationContext);
                        }
                        case AsEmpty: {
                            return (Character)this.getEmptyValue(deserializationContext);
                        }
                    }
                    int n2 = jsonParser.getIntValue();
                    if (n2 >= 0 && n2 <= 65535) {
                        return Character.valueOf((char)n2);
                    }
                    return (Character)deserializationContext.handleWeirdNumberValue(this.handledType(), n2, "value outside valid Character range (0x0000 - 0xFFFF)", new Object[0]);
                }
                case 11: {
                    if (this._primitive) {
                        this._verifyNullForPrimitive(deserializationContext);
                    }
                    return (Character)this.getNullValue(deserializationContext);
                }
                case 1: {
                    string = deserializationContext.extractScalarFromObject(jsonParser, this, this._valueClass);
                    break;
                }
                case 3: {
                    return (Character)this._deserializeFromArray(jsonParser, deserializationContext);
                }
                default: {
                    return (Character)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                }
            }
            if (string.length() == 1) {
                return Character.valueOf(string.charAt(0));
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
            if (coercionAction == CoercionAction.AsNull) {
                return (Character)this.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (Character)this.getEmptyValue(deserializationContext);
            }
            if (this._checkTextualNull(deserializationContext, string = string.trim())) {
                return (Character)this.getNullValue(deserializationContext);
            }
            return (Character)deserializationContext.handleWeirdStringValue(this.handledType(), string, "Expected either Integer value code or 1-character String", new Object[0]);
        }
    }

    @JacksonStdImpl
    public static class ShortDeserializer
    extends PrimitiveOrWrapperDeserializer<Short> {
        static final ShortDeserializer primitiveInstance = new ShortDeserializer(Short.TYPE, (short)0);
        static final ShortDeserializer wrapperInstance = new ShortDeserializer(Short.class, null);

        public ShortDeserializer(Class<Short> clazz, Short s2) {
            super(clazz, LogicalType.Integer, s2, (short)0);
        }

        @Override
        public Short deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getShortValue();
            }
            if (this._primitive) {
                return this._parseShortPrimitive(jsonParser, deserializationContext);
            }
            return this._parseShort(jsonParser, deserializationContext);
        }

        protected Short _parseShort(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            int n2;
            String string;
            switch (jsonParser.currentTokenId()) {
                case 6: {
                    string = jsonParser.getText();
                    break;
                }
                case 8: {
                    CoercionAction coercionAction = this._checkFloatToIntCoercion(jsonParser, deserializationContext, this._valueClass);
                    if (coercionAction == CoercionAction.AsNull) {
                        return (Short)this.getNullValue(deserializationContext);
                    }
                    if (coercionAction == CoercionAction.AsEmpty) {
                        return (Short)this.getEmptyValue(deserializationContext);
                    }
                    return jsonParser.getShortValue();
                }
                case 11: {
                    return (Short)this.getNullValue(deserializationContext);
                }
                case 7: {
                    return jsonParser.getShortValue();
                }
                case 1: {
                    string = deserializationContext.extractScalarFromObject(jsonParser, this, this._valueClass);
                    break;
                }
                case 3: {
                    return (Short)this._deserializeFromArray(jsonParser, deserializationContext);
                }
                default: {
                    return (Short)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                }
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
            if (coercionAction == CoercionAction.AsNull) {
                return (Short)this.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (Short)this.getEmptyValue(deserializationContext);
            }
            if (this._checkTextualNull(deserializationContext, string = string.trim())) {
                return (Short)this.getNullValue(deserializationContext);
            }
            try {
                n2 = NumberInput.parseInt(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Short)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid Short value", new Object[0]);
            }
            if (this._shortOverflow(n2)) {
                return (Short)deserializationContext.handleWeirdStringValue(this._valueClass, string, "overflow, value cannot be represented as 16-bit value", new Object[0]);
            }
            return (short)n2;
        }
    }

    @JacksonStdImpl
    public static class ByteDeserializer
    extends PrimitiveOrWrapperDeserializer<Byte> {
        static final ByteDeserializer primitiveInstance = new ByteDeserializer(Byte.TYPE, (byte)0);
        static final ByteDeserializer wrapperInstance = new ByteDeserializer(Byte.class, null);

        public ByteDeserializer(Class<Byte> clazz, Byte by2) {
            super(clazz, LogicalType.Integer, by2, (byte)0);
        }

        @Override
        public Byte deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            if (jsonParser.isExpectedNumberIntToken()) {
                return jsonParser.getByteValue();
            }
            if (this._primitive) {
                return this._parseBytePrimitive(jsonParser, deserializationContext);
            }
            return this._parseByte(jsonParser, deserializationContext);
        }

        protected Byte _parseByte(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            int n2;
            String string;
            switch (jsonParser.currentTokenId()) {
                case 6: {
                    string = jsonParser.getText();
                    break;
                }
                case 8: {
                    CoercionAction coercionAction = this._checkFloatToIntCoercion(jsonParser, deserializationContext, this._valueClass);
                    if (coercionAction == CoercionAction.AsNull) {
                        return (Byte)this.getNullValue(deserializationContext);
                    }
                    if (coercionAction == CoercionAction.AsEmpty) {
                        return (Byte)this.getEmptyValue(deserializationContext);
                    }
                    return jsonParser.getByteValue();
                }
                case 11: {
                    return (Byte)this.getNullValue(deserializationContext);
                }
                case 7: {
                    return jsonParser.getByteValue();
                }
                case 3: {
                    return (Byte)this._deserializeFromArray(jsonParser, deserializationContext);
                }
                case 1: {
                    string = deserializationContext.extractScalarFromObject(jsonParser, this, this._valueClass);
                    break;
                }
                default: {
                    return (Byte)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
                }
            }
            CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
            if (coercionAction == CoercionAction.AsNull) {
                return (Byte)this.getNullValue(deserializationContext);
            }
            if (coercionAction == CoercionAction.AsEmpty) {
                return (Byte)this.getEmptyValue(deserializationContext);
            }
            if (this._checkTextualNull(deserializationContext, string = string.trim())) {
                return (Byte)this.getNullValue(deserializationContext);
            }
            try {
                n2 = NumberInput.parseInt(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid Byte value", new Object[0]);
            }
            if (this._byteOverflow(n2)) {
                return (Byte)deserializationContext.handleWeirdStringValue(this._valueClass, string, "overflow, value cannot be represented as 8-bit value", new Object[0]);
            }
            return (byte)n2;
        }
    }

    @JacksonStdImpl
    public static final class BooleanDeserializer
    extends PrimitiveOrWrapperDeserializer<Boolean> {
        static final BooleanDeserializer primitiveInstance = new BooleanDeserializer(Boolean.TYPE, Boolean.FALSE);
        static final BooleanDeserializer wrapperInstance = new BooleanDeserializer(Boolean.class, null);

        public BooleanDeserializer(Class<Boolean> clazz, Boolean bl2) {
            super(clazz, LogicalType.Boolean, bl2, Boolean.FALSE);
        }

        @Override
        public Boolean deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonToken jsonToken = jsonParser.currentToken();
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (this._primitive) {
                return this._parseBooleanPrimitive(jsonParser, deserializationContext);
            }
            return this._parseBoolean(jsonParser, deserializationContext, this._valueClass);
        }

        @Override
        public Boolean deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
            JsonToken jsonToken = jsonParser.currentToken();
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (this._primitive) {
                return this._parseBooleanPrimitive(jsonParser, deserializationContext);
            }
            return this._parseBoolean(jsonParser, deserializationContext, this._valueClass);
        }
    }

    protected static abstract class PrimitiveOrWrapperDeserializer<T>
    extends StdScalarDeserializer<T> {
        protected final LogicalType _logicalType;
        protected final T _nullValue;
        protected final T _emptyValue;
        protected final boolean _primitive;

        protected PrimitiveOrWrapperDeserializer(Class<T> clazz, LogicalType logicalType, T t2, T t3) {
            super(clazz);
            this._logicalType = logicalType;
            this._nullValue = t2;
            this._emptyValue = t3;
            this._primitive = clazz.isPrimitive();
        }

        @Override
        public AccessPattern getNullAccessPattern() {
            if (this._primitive) {
                return AccessPattern.DYNAMIC;
            }
            if (this._nullValue == null) {
                return AccessPattern.ALWAYS_NULL;
            }
            return AccessPattern.CONSTANT;
        }

        @Override
        public final T getNullValue(DeserializationContext deserializationContext) throws JsonMappingException {
            if (this._primitive && deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
                deserializationContext.reportInputMismatch(this, "Cannot map `null` into type %s (set DeserializationConfig.DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES to 'false' to allow)", ClassUtil.classNameOf(this.handledType()));
            }
            return this._nullValue;
        }

        @Override
        public Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
            return this._emptyValue;
        }

        @Override
        public final LogicalType logicalType() {
            return this._logicalType;
        }
    }
}

