/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonSetter;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.ConfigFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.ConfigOverride;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.DatatypeFeatures;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.TypeFactory;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.RootNameLookup;
import java.io.Serializable;

public abstract class MapperConfigBase<CFG extends ConfigFeature, T extends MapperConfigBase<CFG, T>>
extends MapperConfig<T>
implements Serializable {
    protected static final ConfigOverride EMPTY_OVERRIDE = ConfigOverride.empty();
    private static final long DEFAULT_MAPPER_FEATURES = MapperFeature.collectLongDefaults();
    private static final long AUTO_DETECT_MASK = MapperFeature.AUTO_DETECT_FIELDS.getLongMask() | MapperFeature.AUTO_DETECT_GETTERS.getLongMask() | MapperFeature.AUTO_DETECT_IS_GETTERS.getLongMask() | MapperFeature.AUTO_DETECT_SETTERS.getLongMask() | MapperFeature.AUTO_DETECT_CREATORS.getLongMask();
    protected final SimpleMixInResolver _mixIns;
    protected final SubtypeResolver _subtypeResolver;
    protected final PropertyName _rootName;
    protected final Class<?> _view;
    protected final ContextAttributes _attributes;
    protected final RootNameLookup _rootNames;
    protected final ConfigOverrides _configOverrides;
    protected final DatatypeFeatures _datatypeFeatures;

    protected MapperConfigBase(BaseSettings baseSettings, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides, DatatypeFeatures datatypeFeatures) {
        super(baseSettings, DEFAULT_MAPPER_FEATURES);
        this._mixIns = simpleMixInResolver;
        this._subtypeResolver = subtypeResolver;
        this._rootNames = rootNameLookup;
        this._rootName = null;
        this._view = null;
        this._attributes = ContextAttributes.getEmpty();
        this._configOverrides = configOverrides;
        this._datatypeFeatures = datatypeFeatures;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, BaseSettings baseSettings) {
        super(mapperConfigBase, baseSettings);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
        this._datatypeFeatures = mapperConfigBase._datatypeFeatures;
    }

    protected MapperConfigBase(MapperConfigBase<CFG, T> mapperConfigBase, long l2) {
        super(mapperConfigBase, l2);
        this._mixIns = mapperConfigBase._mixIns;
        this._subtypeResolver = mapperConfigBase._subtypeResolver;
        this._rootNames = mapperConfigBase._rootNames;
        this._rootName = mapperConfigBase._rootName;
        this._view = mapperConfigBase._view;
        this._attributes = mapperConfigBase._attributes;
        this._configOverrides = mapperConfigBase._configOverrides;
        this._datatypeFeatures = mapperConfigBase._datatypeFeatures;
    }

    protected abstract T _withBase(BaseSettings var1);

    protected abstract T _withMapperFeatures(long var1);

    public final T with(MapperFeature ... mapperFeatureArray) {
        long l2 = this._mapperFeatures;
        for (MapperFeature mapperFeature : mapperFeatureArray) {
            l2 |= mapperFeature.getLongMask();
        }
        if (l2 == this._mapperFeatures) {
            return (T)this;
        }
        return this._withMapperFeatures(l2);
    }

    public final T without(MapperFeature ... mapperFeatureArray) {
        long l2 = this._mapperFeatures;
        for (MapperFeature mapperFeature : mapperFeatureArray) {
            l2 &= mapperFeature.getLongMask() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (l2 == this._mapperFeatures) {
            return (T)this;
        }
        return this._withMapperFeatures(l2);
    }

    public final T with(TypeFactory typeFactory) {
        return this._withBase(this._base.withTypeFactory(typeFactory));
    }

    public final T with(PropertyNamingStrategy propertyNamingStrategy) {
        return this._withBase(this._base.withPropertyNamingStrategy(propertyNamingStrategy));
    }

    public final DatatypeFeatures getDatatypeFeatures() {
        return this._datatypeFeatures;
    }

    public final SubtypeResolver getSubtypeResolver() {
        return this._subtypeResolver;
    }

    public final PropertyName getFullRootName() {
        return this._rootName;
    }

    public final Class<?> getActiveView() {
        return this._view;
    }

    public final ContextAttributes getAttributes() {
        return this._attributes;
    }

    @Override
    public final ConfigOverride getConfigOverride(Class<?> clazz) {
        ConfigOverride configOverride = this._configOverrides.findOverride(clazz);
        return configOverride == null ? EMPTY_OVERRIDE : configOverride;
    }

    public final JsonInclude.Value getDefaultPropertyInclusion() {
        return this._configOverrides.getDefaultInclusion();
    }

    @Override
    public final JsonInclude.Value getDefaultPropertyInclusion(Class<?> clazz) {
        JsonInclude.Value value = this.getConfigOverride(clazz).getInclude();
        JsonInclude.Value value2 = this.getDefaultPropertyInclusion();
        if (value2 == null) {
            return value;
        }
        return value2.withOverrides(value);
    }

    @Override
    public final JsonInclude.Value getDefaultInclusion(Class<?> clazz, Class<?> clazz2) {
        JsonInclude.Value value = this.getConfigOverride(clazz2).getIncludeAsProperty();
        JsonInclude.Value value2 = this.getDefaultPropertyInclusion(clazz);
        if (value2 == null) {
            return value;
        }
        return value2.withOverrides(value);
    }

    @Override
    public final JsonFormat.Value getDefaultPropertyFormat(Class<?> clazz) {
        return this._configOverrides.findFormatDefaults(clazz);
    }

    public final JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> clazz) {
        JsonIgnoreProperties.Value value;
        ConfigOverride configOverride = this._configOverrides.findOverride(clazz);
        if (configOverride != null && (value = configOverride.getIgnorals()) != null) {
            return value;
        }
        return null;
    }

    public final JsonIgnoreProperties.Value getDefaultPropertyIgnorals(Class<?> clazz, AnnotatedClass annotatedClass) {
        AnnotationIntrospector annotationIntrospector = this.getAnnotationIntrospector();
        JsonIgnoreProperties.Value value = annotationIntrospector == null ? null : annotationIntrospector.findPropertyIgnoralByName(this, annotatedClass);
        JsonIgnoreProperties.Value value2 = this.getDefaultPropertyIgnorals(clazz);
        return JsonIgnoreProperties.Value.merge(value, value2);
    }

    public final JsonIncludeProperties.Value getDefaultPropertyInclusions(Class<?> clazz, AnnotatedClass annotatedClass) {
        AnnotationIntrospector annotationIntrospector = this.getAnnotationIntrospector();
        return annotationIntrospector == null ? null : annotationIntrospector.findPropertyInclusionByName(this, annotatedClass);
    }

    public final VisibilityChecker<?> getDefaultVisibilityChecker() {
        VisibilityChecker<?> visibilityChecker = this._configOverrides.getDefaultVisibility();
        if ((this._mapperFeatures & AUTO_DETECT_MASK) != AUTO_DETECT_MASK) {
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_FIELDS)) {
                visibilityChecker = visibilityChecker.withFieldVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_GETTERS)) {
                visibilityChecker = visibilityChecker.withGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_IS_GETTERS)) {
                visibilityChecker = visibilityChecker.withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_SETTERS)) {
                visibilityChecker = visibilityChecker.withSetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            if (!this.isEnabled(MapperFeature.AUTO_DETECT_CREATORS)) {
                visibilityChecker = visibilityChecker.withCreatorVisibility(JsonAutoDetect.Visibility.NONE);
            }
        }
        return visibilityChecker;
    }

    @Override
    public final VisibilityChecker<?> getDefaultVisibilityChecker(Class<?> clazz, AnnotatedClass annotatedClass) {
        ConfigOverride configOverride;
        VisibilityChecker<VisibilityChecker.Std> visibilityChecker = ClassUtil.isJDKClass(clazz) ? VisibilityChecker.Std.allPublicInstance() : this.getDefaultVisibilityChecker();
        AnnotationIntrospector annotationIntrospector = this.getAnnotationIntrospector();
        if (annotationIntrospector != null) {
            visibilityChecker = annotationIntrospector.findAutoDetectVisibility(annotatedClass, visibilityChecker);
        }
        if ((configOverride = this._configOverrides.findOverride(clazz)) != null) {
            visibilityChecker = visibilityChecker.withOverrides(configOverride.getVisibility());
        }
        return visibilityChecker;
    }

    @Override
    public final JsonSetter.Value getDefaultSetterInfo() {
        return this._configOverrides.getDefaultSetterInfo();
    }

    @Override
    public Boolean getDefaultMergeable() {
        return this._configOverrides.getDefaultMergeable();
    }

    public Boolean getDefaultMergeable(Class<?> clazz) {
        Boolean bl2;
        ConfigOverride configOverride = this._configOverrides.findOverride(clazz);
        if (configOverride != null && (bl2 = configOverride.getMergeable()) != null) {
            return bl2;
        }
        return this._configOverrides.getDefaultMergeable();
    }

    public PropertyName findRootName(JavaType javaType) {
        if (this._rootName != null) {
            return this._rootName;
        }
        return this._rootNames.findRootName(javaType, this);
    }

    public PropertyName findRootName(Class<?> clazz) {
        if (this._rootName != null) {
            return this._rootName;
        }
        return this._rootNames.findRootName(clazz, this);
    }

    @Override
    public final Class<?> findMixInClassFor(Class<?> clazz) {
        return this._mixIns.findMixInClassFor(clazz);
    }
}

