/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.exc.StreamConstraintsException;
import java.io.Serializable;

public class StreamReadConstraints
implements Serializable {
    protected final int _maxNestingDepth;
    protected final int _maxNumLen;
    protected final int _maxStringLen;
    private static StreamReadConstraints DEFAULT = new StreamReadConstraints(1000, 1000, 20000000);

    protected StreamReadConstraints(int n2, int n3, int n4) {
        this._maxNestingDepth = n2;
        this._maxNumLen = n3;
        this._maxStringLen = n4;
    }

    public static StreamReadConstraints defaults() {
        return DEFAULT;
    }

    public void validateNestingDepth(int n2) throws StreamConstraintsException {
        if (n2 > this._maxNestingDepth) {
            throw new StreamConstraintsException(String.format("Depth (%d) exceeds the maximum allowed nesting depth (%d)", n2, this._maxNestingDepth));
        }
    }

    public void validateFPLength(int n2) throws StreamConstraintsException {
        if (n2 > this._maxNumLen) {
            throw new StreamConstraintsException(String.format("Number length (%d) exceeds the maximum length (%d)", n2, this._maxNumLen));
        }
    }

    public void validateIntegerLength(int n2) throws StreamConstraintsException {
        if (n2 > this._maxNumLen) {
            throw new StreamConstraintsException(String.format("Number length (%d) exceeds the maximum length (%d)", n2, this._maxNumLen));
        }
    }

    public void validateStringLength(int n2) throws StreamConstraintsException {
        if (n2 > this._maxStringLen) {
            throw new StreamConstraintsException(String.format("String length (%d) exceeds the maximum length (%d)", n2, this._maxStringLen));
        }
    }

    public void validateBigIntegerScale(int n2) throws StreamConstraintsException {
        int n3 = Math.abs(n2);
        int n4 = 100000;
        if (n3 > 100000) {
            throw new StreamConstraintsException(String.format("BigDecimal scale (%d) magnitude exceeds maximum allowed (%d)", n2, 100000));
        }
    }
}

