/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin;

import com.gradle.enterprise.version.a.a;
import com.gradle.enterprise.version.buildagent.BuildAgentToolVersion;
import com.gradle.obfuscation.Keep;
import com.gradle.scan.plugin.BuildScanException;
import com.gradle.scan.plugin.internal.g;
import com.gradle.scan.plugin.internal.h;
import com.gradle.scan.plugin.internal.o;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;

@Keep
public final class BuildScanPlugin
implements Plugin<Object> {
    private static final g FACADE = new g(BuildScanPlugin.class, "build scan");

    public void apply(Object object) {
        BuildAgentToolVersion buildAgentToolVersion;
        Gradle gradle;
        Project project;
        if (object instanceof Project) {
            project = (Project)object;
            gradle = project.getGradle();
            buildAgentToolVersion = h.a(gradle);
            BuildScanPlugin.failIfGradleVersionNotSupported(buildAgentToolVersion);
            BuildScanPlugin.failIfNotRootProject(project);
            BuildScanPlugin.failIfRootProjectAlreadyEvaluated(project);
            if (BuildScanPlugin.pluginAlreadyApplied(project)) {
                return;
            }
        } else {
            throw new BuildScanException("The build scan plugin must be applied to the root project (was applied to " + BuildScanPlugin.pluginApplicationTargetDisplayName(object) + ")");
        }
        h.a(project, h.c.FIRST_OF_FIRST, buildAgentToolVersion, gradle, project.getRootDir(), FACADE, action -> action.execute((Object)project));
    }

    public static String pluginApplicationTargetDisplayName(Object object) {
        if (object instanceof Project) {
            return "a project";
        }
        if (object instanceof Settings) {
            return "settings";
        }
        if (object instanceof Gradle) {
            return "init script";
        }
        return object.getClass().getName();
    }

    private static boolean pluginAlreadyApplied(Project project) {
        return project.getPlugins().stream().anyMatch(plugin -> plugin.getClass().getName().equals(BuildScanPlugin.class.getName()));
    }

    private static void failIfNotRootProject(Project project) {
        if (!project.equals(project.getRootProject())) {
            throw new BuildScanException("The Gradle Enterprise plugin can only be applied to the root project.");
        }
    }

    private static void failIfRootProjectAlreadyEvaluated(Project project) {
        if (project.getState().getExecuted()) {
            throw new BuildScanException(o.a("The Gradle Enterprise plugin must be applied early in the build lifecycle.", "Fixing this problem requires changing how you are applying the Gradle Enterprise plugin to your build.", "", "Please see https://gradle.com/help/plugin-late-apply for how to resolve this problem."));
        }
    }

    private static void failIfGradleVersionNotSupported(BuildAgentToolVersion buildAgentToolVersion) {
        if (buildAgentToolVersion.a(a.ab)) {
            throw new BuildScanException(o.a(new String[]{"The build scan plugin is not compatible with Gradle 6.0 and later.", "Please use the Gradle Enterprise plugin instead."}));
        }
        if (!buildAgentToolVersion.a(a.ap)) {
            if (buildAgentToolVersion.a(a.aY)) {
                throw new BuildScanException(o.a(new String[]{"This version of the build scan plugin is not compatible with less than Gradle 5.0.", "Please use version 1.16 of the build scan plugin."}));
            }
            throw new BuildScanException(o.a(new String[]{"Build scans are not supported for Gradle 1.x.", "Please use a newer version of Gradle."}));
        }
    }
}

