/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.gradleplugin.test;

import com.gradle.enterprise.gradleplugin.test.JUnitXmlDialect;
import com.gradle.junit.xml.streaming.parser.j;
import com.gradle.obfuscation.Keep;
import com.gradle.obfuscation.KeepMethods;
import com.gradle.obfuscation.KeepName;
import com.gradle.scan.plugin.internal.c.ac.e;
import com.gradle.scan.plugin.internal.h;
import java.io.File;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.DefaultProjectRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.scan.time.BuildScanClock;
import org.gradle.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Keep
@KeepName
@KeepMethods
public abstract class ImportJUnitXmlReports
extends DefaultTask {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ImportJUnitXmlReports.class);
    private static final String TASK_NAME_SUFFIX = "ImportJUnitXmlReports";
    private final BuildOperationListener eventEmitter;
    private final BuildScanClock clock;
    private final transient Property<Task> referenceTask;

    @Inject
    public ImportJUnitXmlReports(BuildOperationListenerManager buildOperationListenerManager, BuildScanClock buildScanClock, ObjectFactory objectFactory, Gradle gradle) {
        this.eventEmitter = buildOperationListenerManager.getBroadcaster();
        this.clock = buildScanClock;
        this.referenceTask = objectFactory.property(Task.class);
        this.getReferenceTaskBuildPath().convention(this.referenceTask.map(task -> ImportJUnitXmlReports.getBuildPath((TaskInternal)task)));
        this.getReferenceTaskTaskPath().convention(this.referenceTask.map(task -> ImportJUnitXmlReports.getTaskPath((TaskInternal)task)));
        if (h.a(gradle).a(com.gradle.enterprise.version.a.a.s)) {
            gradle.getTaskGraph().whenReady(taskExecutionGraph -> {
                if (!this.isPartOfSameBuildAsReferenceTask()) {
                    this.notCompatibleWithConfigurationCache("Referencing tasks across included builds is not supported");
                }
            });
        }
    }

    @Input
    public abstract Property<JUnitXmlDialect> getDialect();

    @Internal
    public abstract ConfigurableFileCollection getReports();

    @Internal
    public Property<Task> getReferenceTask() {
        return this.referenceTask;
    }

    @Internal
    public abstract Property<String> getReferenceTaskBuildPath();

    @Internal
    public abstract Property<String> getReferenceTaskTaskPath();

    @TaskAction
    void importReports() {
        Task task = this.findReferenceTask();
        if (task != null && !task.getDidWork()) {
            this.setDidWork(false);
            return;
        }
        ImportJUnitXmlReports importJUnitXmlReports = task == null ? this : (TaskInternal)task;
        TaskIdentity taskIdentity = importJUnitXmlReports.getTaskIdentity();
        Set set = this.getReports().filter(File::exists).filter(file -> file.getName().endsWith(".xml")).getFiles();
        if (set.isEmpty()) {
            LOGGER.warn("No JUnit XML reports found in any of the declared inputs!");
        } else {
            j j2 = ((JUnitXmlDialect)((Object)this.getDialect().get())).toParserDialect();
            set.stream().map(file -> new a(file.getAbsoluteFile(), taskIdentity, j2)).forEach(this::emitEvent);
        }
    }

    private Task findReferenceTask() {
        if (this.referenceTask == null) {
            String string = (String)this.getReferenceTaskBuildPath().getOrNull();
            String string2 = (String)this.getReferenceTaskTaskPath().getOrNull();
            if (string == null || string2 == null) {
                return null;
            }
            if (this.isPartOfSameBuildAsReferenceTask()) {
                Path path = Path.path((String)string2);
                String string3 = Objects.requireNonNull(path.getParent()).getPath();
                ProjectInternal projectInternal = Objects.requireNonNull((ProjectInternal)this.getProjectRegistry().getProject(string3));
                String string4 = Objects.requireNonNull(path.getName());
                TaskContainer taskContainer = (TaskContainer)projectInternal.getServices().get(TaskContainer.class);
                return taskContainer.getByName(string4);
            }
            throw new InvalidUserDataException("Referencing tasks across included builds is not supported when using the configuration cache: " + string2 + " in " + string);
        }
        return (Task)this.referenceTask.getOrNull();
    }

    private boolean isPartOfSameBuildAsReferenceTask() {
        String string = (String)this.getReferenceTaskBuildPath().getOrNull();
        return string == null || ImportJUnitXmlReports.getBuildPath((TaskInternal)this).equals(string);
    }

    private ProjectRegistry<ProjectInternal> getProjectRegistry() {
        return (ProjectRegistry)this.getServices().get(DefaultProjectRegistry.class);
    }

    private void emitEvent(e e2) {
        this.eventEmitter.progress(com.gradle.enterprise.a.a.a(CurrentBuildOperationRef.instance().getId(), () -> "operationIdentifier is null"), new OperationProgressEvent(this.clock.getCurrentTime(), (Object)e2));
    }

    public static TaskProvider<ImportJUnitXmlReports> register(TaskContainer taskContainer, TaskProvider<?> taskProvider, JUnitXmlDialect jUnitXmlDialect) {
        TaskProvider<ImportJUnitXmlReports> taskProvider2 = ImportJUnitXmlReports.registerFinalizerTask(taskContainer, taskProvider, jUnitXmlDialect);
        taskProvider.configure(task -> task.finalizedBy(new Object[]{taskProvider2}));
        return taskProvider2;
    }

    private static TaskProvider<ImportJUnitXmlReports> registerFinalizerTask(TaskContainer taskContainer, TaskProvider<?> taskProvider, JUnitXmlDialect jUnitXmlDialect) {
        return taskContainer.register(taskProvider.getName() + TASK_NAME_SUFFIX, ImportJUnitXmlReports.class, importJUnitXmlReports -> {
            importJUnitXmlReports.getDialect().set((Object)jUnitXmlDialect);
            Objects.requireNonNull(importJUnitXmlReports.getReferenceTask()).set((Provider)taskProvider);
            importJUnitXmlReports.getReports().from(new Object[]{taskProvider.map(task -> task.getOutputs().getFiles().getAsFileTree())});
        });
    }

    private static String getTaskPath(TaskInternal taskInternal) {
        return taskInternal.getTaskIdentity().projectPath.getPath();
    }

    private static String getBuildPath(TaskInternal taskInternal) {
        return taskInternal.getTaskIdentity().buildPath.getPath();
    }

    private static class a
    implements e {
        private final File a;
        private final TaskIdentity<?> b;
        private final j c;

        private a(File file, TaskIdentity<?> taskIdentity, j j2) {
            this.a = file;
            this.b = taskIdentity;
            this.c = j2;
        }

        @Override
        public File a() {
            return this.a;
        }

        @Override
        public TaskIdentity<?> b() {
            return this.b;
        }

        @Override
        public j c() {
            return this.c;
        }
    }
}

