/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.ProtocolException;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.WebSocketBehavior;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.Extension;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.CloseInfo;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.OpCode;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;

public class Generator {
    private final WebSocketBehavior behavior;
    private final ByteBufferPool bufferPool;
    private final boolean validating;
    private final boolean readOnly;
    private byte flagsInUse = 0;

    public Generator(WebSocketPolicy webSocketPolicy, ByteBufferPool byteBufferPool) {
        this(webSocketPolicy, byteBufferPool, true, false);
    }

    public Generator(WebSocketPolicy webSocketPolicy, ByteBufferPool byteBufferPool, boolean bl2, boolean bl3) {
        this.behavior = webSocketPolicy.getBehavior();
        this.bufferPool = byteBufferPool;
        this.validating = bl2;
        this.readOnly = bl3;
    }

    public void assertFrameValid(Frame frame) {
        if (!this.validating) {
            return;
        }
        if (frame.isRsv1() && !this.isRsv1InUse()) {
            throw new ProtocolException("RSV1 not allowed to be set");
        }
        if (frame.isRsv2() && !this.isRsv2InUse()) {
            throw new ProtocolException("RSV2 not allowed to be set");
        }
        if (frame.isRsv3() && !this.isRsv3InUse()) {
            throw new ProtocolException("RSV3 not allowed to be set");
        }
        if (OpCode.isControlFrame(frame.getOpCode())) {
            ByteBuffer byteBuffer;
            if (frame.getPayloadLength() > 125) {
                throw new ProtocolException("Invalid control frame payload length");
            }
            if (!frame.isFin()) {
                throw new ProtocolException("Control Frames must be FIN=true");
            }
            if (frame.getOpCode() == 8 && (byteBuffer = frame.getPayload()) != null) {
                new CloseInfo(byteBuffer, true);
            }
        }
    }

    public void configureFromExtensions(List<? extends Extension> list) {
        this.flagsInUse = 0;
        for (Extension extension : list) {
            if (extension.isRsv1User()) {
                this.flagsInUse = (byte)(this.flagsInUse | 0x40);
            }
            if (extension.isRsv2User()) {
                this.flagsInUse = (byte)(this.flagsInUse | 0x20);
            }
            if (!extension.isRsv3User()) continue;
            this.flagsInUse = (byte)(this.flagsInUse | 0x10);
        }
    }

    public ByteBuffer generateHeaderBytes(Frame frame) {
        ByteBuffer byteBuffer = this.bufferPool.acquire(28, true);
        this.generateHeaderBytes(frame, byteBuffer);
        return byteBuffer;
    }

    public void generateHeaderBytes(Frame frame, ByteBuffer byteBuffer) {
        int n2 = BufferUtil.flipToFill(byteBuffer);
        this.assertFrameValid(frame);
        byte by2 = 0;
        if (frame.isFin()) {
            by2 = (byte)(by2 | 0x80);
        }
        if (frame.isRsv1()) {
            by2 = (byte)(by2 | 0x40);
        }
        if (frame.isRsv2()) {
            by2 = (byte)(by2 | 0x20);
        }
        if (frame.isRsv3()) {
            by2 = (byte)(by2 | 0x10);
        }
        byte by3 = frame.getOpCode();
        if (frame.getOpCode() == 0) {
            by3 = 0;
        }
        by2 = (byte)(by2 | by3 & 0xF);
        byteBuffer.put(by2);
        by2 = frame.isMasked() ? (byte)-128 : 0;
        int n3 = frame.getPayloadLength();
        if (n3 > 65535) {
            by2 = (byte)(by2 | 0x7F);
            byteBuffer.put(by2);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)0);
            byteBuffer.put((byte)(n3 >> 24 & 0xFF));
            byteBuffer.put((byte)(n3 >> 16 & 0xFF));
            byteBuffer.put((byte)(n3 >> 8 & 0xFF));
            byteBuffer.put((byte)(n3 & 0xFF));
        } else if (n3 >= 126) {
            by2 = (byte)(by2 | 0x7E);
            byteBuffer.put(by2);
            byteBuffer.put((byte)(n3 >> 8));
            byteBuffer.put((byte)(n3 & 0xFF));
        } else {
            by2 = (byte)(by2 | n3 & 0x7F);
            byteBuffer.put(by2);
        }
        if (frame.isMasked() && !this.readOnly) {
            byte[] byArray = frame.getMask();
            byteBuffer.put(byArray);
            int n4 = 0;
            for (byte n5 : byArray) {
                n4 = (n4 << 8) + (n5 & 0xFF);
            }
            Object object = frame.getPayload();
            if (object != null && ((Buffer)object).remaining() > 0) {
                int n5;
                int n7 = 0;
                int n8 = ((Buffer)object).position();
                int n6 = ((Buffer)object).limit();
                while ((n5 = n6 - n8) > 0) {
                    if (n5 >= 4) {
                        ((ByteBuffer)object).putInt(n8, ((ByteBuffer)object).getInt(n8) ^ n4);
                        n8 += 4;
                        continue;
                    }
                    ((ByteBuffer)object).put(n8, (byte)(((ByteBuffer)object).get(n8) ^ byArray[n7 & 3]));
                    ++n8;
                    ++n7;
                }
            }
        }
        BufferUtil.flipToFlush(byteBuffer, n2);
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public boolean isRsv1InUse() {
        return (this.flagsInUse & 0x40) != 0;
    }

    public boolean isRsv2InUse() {
        return (this.flagsInUse & 0x20) != 0;
    }

    public boolean isRsv3InUse() {
        return (this.flagsInUse & 0x10) != 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Generator[");
        stringBuilder.append((Object)this.behavior);
        if (this.validating) {
            stringBuilder.append(",validating");
        }
        if (this.isRsv1InUse()) {
            stringBuilder.append(",+rsv1");
        }
        if (this.isRsv2InUse()) {
            stringBuilder.append(",+rsv2");
        }
        if (this.isRsv3InUse()) {
            stringBuilder.append(",+rsv3");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

