/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.ssl;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class X509 {
    private static final Logger LOG = Log.getLogger(X509.class);
    private final X509Certificate _x509;
    private final String _alias;
    private final Set<String> _hosts = new LinkedHashSet<String>();
    private final Set<String> _wilds = new LinkedHashSet<String>();
    private final Set<InetAddress> _addresses = new LinkedHashSet<InetAddress>();

    public static boolean isCertSign(X509Certificate x509Certificate) {
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray == null || blArray.length <= 5) {
            return false;
        }
        return blArray[5];
    }

    public X509(String string, X509Certificate x509Certificate) {
        this._alias = string;
        this._x509 = x509Certificate;
        try {
            String string2;
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (collection != null) {
                for (List<?> object : collection) {
                    int rdn = ((Number)object.get(0)).intValue();
                    switch (rdn) {
                        case 2: {
                            string2 = object.get(1).toString();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Certificate alias={} SAN dns={} in {}", string, string2, this);
                            }
                            this.addName(string2);
                            break;
                        }
                        case 7: {
                            string2 = object.get(1).toString();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Certificate alias={} SAN ip={} in {}", string, string2, this);
                            }
                            this.addAddress(string2);
                            break;
                        }
                    }
                }
            }
            LdapName ldapName = new LdapName(x509Certificate.getSubjectX500Principal().getName("RFC2253"));
            for (Rdn rdn : ldapName.getRdns()) {
                if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                string2 = rdn.getValue().toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Certificate CN alias={} CN={} in {}", string, string2, this);
                }
                this.addName(string2);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    protected void addName(String string) {
        if (string != null) {
            if ((string = StringUtil.asciiToLowerCase(string)).startsWith("*.")) {
                this._wilds.add(string.substring(2));
            } else {
                this._hosts.add(string);
            }
        }
    }

    private void addAddress(String string) {
        InetAddress inetAddress = this.toInetAddress(string);
        if (inetAddress != null) {
            this._addresses.add(inetAddress);
        }
    }

    private InetAddress toInetAddress(String string) {
        try {
            return InetAddress.getByName(string);
        }
        catch (Throwable throwable) {
            LOG.ignore(throwable);
            return null;
        }
    }

    public String getAlias() {
        return this._alias;
    }

    public Set<String> getHosts() {
        return Collections.unmodifiableSet(this._hosts);
    }

    public Set<String> getWilds() {
        return Collections.unmodifiableSet(this._wilds);
    }

    public boolean matches(String string) {
        Object object;
        if (this._hosts.contains(string = StringUtil.asciiToLowerCase(string)) || this._wilds.contains(string)) {
            return true;
        }
        int n2 = string.indexOf(46);
        if (n2 >= 0 && this._wilds.contains(object = string.substring(n2 + 1))) {
            return true;
        }
        if (X509.seemsIPAddress(string) && (object = this.toInetAddress(string)) != null) {
            return this._addresses.contains(object);
        }
        return false;
    }

    private static boolean seemsIPAddress(String string) {
        String string2 = "[0-9\\.]+";
        String string3 = "[0-9a-fA-F:\\[\\]]+";
        return string.matches(string2) || string.matches(string3) && X509.containsAtLeastTwoColons(string);
    }

    private static boolean containsAtLeastTwoColons(String string) {
        int n2 = string.indexOf(58);
        if (n2 >= 0) {
            n2 = string.indexOf(58, n2 + 1);
        }
        return n2 > 0;
    }

    public String toString() {
        return String.format("%s@%x(%s,h=%s,a=%s,w=%s)", this.getClass().getSimpleName(), this.hashCode(), this._alias, this._hosts, this._addresses, this._wilds);
    }
}

