/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.MultiMap;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.TypeUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Utf8Appendable;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Utf8StringBuffer;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Utf8StringBuilder;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class UrlEncoded
extends MultiMap<String>
implements Cloneable {
    static final Logger LOG;
    public static final Charset ENCODING;

    public UrlEncoded(UrlEncoded urlEncoded) {
        super(urlEncoded);
    }

    public UrlEncoded() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(String string, MultiMap<String> multiMap, Charset charset) {
        if (charset == null) {
            charset = ENCODING;
        }
        if (StandardCharsets.UTF_8.equals(charset)) {
            UrlEncoded.decodeUtf8To(string, 0, string.length(), multiMap);
            return;
        }
        MultiMap<String> multiMap2 = multiMap;
        synchronized (multiMap2) {
            String string2;
            int n2;
            String string3 = null;
            int n3 = -1;
            boolean bl2 = false;
            block9: for (n2 = 0; n2 < string.length(); ++n2) {
                char c2 = string.charAt(n2);
                switch (c2) {
                    case '&': {
                        int n4 = n2 - n3 - 1;
                        string2 = n4 == 0 ? "" : (bl2 ? UrlEncoded.decodeString(string, n3 + 1, n4, charset) : string.substring(n3 + 1, n2));
                        n3 = n2;
                        bl2 = false;
                        if (string3 != null) {
                            multiMap.add(string3, string2);
                        } else if (string2 != null && string2.length() > 0) {
                            multiMap.add(string2, "");
                        }
                        string3 = null;
                        string2 = null;
                        continue block9;
                    }
                    case '=': {
                        if (string3 != null) continue block9;
                        string3 = bl2 ? UrlEncoded.decodeString(string, n3 + 1, n2 - n3 - 1, charset) : string.substring(n3 + 1, n2);
                        n3 = n2;
                        bl2 = false;
                        continue block9;
                    }
                    case '+': {
                        bl2 = true;
                        continue block9;
                    }
                    case '%': {
                        bl2 = true;
                    }
                }
            }
            if (string3 != null) {
                n2 = string.length() - n3 - 1;
                string2 = n2 == 0 ? "" : (bl2 ? UrlEncoded.decodeString(string, n3 + 1, n2, charset) : string.substring(n3 + 1));
                multiMap.add(string3, string2);
            } else if (n3 < string.length()) {
                String string4 = string3 = bl2 ? UrlEncoded.decodeString(string, n3 + 1, string.length() - n3 - 1, charset) : string.substring(n3 + 1);
                if (string3 != null && string3.length() > 0) {
                    multiMap.add(string3, "");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeUtf8To(String string, int n2, int n3, MultiMap<String> multiMap) {
        Utf8StringBuilder utf8StringBuilder = new Utf8StringBuilder();
        MultiMap<String> multiMap2 = multiMap;
        synchronized (multiMap2) {
            String string2 = null;
            String string3 = null;
            int n4 = n2 + n3;
            block9: for (int i2 = n2; i2 < n4; ++i2) {
                char c2 = string.charAt(i2);
                switch (c2) {
                    case '&': {
                        string3 = utf8StringBuilder.toReplacedString();
                        utf8StringBuilder.reset();
                        if (string2 != null) {
                            multiMap.add(string2, string3);
                        } else if (string3 != null && string3.length() > 0) {
                            multiMap.add(string3, "");
                        }
                        string2 = null;
                        string3 = null;
                        continue block9;
                    }
                    case '=': {
                        if (string2 != null) {
                            utf8StringBuilder.append(c2);
                            continue block9;
                        }
                        string2 = utf8StringBuilder.toReplacedString();
                        utf8StringBuilder.reset();
                        continue block9;
                    }
                    case '+': {
                        utf8StringBuilder.append((byte)32);
                        continue block9;
                    }
                    case '%': {
                        if (i2 + 2 < n4) {
                            char c3 = string.charAt(++i2);
                            char c4 = string.charAt(++i2);
                            utf8StringBuilder.append(UrlEncoded.decodeHexByte(c3, c4));
                            continue block9;
                        }
                        throw new Utf8Appendable.NotUtf8Exception("Incomplete % encoding");
                    }
                    default: {
                        utf8StringBuilder.append(c2);
                    }
                }
            }
            if (string2 != null) {
                string3 = utf8StringBuilder.toReplacedString();
                utf8StringBuilder.reset();
                multiMap.add(string2, string3);
            } else if (utf8StringBuilder.length() > 0) {
                multiMap.add(utf8StringBuilder.toReplacedString(), "");
            }
        }
    }

    public static String decodeString(String string, int n2, int n3, Charset charset) {
        if (charset == null || StandardCharsets.UTF_8.equals(charset)) {
            Utf8Appendable utf8Appendable = null;
            for (int i2 = 0; i2 < n3; ++i2) {
                char c2 = string.charAt(n2 + i2);
                if (c2 < '\u0000' || c2 > '\u00ff') {
                    if (utf8Appendable == null) {
                        utf8Appendable = new Utf8StringBuffer(n3);
                        ((Utf8StringBuffer)utf8Appendable).getStringBuffer().append(string, n2, n2 + i2 + 1);
                        continue;
                    }
                    ((Utf8StringBuffer)utf8Appendable).getStringBuffer().append(c2);
                    continue;
                }
                if (c2 == '+') {
                    if (utf8Appendable == null) {
                        utf8Appendable = new Utf8StringBuffer(n3);
                        ((Utf8StringBuffer)utf8Appendable).getStringBuffer().append(string, n2, n2 + i2);
                    }
                    ((Utf8StringBuffer)utf8Appendable).getStringBuffer().append(' ');
                    continue;
                }
                if (c2 == '%') {
                    if (utf8Appendable == null) {
                        utf8Appendable = new Utf8StringBuffer(n3);
                        ((Utf8StringBuffer)utf8Appendable).getStringBuffer().append(string, n2, n2 + i2);
                    }
                    if (i2 + 2 < n3) {
                        int n4 = n2 + i2 + 1;
                        i2 += 2;
                        byte by2 = (byte)TypeUtil.parseInt(string, n4, 2, 16);
                        utf8Appendable.append(by2);
                        continue;
                    }
                    ((Utf8StringBuffer)utf8Appendable).getStringBuffer().append('\ufffd');
                    i2 = n3;
                    continue;
                }
                if (utf8Appendable == null) continue;
                ((Utf8StringBuffer)utf8Appendable).getStringBuffer().append(c2);
            }
            if (utf8Appendable == null) {
                if (n2 == 0 && string.length() == n3) {
                    return string;
                }
                return string.substring(n2, n2 + n3);
            }
            return utf8Appendable.toReplacedString();
        }
        StringBuffer stringBuffer = null;
        for (int i3 = 0; i3 < n3; ++i3) {
            char c3 = string.charAt(n2 + i3);
            if (c3 < '\u0000' || c3 > '\u00ff') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n3);
                    stringBuffer.append(string, n2, n2 + i3 + 1);
                    continue;
                }
                stringBuffer.append(c3);
                continue;
            }
            if (c3 == '+') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n3);
                    stringBuffer.append(string, n2, n2 + i3);
                }
                stringBuffer.append(' ');
                continue;
            }
            if (c3 == '%') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n3);
                    stringBuffer.append(string, n2, n2 + i3);
                }
                byte[] byArray = new byte[n3];
                int n5 = 0;
                while (c3 >= '\u0000' && c3 <= '\u00ff') {
                    if (c3 == '%') {
                        if (i3 + 2 < n3) {
                            int n6 = n2 + i3 + 1;
                            i3 += 3;
                            byArray[n5] = (byte)TypeUtil.parseInt(string, n6, 2, 16);
                            ++n5;
                        } else {
                            byArray[n5++] = 63;
                            i3 = n3;
                        }
                    } else if (c3 == '+') {
                        byArray[n5++] = 32;
                        ++i3;
                    } else {
                        byArray[n5++] = (byte)c3;
                        ++i3;
                    }
                    if (i3 >= n3) break;
                    c3 = string.charAt(n2 + i3);
                }
                --i3;
                stringBuffer.append(new String(byArray, 0, n5, charset));
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c3);
        }
        if (stringBuffer == null) {
            if (n2 == 0 && string.length() == n3) {
                return string;
            }
            return string.substring(n2, n2 + n3);
        }
        return stringBuffer.toString();
    }

    private static byte decodeHexByte(char c2, char c3) {
        try {
            return (byte)((TypeUtil.convertHexDigit(c2) << 4) + TypeUtil.convertHexDigit(c3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Not valid encoding '%" + c2 + c3 + "'");
        }
    }

    @Override
    public Object clone() {
        return new UrlEncoded(this);
    }

    static {
        Charset charset;
        LOG = Log.getLogger(UrlEncoded.class);
        try {
            String string = System.getProperty("com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.UrlEncoding.charset");
            charset = string == null ? StandardCharsets.UTF_8 : Charset.forName(string);
        }
        catch (Exception exception) {
            LOG.warn(exception);
            charset = StandardCharsets.UTF_8;
        }
        ENCODING = charset;
    }
}

