/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.ArrayTrie;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.StringUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Trie;
import java.nio.ByteBuffer;

public enum HttpVersion {
    HTTP_0_9("HTTP/0.9", 9),
    HTTP_1_0("HTTP/1.0", 10),
    HTTP_1_1("HTTP/1.1", 11),
    HTTP_2("HTTP/2.0", 20);

    public static final Trie<HttpVersion> CACHE;
    private final String _string;
    private final byte[] _bytes;
    private final ByteBuffer _buffer;
    private final int _version;

    public static HttpVersion lookAheadGet(byte[] byArray, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 9) {
            return null;
        }
        if (byArray[n2 + 4] == 47 && byArray[n2 + 6] == 46 && Character.isWhitespace((char)byArray[n2 + 8]) && (byArray[n2] == 72 && byArray[n2 + 1] == 84 && byArray[n2 + 2] == 84 && byArray[n2 + 3] == 80 || byArray[n2] == 104 && byArray[n2 + 1] == 116 && byArray[n2 + 2] == 116 && byArray[n2 + 3] == 112)) {
            switch (byArray[n2 + 5]) {
                case 49: {
                    switch (byArray[n2 + 7]) {
                        case 48: {
                            return HTTP_1_0;
                        }
                        case 49: {
                            return HTTP_1_1;
                        }
                    }
                    break;
                }
                case 50: {
                    switch (byArray[n2 + 7]) {
                        case 48: {
                            return HTTP_2;
                        }
                    }
                }
            }
        }
        return null;
    }

    public static HttpVersion lookAheadGet(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return HttpVersion.lookAheadGet(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.arrayOffset() + byteBuffer.limit());
        }
        return null;
    }

    private HttpVersion(String string2, int n3) {
        this._string = string2;
        this._bytes = StringUtil.getBytes(string2);
        this._buffer = ByteBuffer.wrap(this._bytes);
        this._version = n3;
    }

    public byte[] toBytes() {
        return this._bytes;
    }

    public ByteBuffer toBuffer() {
        return this._buffer.asReadOnlyBuffer();
    }

    public int getVersion() {
        return this._version;
    }

    public String asString() {
        return this._string;
    }

    public String toString() {
        return this._string;
    }

    static {
        CACHE = new ArrayTrie<HttpVersion>();
        for (HttpVersion httpVersion : HttpVersion.values()) {
            CACHE.put(httpVersion.toString(), httpVersion);
        }
    }
}

