/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.http;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.DuplexConnectionPool;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpDestination;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.Origin;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.http.HttpDestinationOverHTTP;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.Connection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.ProcessorUtils;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Promise;
import java.io.IOException;
import java.util.Map;

public class HttpClientTransportOverHTTP
extends AbstractConnectorHttpClientTransport {
    private int headerCacheSize = 1024;

    public HttpClientTransportOverHTTP() {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int n2) {
        super(n2);
        this.setConnectionPoolFactory(httpDestination -> new DuplexConnectionPool(httpDestination, this.getHttpClient().getMaxConnectionsPerDestination(), (Callback)httpDestination));
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP(this.getHttpClient(), origin);
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> map) throws IOException {
        HttpDestination httpDestination = (HttpDestination)map.get("http.destination");
        Promise promise = (Promise)map.get("http.connection.promise");
        HttpConnectionOverHTTP httpConnectionOverHTTP = this.newHttpConnection(endPoint, httpDestination, promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", httpConnectionOverHTTP);
        }
        return this.customize(httpConnectionOverHTTP, map);
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination httpDestination, Promise<com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Connection> promise) {
        return new HttpConnectionOverHTTP(endPoint, httpDestination, promise);
    }

    public int getHeaderCacheSize() {
        return this.headerCacheSize;
    }
}

