/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.ProtocolHandler;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.Dumpable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProtocolHandlers
implements Dumpable {
    private final Map<String, ProtocolHandler> handlers = new LinkedHashMap<String, ProtocolHandler>();

    protected ProtocolHandlers() {
    }

    public ProtocolHandler put(ProtocolHandler protocolHandler) {
        return this.handlers.put(protocolHandler.getName(), protocolHandler);
    }

    public void clear() {
        this.handlers.clear();
    }

    public ProtocolHandler find(Request request, Response response) {
        for (ProtocolHandler protocolHandler : this.handlers.values()) {
            if (!protocolHandler.accept(request, response)) continue;
            return protocolHandler;
        }
        return null;
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        Dumpable.dumpObjects(appendable, string, this, this.handlers);
    }
}

