/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.ContentDecoder;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpChannel;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpConversation;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpDestination;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpExchange;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpResponse;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.ProtocolHandler;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.ResponseNotifier;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Result;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.MathUtils;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.Destroyable;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongConsumer;
import java.util.function.LongUnaryOperator;

public abstract class HttpReceiver {
    protected static final Logger LOG = Log.getLogger(HttpReceiver.class);
    private final AtomicReference<ResponseState> responseState = new AtomicReference<ResponseState>(ResponseState.IDLE);
    private final HttpChannel channel;
    private ContentListeners contentListeners;
    private Decoder decoder;
    private Throwable failure;
    private long demand;
    private boolean stalled;

    protected HttpReceiver(HttpChannel httpChannel) {
        this.channel = httpChannel;
    }

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void demand(long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Invalid demand " + l2);
        }
        boolean bl2 = false;
        HttpReceiver httpReceiver = this;
        synchronized (httpReceiver) {
            this.demand = MathUtils.cappedAdd(this.demand, l2);
            if (this.stalled) {
                this.stalled = false;
                bl2 = true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response demand={}/{}, resume={}", l2, this.demand, bl2);
            }
        }
        if (bl2) {
            if (this.decoder != null) {
                this.decoder.resume();
            } else {
                this.receive();
            }
        }
    }

    protected long demand() {
        return this.demand(LongUnaryOperator.identity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long demand(LongUnaryOperator longUnaryOperator) {
        HttpReceiver httpReceiver = this;
        synchronized (httpReceiver) {
            this.demand = longUnaryOperator.applyAsLong(this.demand);
            return this.demand;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasDemandOrStall() {
        HttpReceiver httpReceiver = this;
        synchronized (httpReceiver) {
            this.stalled = this.demand <= 0L;
            return !this.stalled;
        }
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    protected HttpDestination getHttpDestination() {
        return this.channel.getHttpDestination();
    }

    public boolean isFailed() {
        return this.responseState.get() == ResponseState.FAILURE;
    }

    protected void receive() {
    }

    protected boolean responseBegin(HttpExchange httpExchange) {
        if (!this.updateResponseState(ResponseState.IDLE, ResponseState.TRANSIENT)) {
            return false;
        }
        HttpConversation httpConversation = httpExchange.getConversation();
        HttpResponse httpResponse = httpExchange.getResponse();
        HttpDestination httpDestination = this.getHttpDestination();
        HttpClient httpClient = httpDestination.getHttpClient();
        ProtocolHandler protocolHandler = httpClient.findProtocolHandler(httpExchange.getRequest(), httpResponse);
        Response.Listener listener = null;
        if (protocolHandler != null) {
            listener = protocolHandler.getResponseListener();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response {} found protocol handler {}", httpResponse, protocolHandler);
            }
        }
        httpExchange.getConversation().updateResponseListeners(listener);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response begin {}", httpResponse);
        }
        ResponseNotifier responseNotifier = httpDestination.getResponseNotifier();
        responseNotifier.notifyBegin(httpConversation.getResponseListeners(), (Response)httpResponse);
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.BEGIN)) {
            return true;
        }
        this.dispose();
        this.terminateResponse(httpExchange);
        return false;
    }

    protected boolean responseHeader(HttpExchange httpExchange, HttpField httpField) {
        if (!this.updateResponseState(ResponseState.BEGIN, ResponseState.HEADER, ResponseState.TRANSIENT)) {
            return false;
        }
        HttpResponse httpResponse = httpExchange.getResponse();
        ResponseNotifier responseNotifier = this.getHttpDestination().getResponseNotifier();
        boolean bl2 = responseNotifier.notifyHeader(httpExchange.getConversation().getResponseListeners(), (Response)httpResponse, httpField);
        if (bl2) {
            httpResponse.getHeaders().add(httpField);
            HttpHeader httpHeader = httpField.getHeader();
            if (httpHeader != null) {
                switch (httpHeader) {
                    case SET_COOKIE: 
                    case SET_COOKIE2: {
                        URI uRI = httpExchange.getRequest().getURI();
                        if (uRI == null) break;
                        this.storeCookie(uRI, httpField);
                        break;
                    }
                }
            }
        }
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.HEADER)) {
            return true;
        }
        this.dispose();
        this.terminateResponse(httpExchange);
        return false;
    }

    protected void storeCookie(URI uRI, HttpField httpField) {
        block3: {
            try {
                String string = httpField.getValue();
                if (string != null) {
                    HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(1);
                    hashMap.put(httpField.getHeader().asString(), Collections.singletonList(string));
                    this.getHttpDestination().getHttpClient().getCookieManager().put(uRI, hashMap);
                }
            }
            catch (IOException iOException) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug(iOException);
            }
        }
    }

    protected boolean responseHeaders(HttpExchange httpExchange) {
        List<String> list;
        if (!this.updateResponseState(ResponseState.BEGIN, ResponseState.HEADER, ResponseState.TRANSIENT)) {
            return false;
        }
        HttpResponse httpResponse = httpExchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response headers {}{}{}", httpResponse, System.lineSeparator(), httpResponse.getHeaders().toString().trim());
        }
        ResponseNotifier responseNotifier = this.getHttpDestination().getResponseNotifier();
        List<Response.ResponseListener> list2 = httpExchange.getConversation().getResponseListeners();
        responseNotifier.notifyHeaders(list2, (Response)httpResponse);
        this.contentListeners = new ContentListeners(list2);
        this.contentListeners.notifyBeforeContent(httpResponse);
        if (!this.contentListeners.isEmpty() && (list = httpResponse.getHeaders().getCSV(HttpHeader.CONTENT_ENCODING.asString(), false)) != null && !list.isEmpty()) {
            block0: for (ContentDecoder.Factory factory : this.getHttpDestination().getHttpClient().getContentDecoderFactories()) {
                for (String string : list) {
                    if (!factory.getEncoding().equalsIgnoreCase(string)) continue;
                    this.decoder = new Decoder(httpExchange, factory.newContentDecoder());
                    continue block0;
                }
            }
        }
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.HEADERS)) {
            boolean bl2 = this.hasDemandOrStall();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response headers hasDemand={} {}", bl2, httpResponse);
            }
            return bl2;
        }
        this.dispose();
        this.terminateResponse(httpExchange);
        return false;
    }

    protected boolean responseContent(HttpExchange httpExchange, ByteBuffer byteBuffer, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response content {}{}{}", httpExchange.getResponse(), System.lineSeparator(), BufferUtil.toDetailString(byteBuffer));
        }
        if (this.demand() <= 0L) {
            callback.failed(new IllegalStateException("No demand for response content"));
            return false;
        }
        if (this.decoder == null) {
            return this.plainResponseContent(httpExchange, byteBuffer, callback);
        }
        return this.decodeResponseContent(byteBuffer, callback);
    }

    private boolean plainResponseContent(HttpExchange httpExchange, ByteBuffer byteBuffer, Callback callback) {
        if (!this.updateResponseState(ResponseState.HEADERS, ResponseState.CONTENT, ResponseState.TRANSIENT)) {
            callback.failed(new IllegalStateException("Invalid response state " + this.responseState));
            return false;
        }
        HttpResponse httpResponse = httpExchange.getResponse();
        if (this.contentListeners.isEmpty()) {
            callback.succeeded();
        } else {
            this.contentListeners.notifyContent(httpResponse, byteBuffer, callback);
        }
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.CONTENT)) {
            boolean bl2 = this.hasDemandOrStall();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response content {}, hasDemand={}", httpResponse, bl2);
            }
            return bl2;
        }
        this.dispose();
        this.terminateResponse(httpExchange);
        return false;
    }

    private boolean decodeResponseContent(ByteBuffer byteBuffer, Callback callback) {
        return this.decoder.decode(byteBuffer, callback);
    }

    protected boolean responseSuccess(HttpExchange httpExchange) {
        if (!httpExchange.responseComplete(null)) {
            return false;
        }
        this.responseState.set(ResponseState.IDLE);
        this.reset();
        HttpResponse httpResponse = httpExchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response success {}", httpResponse);
        }
        List<Response.ResponseListener> list = httpExchange.getConversation().getResponseListeners();
        ResponseNotifier responseNotifier = this.getHttpDestination().getResponseNotifier();
        responseNotifier.notifySuccess(list, (Response)httpResponse);
        if (httpExchange.getResponse().getStatus() == 100) {
            return true;
        }
        this.terminateResponse(httpExchange);
        return true;
    }

    protected boolean responseFailure(Throwable throwable) {
        HttpExchange httpExchange = this.getHttpExchange();
        if (httpExchange == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response failure " + httpExchange.getResponse(), throwable);
        }
        if (httpExchange.responseComplete(throwable)) {
            return this.abort(httpExchange, throwable);
        }
        return false;
    }

    private void terminateResponse(HttpExchange httpExchange) {
        Result result = httpExchange.terminateResponse();
        this.terminateResponse(httpExchange, result);
    }

    private void terminateResponse(HttpExchange httpExchange, Result result) {
        HttpResponse httpResponse = httpExchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response complete {}", httpResponse);
        }
        if (result != null) {
            result = this.channel.exchangeTerminating(httpExchange, result);
            boolean bl2 = this.getHttpDestination().getHttpClient().isStrictEventOrdering();
            if (!bl2) {
                this.channel.exchangeTerminated(httpExchange, result);
            }
            List<Response.ResponseListener> list = httpExchange.getConversation().getResponseListeners();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request/Response {}: {}, notifying {}", this.failure == null ? "succeeded" : "failed", result, list);
            }
            ResponseNotifier responseNotifier = this.getHttpDestination().getResponseNotifier();
            responseNotifier.notifyComplete(list, result);
            if (bl2) {
                this.channel.exchangeTerminated(httpExchange, result);
            }
        }
    }

    protected void reset() {
        this.cleanup();
    }

    protected void dispose() {
        assert (this.responseState.get() != ResponseState.TRANSIENT);
        this.cleanup();
    }

    private void cleanup() {
        this.contentListeners = null;
        if (this.decoder != null) {
            this.decoder.destroy();
        }
        this.decoder = null;
        this.demand = 0L;
        this.stalled = false;
    }

    public boolean abort(HttpExchange httpExchange, Throwable throwable) {
        Object object;
        do {
            if ((object = this.responseState.get()) != ResponseState.FAILURE) continue;
            return false;
        } while (!this.updateResponseState((ResponseState)((Object)object), ResponseState.FAILURE));
        boolean bl2 = object != ResponseState.TRANSIENT;
        this.failure = throwable;
        if (bl2) {
            this.dispose();
        }
        object = httpExchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response abort {} {} on {}: {}", object, httpExchange, this.getHttpChannel(), throwable);
        }
        List<Response.ResponseListener> list = httpExchange.getConversation().getResponseListeners();
        ResponseNotifier responseNotifier = this.getHttpDestination().getResponseNotifier();
        responseNotifier.notifyFailure(list, (Response)object, throwable);
        if (bl2) {
            this.terminateResponse(httpExchange);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Concurrent failure: response termination skipped, performed by helpers", new Object[0]);
        }
        return false;
    }

    private boolean updateResponseState(ResponseState responseState, ResponseState responseState2, ResponseState responseState3) {
        ResponseState responseState4;
        while ((responseState4 = this.responseState.get()) == responseState || responseState4 == responseState2) {
            if (!this.updateResponseState(responseState4, responseState3)) continue;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("State update failed: [{},{}] -> {}: {}", new Object[]{responseState, responseState2, responseState3, responseState4});
        }
        return false;
    }

    private boolean updateResponseState(ResponseState responseState, ResponseState responseState2) {
        ResponseState responseState3;
        while ((responseState3 = this.responseState.get()) == responseState) {
            if (!this.responseState.compareAndSet(responseState3, responseState2)) continue;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("State update failed: {} -> {}: {}", new Object[]{responseState, responseState2, responseState3});
        }
        return false;
    }

    public String toString() {
        return String.format("%s@%x(rsp=%s,failure=%s)", this.getClass().getSimpleName(), this.hashCode(), this.responseState, this.failure);
    }

    private static enum DecodeResult {
        DECODE,
        NEED_INPUT,
        ABORT;

    }

    private class Decoder
    implements Destroyable {
        private final HttpExchange exchange;
        private final ContentDecoder decoder;
        private ByteBuffer encoded;
        private Callback callback;

        private Decoder(HttpExchange httpExchange, ContentDecoder contentDecoder) {
            this.exchange = httpExchange;
            this.decoder = Objects.requireNonNull(contentDecoder);
        }

        private boolean decode(ByteBuffer byteBuffer, Callback callback) {
            boolean bl2;
            this.encoded = byteBuffer;
            this.callback = callback;
            HttpResponse httpResponse = this.exchange.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response content decoding {} with {}{}{}", httpResponse, this.decoder, System.lineSeparator(), BufferUtil.toDetailString(byteBuffer));
            }
            if (!(bl2 = this.decode())) {
                return false;
            }
            boolean bl3 = HttpReceiver.this.hasDemandOrStall();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response content decoded, hasDemand={} {}", bl3, httpResponse);
            }
            return bl3;
        }

        private boolean decode() {
            block4: {
                boolean bl2;
                do {
                    if (!HttpReceiver.this.updateResponseState(ResponseState.HEADERS, ResponseState.CONTENT, ResponseState.TRANSIENT)) {
                        this.callback.failed(new IllegalStateException("Invalid response state " + HttpReceiver.this.responseState));
                        return false;
                    }
                    DecodeResult decodeResult = this.decodeChunk();
                    if (!HttpReceiver.this.updateResponseState(ResponseState.TRANSIENT, ResponseState.CONTENT)) break block4;
                    if (decodeResult == DecodeResult.NEED_INPUT) {
                        return true;
                    }
                    if (decodeResult == DecodeResult.ABORT) {
                        return false;
                    }
                    bl2 = HttpReceiver.this.hasDemandOrStall();
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Response content decoded chunk, hasDemand={} {}", bl2, this.exchange.getResponse());
                } while (bl2);
                return false;
            }
            HttpReceiver.this.dispose();
            HttpReceiver.this.terminateResponse(this.exchange);
            return false;
        }

        private DecodeResult decodeChunk() {
            try {
                ByteBuffer byteBuffer;
                while (!(byteBuffer = this.decoder.decode(this.encoded)).hasRemaining()) {
                    if (this.encoded.hasRemaining()) continue;
                    this.callback.succeeded();
                    this.encoded = null;
                    this.callback = null;
                    return DecodeResult.NEED_INPUT;
                }
                ByteBuffer byteBuffer2 = byteBuffer;
                HttpResponse httpResponse = this.exchange.getResponse();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response content decoded chunk {}{}{}", httpResponse, System.lineSeparator(), BufferUtil.toDetailString(byteBuffer2));
                }
                HttpReceiver.this.contentListeners.notifyContent(httpResponse, byteBuffer2, Callback.from(() -> this.decoder.release(byteBuffer2), this.callback::failed));
                return DecodeResult.DECODE;
            }
            catch (Throwable throwable) {
                this.callback.failed(throwable);
                return DecodeResult.ABORT;
            }
        }

        private void resume() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response content resume decoding {} with {}", this.exchange.getResponse(), this.decoder);
            }
            if (this.callback == null) {
                HttpReceiver.this.receive();
                return;
            }
            boolean bl2 = this.decode();
            if (bl2) {
                HttpReceiver.this.receive();
            }
        }

        @Override
        public void destroy() {
            if (this.decoder instanceof Destroyable) {
                ((Destroyable)((Object)this.decoder)).destroy();
            }
        }
    }

    private class ContentListeners {
        private final Map<Object, Long> demands = new ConcurrentHashMap<Object, Long>();
        private final LongConsumer demand = HttpReceiver.this::demand;
        private final List<Response.DemandedContentListener> listeners;

        private ContentListeners(List<Response.ResponseListener> list) {
            this.listeners = new ArrayList<Response.DemandedContentListener>(list.size());
            list.stream().filter(Response.DemandedContentListener.class::isInstance).map(Response.DemandedContentListener.class::cast).forEach(this.listeners::add);
        }

        private boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        private void notifyBeforeContent(HttpResponse httpResponse) {
            if (this.isEmpty()) {
                this.demand.accept(1L);
            } else {
                ResponseNotifier responseNotifier = HttpReceiver.this.getHttpDestination().getResponseNotifier();
                responseNotifier.notifyBeforeContent(httpResponse, this::demand, this.listeners);
            }
        }

        private void notifyContent(HttpResponse httpResponse, ByteBuffer byteBuffer, Callback callback) {
            HttpReceiver.this.demand(l2 -> l2 - 1L);
            ResponseNotifier responseNotifier = HttpReceiver.this.getHttpDestination().getResponseNotifier();
            responseNotifier.notifyContent(httpResponse, this::demand, byteBuffer, callback, this.listeners);
        }

        private void demand(Object object, long l2) {
            if (this.listeners.size() > 1) {
                this.accept(object, l2);
            } else {
                this.demand.accept(l2);
            }
        }

        private void accept(Object object, long l2) {
            this.demands.merge(object, l2, MathUtils::cappedAdd);
            if (this.demands.size() == this.listeners.size()) {
                long l3 = Long.MAX_VALUE;
                for (Long object2 : this.demands.values()) {
                    if (object2 >= l3) continue;
                    l3 = object2;
                }
                if (l3 > 0L) {
                    Iterator<Object> iterator = this.demands.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        long l4 = (Long)entry.getValue() - l3;
                        if (l4 == 0L) {
                            iterator.remove();
                            continue;
                        }
                        entry.setValue(l4);
                    }
                    this.demand.accept(l3);
                }
            }
        }
    }

    private static enum ResponseState {
        TRANSIENT,
        IDLE,
        BEGIN,
        HEADER,
        HEADERS,
        CONTENT,
        FAILURE;

    }
}

