/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class LocalTimeDeserializer
extends JSR310DateTimeDeserializerBase<LocalTime> {
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_LOCAL_TIME;
    public static final LocalTimeDeserializer INSTANCE = new LocalTimeDeserializer();

    protected LocalTimeDeserializer() {
        this(DEFAULT_FORMATTER);
    }

    public LocalTimeDeserializer(DateTimeFormatter dateTimeFormatter) {
        super(LocalTime.class, dateTimeFormatter);
    }

    protected LocalTimeDeserializer(LocalTimeDeserializer localTimeDeserializer, Boolean bl2) {
        super(localTimeDeserializer, bl2);
    }

    protected LocalTimeDeserializer withDateFormat(DateTimeFormatter dateTimeFormatter) {
        return new LocalTimeDeserializer(dateTimeFormatter);
    }

    protected LocalTimeDeserializer withLeniency(Boolean bl2) {
        return new LocalTimeDeserializer(this, bl2);
    }

    protected LocalTimeDeserializer withShape(JsonFormat.Shape shape) {
        return this;
    }

    @Override
    public LocalTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            return this._fromString(jsonParser, deserializationContext, deserializationContext.extractScalarFromObject(jsonParser, this, this.handledType()));
        }
        if (jsonParser.isExpectedStartArrayToken()) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                return null;
            }
            if (deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS) && (jsonToken == JsonToken.VALUE_STRING || jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT)) {
                LocalTime localTime = this.deserialize(jsonParser, deserializationContext);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return localTime;
            }
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                LocalTime localTime;
                int n2 = jsonParser.getIntValue();
                jsonParser.nextToken();
                int n3 = jsonParser.getIntValue();
                jsonToken = jsonParser.nextToken();
                if (jsonToken == JsonToken.END_ARRAY) {
                    localTime = LocalTime.of(n2, n3);
                } else {
                    int n4 = jsonParser.getIntValue();
                    jsonToken = jsonParser.nextToken();
                    if (jsonToken == JsonToken.END_ARRAY) {
                        localTime = LocalTime.of(n2, n3, n4);
                    } else {
                        int n5 = jsonParser.getIntValue();
                        if (n5 < 1000 && !deserializationContext.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                            n5 *= 1000000;
                        }
                        if ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                            throw deserializationContext.wrongTokenException(jsonParser, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                        }
                        localTime = LocalTime.of(n2, n3, n4, n5);
                    }
                }
                return localTime;
            }
            deserializationContext.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", new Object[]{jsonToken});
        }
        if (jsonParser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (LocalTime)jsonParser.getEmbeddedObject();
        }
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            this._throwNoNumericTimestampNeedTimeZone(jsonParser, deserializationContext);
        }
        return (LocalTime)this._handleUnexpectedToken(deserializationContext, jsonParser, "Expected array or string.", new Object[0]);
    }

    protected LocalTime _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return (LocalTime)this._fromEmptyString(jsonParser, deserializationContext, string2);
        }
        DateTimeFormatter dateTimeFormatter = this._formatter;
        try {
            if (dateTimeFormatter == DEFAULT_FORMATTER && string2.contains("T")) {
                return LocalTime.parse(string2, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            }
            return LocalTime.parse(string2, dateTimeFormatter);
        }
        catch (DateTimeException dateTimeException) {
            return (LocalTime)this._handleDateTimeException(deserializationContext, dateTimeException, string2);
        }
    }
}

