/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.Annotations;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AnnotationCollector {
    protected static final Annotations NO_ANNOTATIONS = new NoAnnotations();
    protected final Object _data;

    protected AnnotationCollector(Object object) {
        this._data = object;
    }

    public static Annotations emptyAnnotations() {
        return NO_ANNOTATIONS;
    }

    public static AnnotationCollector emptyCollector() {
        return EmptyCollector.instance;
    }

    public abstract Annotations asAnnotations();

    public abstract AnnotationMap asAnnotationMap();

    public abstract boolean isPresent(Annotation var1);

    public abstract AnnotationCollector addOrOverride(Annotation var1);

    public static class TwoAnnotations
    implements Annotations,
    Serializable {
        private final Class<?> _type1;
        private final Class<?> _type2;
        private final Annotation _value1;
        private final Annotation _value2;

        public TwoAnnotations(Class<?> clazz, Annotation annotation, Class<?> clazz2, Annotation annotation2) {
            this._type1 = clazz;
            this._value1 = annotation;
            this._type2 = clazz2;
            this._value2 = annotation2;
        }

        @Override
        public <A extends Annotation> A get(Class<A> clazz) {
            if (this._type1 == clazz) {
                return (A)this._value1;
            }
            if (this._type2 == clazz) {
                return (A)this._value2;
            }
            return null;
        }

        @Override
        public boolean has(Class<?> clazz) {
            return this._type1 == clazz || this._type2 == clazz;
        }

        @Override
        public boolean hasOneOf(Class<? extends Annotation>[] classArray) {
            for (Class<? extends Annotation> clazz : classArray) {
                if (clazz != this._type1 && clazz != this._type2) continue;
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return 2;
        }
    }

    public static class OneAnnotation
    implements Annotations,
    Serializable {
        private final Class<?> _type;
        private final Annotation _value;

        public OneAnnotation(Class<?> clazz, Annotation annotation) {
            this._type = clazz;
            this._value = annotation;
        }

        @Override
        public <A extends Annotation> A get(Class<A> clazz) {
            if (this._type == clazz) {
                return (A)this._value;
            }
            return null;
        }

        @Override
        public boolean has(Class<?> clazz) {
            return this._type == clazz;
        }

        @Override
        public boolean hasOneOf(Class<? extends Annotation>[] classArray) {
            for (Class<? extends Annotation> clazz : classArray) {
                if (clazz != this._type) continue;
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return 1;
        }
    }

    public static class NoAnnotations
    implements Annotations,
    Serializable {
        NoAnnotations() {
        }

        @Override
        public <A extends Annotation> A get(Class<A> clazz) {
            return null;
        }

        @Override
        public boolean has(Class<?> clazz) {
            return false;
        }

        @Override
        public boolean hasOneOf(Class<? extends Annotation>[] classArray) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    static class NCollector
    extends AnnotationCollector {
        protected final HashMap<Class<?>, Annotation> _annotations = new HashMap();

        public NCollector(Object object, Class<?> clazz, Annotation annotation, Class<?> clazz2, Annotation annotation2) {
            super(object);
            this._annotations.put(clazz, annotation);
            this._annotations.put(clazz2, annotation2);
        }

        @Override
        public Annotations asAnnotations() {
            if (this._annotations.size() == 2) {
                Iterator<Map.Entry<Class<?>, Annotation>> iterator = this._annotations.entrySet().iterator();
                Map.Entry<Class<?>, Annotation> entry = iterator.next();
                Map.Entry<Class<?>, Annotation> entry2 = iterator.next();
                return new TwoAnnotations(entry.getKey(), entry.getValue(), entry2.getKey(), entry2.getValue());
            }
            return new AnnotationMap(this._annotations);
        }

        @Override
        public AnnotationMap asAnnotationMap() {
            AnnotationMap annotationMap = new AnnotationMap();
            for (Annotation annotation : this._annotations.values()) {
                annotationMap.add(annotation);
            }
            return annotationMap;
        }

        @Override
        public boolean isPresent(Annotation annotation) {
            return this._annotations.containsKey(annotation.annotationType());
        }

        @Override
        public AnnotationCollector addOrOverride(Annotation annotation) {
            this._annotations.put(annotation.annotationType(), annotation);
            return this;
        }
    }

    static class OneCollector
    extends AnnotationCollector {
        private Class<?> _type;
        private Annotation _value;

        public OneCollector(Object object, Class<?> clazz, Annotation annotation) {
            super(object);
            this._type = clazz;
            this._value = annotation;
        }

        @Override
        public Annotations asAnnotations() {
            return new OneAnnotation(this._type, this._value);
        }

        @Override
        public AnnotationMap asAnnotationMap() {
            return AnnotationMap.of(this._type, this._value);
        }

        @Override
        public boolean isPresent(Annotation annotation) {
            return annotation.annotationType() == this._type;
        }

        @Override
        public AnnotationCollector addOrOverride(Annotation annotation) {
            Class<? extends Annotation> clazz = annotation.annotationType();
            if (this._type == clazz) {
                this._value = annotation;
                return this;
            }
            return new NCollector(this._data, this._type, this._value, clazz, annotation);
        }
    }

    static class EmptyCollector
    extends AnnotationCollector {
        public static final EmptyCollector instance = new EmptyCollector(null);

        EmptyCollector(Object object) {
            super(object);
        }

        @Override
        public Annotations asAnnotations() {
            return NO_ANNOTATIONS;
        }

        @Override
        public AnnotationMap asAnnotationMap() {
            return new AnnotationMap();
        }

        @Override
        public boolean isPresent(Annotation annotation) {
            return false;
        }

        @Override
        public AnnotationCollector addOrOverride(Annotation annotation) {
            return new OneCollector(this._data, annotation.annotationType(), annotation);
        }
    }
}

