/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import java.io.IOException;
import java.io.InputStream;

public final class MergedStream
extends InputStream {
    private final IOContext _ctxt;
    private final InputStream _in;
    private byte[] _b;
    private int _ptr;
    private final int _end;

    public MergedStream(IOContext iOContext, InputStream inputStream, byte[] byArray, int n2, int n3) {
        this._ctxt = iOContext;
        this._in = inputStream;
        this._b = byArray;
        this._ptr = n2;
        this._end = n3;
    }

    @Override
    public int available() throws IOException {
        if (this._b != null) {
            return this._end - this._ptr;
        }
        return this._in.available();
    }

    @Override
    public void close() throws IOException {
        this._free();
        this._in.close();
    }

    @Override
    public synchronized void mark(int n2) {
        if (this._b == null) {
            this._in.mark(n2);
        }
    }

    @Override
    public boolean markSupported() {
        return this._b == null && this._in.markSupported();
    }

    @Override
    public int read() throws IOException {
        if (this._b != null) {
            int n2 = this._b[this._ptr++] & 0xFF;
            if (this._ptr >= this._end) {
                this._free();
            }
            return n2;
        }
        return this._in.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this._b != null) {
            int n4 = this._end - this._ptr;
            if (n3 > n4) {
                n3 = n4;
            }
            System.arraycopy(this._b, this._ptr, byArray, n2, n3);
            this._ptr += n3;
            if (this._ptr >= this._end) {
                this._free();
            }
            return n3;
        }
        return this._in.read(byArray, n2, n3);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this._b == null) {
            this._in.reset();
        }
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3 = 0L;
        if (this._b != null) {
            int n2 = this._end - this._ptr;
            if ((long)n2 > l2) {
                this._ptr += (int)l2;
                return l2;
            }
            this._free();
            l3 += (long)n2;
            l2 -= (long)n2;
        }
        if (l2 > 0L) {
            l3 += this._in.skip(l2);
        }
        return l3;
    }

    private void _free() {
        byte[] byArray = this._b;
        if (byArray != null) {
            this._b = null;
            if (this._ctxt != null) {
                this._ctxt.releaseReadIOBuffer(byArray);
            }
        }
    }
}

