/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.client;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.resource.Resource;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.xml.XmlConfiguration;
import java.net.URL;

class XmlBasedHttpClientProvider {
    public static final Logger LOG = Log.getLogger(XmlBasedHttpClientProvider.class);

    XmlBasedHttpClientProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient get(WebSocketContainerScope webSocketContainerScope) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            return null;
        }
        URL uRL = classLoader.getResource("jetty-websocket-httpclient.xml");
        if (uRL == null) {
            return null;
        }
        try {
            Thread.currentThread().setContextClassLoader(HttpClient.class.getClassLoader());
            HttpClient httpClient = XmlBasedHttpClientProvider.newHttpClient(uRL);
            return httpClient;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private static HttpClient newHttpClient(URL uRL) {
        try {
            XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.newResource(uRL));
            return (HttpClient)xmlConfiguration.configure();
        }
        catch (Throwable throwable) {
            LOG.warn("Failure to load HttpClient from XML {}", uRL, throwable);
            return null;
        }
    }
}

