/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.http;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpContent;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpExchange;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpRequest;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpRequestException;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpSender;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.ContentProvider;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.BadMessageException;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpGenerator;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpURI;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.MetaData;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.IteratingCallback;
import java.nio.ByteBuffer;

public class HttpSenderOverHTTP
extends HttpSender {
    private final HttpGenerator generator = new HttpGenerator();
    private final HttpClient httpClient;
    private boolean shutdown;

    public HttpSenderOverHTTP(HttpChannelOverHTTP httpChannelOverHTTP) {
        super(httpChannelOverHTTP);
        this.httpClient = httpChannelOverHTTP.getHttpDestination().getHttpClient();
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    @Override
    protected void sendHeaders(HttpExchange httpExchange, HttpContent httpContent, Callback callback) {
        try {
            new HeadersCallback(httpExchange, httpContent, callback).iterate();
        }
        catch (Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(throwable);
            }
            callback.failed(throwable);
        }
    }

    @Override
    protected void sendContent(HttpExchange httpExchange, HttpContent httpContent, Callback callback) {
        try {
            ByteBufferPool byteBufferPool = this.httpClient.getByteBufferPool();
            ByteBuffer byteBuffer = null;
            block10: while (true) {
                ByteBuffer byteBuffer2 = httpContent.getByteBuffer();
                boolean bl2 = httpContent.isLast();
                HttpGenerator.Result result = this.generator.generateRequest(null, null, byteBuffer, byteBuffer2, bl2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Generated content ({} bytes) - {}/{}", new Object[]{byteBuffer2 == null ? -1 : byteBuffer2.remaining(), result, this.generator});
                }
                switch (result) {
                    case NEED_CHUNK: {
                        byteBuffer = byteBufferPool.acquire(12, false);
                        break;
                    }
                    case NEED_CHUNK_TRAILER: {
                        byteBuffer = byteBufferPool.acquire(this.httpClient.getRequestBufferSize(), false);
                        break;
                    }
                    case FLUSH: {
                        EndPoint endPoint = this.getHttpChannel().getHttpConnection().getEndPoint();
                        if (byteBuffer != null) {
                            endPoint.write(new ByteBufferRecyclerCallback(callback, byteBufferPool, new ByteBuffer[]{byteBuffer}), byteBuffer, byteBuffer2);
                        } else {
                            endPoint.write(callback, byteBuffer2);
                        }
                        return;
                    }
                    case SHUTDOWN_OUT: {
                        this.shutdownOutput();
                        break;
                    }
                    case CONTINUE: {
                        if (bl2) continue block10;
                        callback.succeeded();
                        return;
                    }
                    case DONE: {
                        callback.succeeded();
                        return;
                    }
                    default: {
                        throw new IllegalStateException(result.toString());
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(throwable);
            }
            callback.failed(throwable);
            return;
        }
    }

    @Override
    protected void reset() {
        this.generator.reset();
        super.reset();
    }

    @Override
    protected void dispose() {
        this.generator.abort();
        super.dispose();
        this.shutdownOutput();
    }

    private void shutdownOutput() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request shutdown output {}", this.getHttpExchange().getRequest());
        }
        this.shutdown = true;
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", super.toString(), this.generator);
    }

    private class ByteBufferRecyclerCallback
    extends Callback.Nested {
        private final ByteBufferPool pool;
        private final ByteBuffer[] buffers;

        private ByteBufferRecyclerCallback(Callback callback, ByteBufferPool byteBufferPool, ByteBuffer ... byteBufferArray) {
            super(callback);
            this.pool = byteBufferPool;
            this.buffers = byteBufferArray;
        }

        @Override
        public void succeeded() {
            for (ByteBuffer byteBuffer : this.buffers) {
                assert (!byteBuffer.hasRemaining());
                this.pool.release(byteBuffer);
            }
            super.succeeded();
        }

        @Override
        public void failed(Throwable throwable) {
            for (ByteBuffer byteBuffer : this.buffers) {
                this.pool.release(byteBuffer);
            }
            super.failed(throwable);
        }
    }

    private class HeadersCallback
    extends IteratingCallback {
        private final HttpExchange exchange;
        private final Callback callback;
        private final MetaData.Request metaData;
        private ByteBuffer headerBuffer;
        private ByteBuffer chunkBuffer;
        private ByteBuffer contentBuffer;
        private boolean lastContent;
        private boolean generated;

        public HeadersCallback(HttpExchange httpExchange, HttpContent httpContent, Callback callback) {
            super(false);
            this.exchange = httpExchange;
            this.callback = callback;
            HttpRequest httpRequest = httpExchange.getRequest();
            ContentProvider contentProvider = httpRequest.getContent();
            long l2 = contentProvider == null ? -1L : contentProvider.getLength();
            String string = httpRequest.getPath();
            String string2 = httpRequest.getQuery();
            if (string2 != null) {
                string = string + "?" + string2;
            }
            this.metaData = new MetaData.Request(httpRequest.getMethod(), new HttpURI(string), httpRequest.getVersion(), httpRequest.getHeaders(), l2);
            this.metaData.setTrailerSupplier(httpRequest.getTrailers());
            if (!HttpSenderOverHTTP.this.expects100Continue(httpRequest)) {
                httpContent.advance();
                this.contentBuffer = httpContent.getByteBuffer();
                this.lastContent = httpContent.isLast();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected IteratingCallback.Action process() throws Exception {
            HttpGenerator.Result result;
            block10: while (true) {
                result = HttpSenderOverHTTP.this.generator.generateRequest(this.metaData, this.headerBuffer, this.chunkBuffer, this.contentBuffer, this.lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Generated headers ({} bytes), chunk ({} bytes), content ({} bytes) - {}/{}", new Object[]{this.headerBuffer == null ? -1 : this.headerBuffer.remaining(), this.chunkBuffer == null ? -1 : this.chunkBuffer.remaining(), this.contentBuffer == null ? -1 : this.contentBuffer.remaining(), result, HttpSenderOverHTTP.this.generator});
                }
                switch (result) {
                    case NEED_HEADER: {
                        this.headerBuffer = HttpSenderOverHTTP.this.httpClient.getByteBufferPool().acquire(HttpSenderOverHTTP.this.httpClient.getRequestBufferSize(), false);
                        continue block10;
                    }
                    case HEADER_OVERFLOW: {
                        HttpSenderOverHTTP.this.httpClient.getByteBufferPool().release(this.headerBuffer);
                        this.headerBuffer = null;
                        throw new BadMessageException(500, "Request header too large");
                    }
                    case NEED_CHUNK: {
                        this.chunkBuffer = HttpSenderOverHTTP.this.httpClient.getByteBufferPool().acquire(12, false);
                        continue block10;
                    }
                    case NEED_CHUNK_TRAILER: {
                        this.chunkBuffer = HttpSenderOverHTTP.this.httpClient.getByteBufferPool().acquire(HttpSenderOverHTTP.this.httpClient.getRequestBufferSize(), false);
                        continue block10;
                    }
                    case FLUSH: {
                        EndPoint endPoint = HttpSenderOverHTTP.this.getHttpChannel().getHttpConnection().getEndPoint();
                        if (this.headerBuffer == null) {
                            this.headerBuffer = BufferUtil.EMPTY_BUFFER;
                        }
                        if (this.chunkBuffer == null) {
                            this.chunkBuffer = BufferUtil.EMPTY_BUFFER;
                        }
                        if (this.contentBuffer == null) {
                            this.contentBuffer = BufferUtil.EMPTY_BUFFER;
                        }
                        long l2 = this.headerBuffer.remaining() + this.chunkBuffer.remaining() + this.contentBuffer.remaining();
                        HttpSenderOverHTTP.this.getHttpChannel().getHttpConnection().addBytesOut(l2);
                        endPoint.write(this, this.headerBuffer, this.chunkBuffer, this.contentBuffer);
                        this.generated = true;
                        return IteratingCallback.Action.SCHEDULED;
                    }
                    case SHUTDOWN_OUT: {
                        HttpSenderOverHTTP.this.shutdownOutput();
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    case CONTINUE: {
                        if (this.generated) return IteratingCallback.Action.SUCCEEDED;
                        continue block10;
                    }
                    case DONE: {
                        if (!this.generated) throw new HttpRequestException("Could not generate headers", this.exchange.getRequest());
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                }
                break;
            }
            throw new IllegalStateException(result.toString());
        }

        @Override
        public void succeeded() {
            this.release();
            super.succeeded();
        }

        @Override
        public void failed(Throwable throwable) {
            this.release();
            super.failed(throwable);
        }

        @Override
        protected void onCompleteSuccess() {
            super.onCompleteSuccess();
            this.callback.succeeded();
        }

        @Override
        protected void onCompleteFailure(Throwable throwable) {
            super.onCompleteFailure(throwable);
            this.callback.failed(throwable);
        }

        private void release() {
            ByteBufferPool byteBufferPool = HttpSenderOverHTTP.this.httpClient.getByteBufferPool();
            if (!BufferUtil.isTheEmptyBuffer(this.headerBuffer)) {
                byteBufferPool.release(this.headerBuffer);
            }
            this.headerBuffer = null;
            if (!BufferUtil.isTheEmptyBuffer(this.chunkBuffer)) {
                byteBufferPool.release(this.chunkBuffer);
            }
            this.chunkBuffer = null;
            this.contentBuffer = null;
        }
    }
}

