/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.ContentDecoder;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.ContinueProtocolHandler;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.GZIPContentDecoder;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpAuthenticationStore;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpClientTransport;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpConversation;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpDestination;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.HttpRequest;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.Origin;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.ProtocolHandler;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.ProtocolHandlers;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.ProxyAuthenticationProtocolHandler;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.ProxyConfiguration;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.RedirectProtocolHandler;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.WWWAuthenticationProtocolHandler;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.AuthenticationStore;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Connection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpCompliance;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpMethod;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpScheme;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ClientConnectionFactory;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.MappedByteBufferPool;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Jetty;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.ProcessorUtils;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.Promise;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.SocketAddressResolver;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.DumpableCollection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.ssl.SslContextFactory;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.QueuedThreadPool;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.Sweeper;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.ThreadPool;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class HttpClient
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(HttpClient.class);
    private final ConcurrentMap<Origin, HttpDestination> destinations = new ConcurrentHashMap<Origin, HttpDestination>();
    private final ProtocolHandlers handlers = new ProtocolHandlers();
    private final List<Request.Listener> requestListeners = new ArrayList<Request.Listener>();
    private final Set<ContentDecoder.Factory> decoderFactories = new ContentDecoderFactorySet();
    private final ProxyConfiguration proxyConfig = new ProxyConfiguration();
    private final HttpClientTransport transport;
    private final SslContextFactory sslContextFactory;
    private AuthenticationStore authenticationStore = new HttpAuthenticationStore();
    private CookieManager cookieManager;
    private CookieStore cookieStore;
    private Executor executor;
    private ByteBufferPool byteBufferPool;
    private Scheduler scheduler;
    private SocketAddressResolver resolver;
    private HttpField agentField = new HttpField(HttpHeader.USER_AGENT, "Jetty/" + Jetty.VERSION);
    private boolean followRedirects = true;
    private int maxConnectionsPerDestination = 64;
    private int maxRequestsQueuedPerDestination = 1024;
    private int requestBufferSize = 4096;
    private int responseBufferSize = 16384;
    private int maxRedirects = 8;
    private SocketAddress bindAddress;
    private long connectTimeout = 15000L;
    private long addressResolutionTimeout = 15000L;
    private long idleTimeout;
    private boolean tcpNoDelay = true;
    private boolean strictEventOrdering = false;
    private HttpField encodingField;
    private long destinationIdleTimeout;
    private boolean connectBlocking = false;
    private String name = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    private HttpCompliance httpCompliance = HttpCompliance.RFC7230;
    private String defaultRequestContentType = "application/octet-stream";
    private Sweeper destinationSweeper;

    public HttpClient() {
        this(new HttpClientTransportOverHTTP(), null);
    }

    public HttpClient(SslContextFactory sslContextFactory) {
        this(new HttpClientTransportOverHTTP(), sslContextFactory);
    }

    public HttpClient(HttpClientTransport httpClientTransport, SslContextFactory sslContextFactory) {
        this.transport = httpClientTransport;
        this.addBean(httpClientTransport);
        this.sslContextFactory = sslContextFactory;
        this.addBean(sslContextFactory);
        this.addBean(this.handlers);
        this.addBean(this.decoderFactories);
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        this.dumpObjects(appendable, string, new DumpableCollection("requestListeners", this.requestListeners));
    }

    public HttpClientTransport getTransport() {
        return this.transport;
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.executor == null) {
            QueuedThreadPool queuedThreadPool = new QueuedThreadPool();
            queuedThreadPool.setName(this.name);
            this.setExecutor(queuedThreadPool);
        }
        if (this.byteBufferPool == null) {
            this.setByteBufferPool(new MappedByteBufferPool(2048, this.executor instanceof ThreadPool.SizedThreadPool ? ((ThreadPool.SizedThreadPool)this.executor).getMaxThreads() / 2 : ProcessorUtils.availableProcessors() * 2));
        }
        if (this.scheduler == null) {
            this.setScheduler(new ScheduledExecutorScheduler(this.name + "-scheduler", false));
        }
        if (this.resolver == null) {
            this.setSocketAddressResolver(new SocketAddressResolver.Async(this.executor, this.scheduler, this.getAddressResolutionTimeout()));
        }
        this.handlers.put(new ContinueProtocolHandler());
        this.handlers.put(new RedirectProtocolHandler(this));
        this.handlers.put(new WWWAuthenticationProtocolHandler(this));
        this.handlers.put(new ProxyAuthenticationProtocolHandler(this));
        this.decoderFactories.add(new GZIPContentDecoder.Factory(this.byteBufferPool));
        this.cookieManager = this.newCookieManager();
        this.cookieStore = this.cookieManager.getCookieStore();
        this.transport.setHttpClient(this);
        super.doStart();
        if (this.getDestinationIdleTimeout() > 0L) {
            this.destinationSweeper = new Sweeper(this.scheduler, 1000L);
            this.destinationSweeper.start();
        }
    }

    private CookieManager newCookieManager() {
        return new CookieManager(this.getCookieStore(), CookiePolicy.ACCEPT_ALL);
    }

    @Override
    protected void doStop() throws Exception {
        if (this.destinationSweeper != null) {
            this.destinationSweeper.stop();
            this.destinationSweeper = null;
        }
        this.decoderFactories.clear();
        this.handlers.clear();
        for (HttpDestination httpDestination : this.destinations.values()) {
            httpDestination.close();
        }
        this.destinations.clear();
        this.requestListeners.clear();
        this.authenticationStore.clearAuthentications();
        this.authenticationStore.clearAuthenticationResults();
        super.doStop();
    }

    public List<Request.Listener> getRequestListeners() {
        return this.requestListeners;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    CookieManager getCookieManager() {
        return this.cookieManager;
    }

    Sweeper getDestinationSweeper() {
        return this.destinationSweeper;
    }

    public AuthenticationStore getAuthenticationStore() {
        return this.authenticationStore;
    }

    public Set<ContentDecoder.Factory> getContentDecoderFactories() {
        return this.decoderFactories;
    }

    public Request POST(URI uRI) {
        return this.newRequest(uRI).method(HttpMethod.POST);
    }

    public Request newRequest(String string, int n2) {
        return this.newRequest(new Origin("http", string, n2).asString());
    }

    public Request newRequest(String string) {
        return this.newRequest(URI.create(string));
    }

    public Request newRequest(URI uRI) {
        return this.newHttpRequest(this.newConversation(), uRI);
    }

    protected Request copyRequest(HttpRequest httpRequest, URI uRI) {
        HttpRequest httpRequest2 = this.newHttpRequest(httpRequest.getConversation(), uRI);
        httpRequest2.method(httpRequest.getMethod()).version(httpRequest.getVersion()).content(httpRequest.getContent()).idleTimeout(httpRequest.getIdleTimeout(), TimeUnit.MILLISECONDS).timeout(httpRequest.getTimeout(), TimeUnit.MILLISECONDS).followRedirects(httpRequest.isFollowRedirects());
        for (HttpField httpField : httpRequest.getHeaders()) {
            HttpHeader httpHeader = httpField.getHeader();
            if (HttpHeader.HOST == httpHeader || HttpHeader.EXPECT == httpHeader || HttpHeader.COOKIE == httpHeader || HttpHeader.AUTHORIZATION == httpHeader || HttpHeader.PROXY_AUTHORIZATION == httpHeader) continue;
            String string = httpField.getName();
            String string2 = httpField.getValue();
            if (httpRequest2.getHeaders().contains(string, string2)) continue;
            httpRequest2.header(string, string2);
        }
        return httpRequest2;
    }

    protected HttpRequest newHttpRequest(HttpConversation httpConversation, URI uRI) {
        return new HttpRequest(this, httpConversation, this.checkHost(uRI));
    }

    private URI checkHost(URI uRI) {
        if (uRI.getHost() == null) {
            throw new IllegalArgumentException(String.format("Invalid URI host: null (authority: %s)", uRI.getRawAuthority()));
        }
        return uRI;
    }

    protected HttpDestination destinationFor(String string, String string2, int n2) {
        return this.resolveDestination(string, string2, n2, null);
    }

    protected HttpDestination resolveDestination(String string, String string2, int n2, Object object) {
        Origin origin = this.createOrigin(string, string2, n2, object);
        return this.resolveDestination(origin);
    }

    protected Origin createOrigin(String string, String string2, int n2, Object object) {
        if (!(HttpScheme.HTTP.is(string) || HttpScheme.HTTPS.is(string) || HttpScheme.WS.is(string) || HttpScheme.WSS.is(string))) {
            throw new IllegalArgumentException("Invalid protocol " + string);
        }
        string = string.toLowerCase(Locale.ENGLISH);
        string2 = string2.toLowerCase(Locale.ENGLISH);
        n2 = HttpClient.normalizePort(string, n2);
        return new Origin(string, string2, n2, object);
    }

    public HttpDestination resolveDestination(Origin origin2) {
        return this.destinations.compute(origin2, (origin, httpDestination) -> {
            if (httpDestination == null || httpDestination.stale()) {
                HttpDestination httpDestination2 = this.getTransport().newHttpDestination((Origin)origin);
                this.addManaged(httpDestination2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Created {}; existing: '{}'", httpDestination2, httpDestination);
                }
                return httpDestination2;
            }
            return httpDestination;
        });
    }

    protected boolean removeDestination(HttpDestination httpDestination) {
        boolean bl2 = this.destinations.remove(httpDestination.getOrigin(), httpDestination);
        this.removeBean(httpDestination);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removed {}; result: {}", httpDestination, bl2);
        }
        return bl2;
    }

    protected void send(HttpRequest httpRequest, List<Response.ResponseListener> list) {
        HttpDestination httpDestination = this.resolveDestination(httpRequest.getScheme(), httpRequest.getHost(), httpRequest.getPort(), httpRequest.getTag());
        httpDestination.send(httpRequest, list);
    }

    protected void newConnection(final HttpDestination httpDestination, final Promise<Connection> promise) {
        Origin.Address address = httpDestination.getConnectAddress();
        this.resolver.resolve(address.getHost(), address.getPort(), new Promise<List<InetSocketAddress>>(){

            @Override
            public void succeeded(List<InetSocketAddress> list) {
                ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
                concurrentHashMap.put("client.connector", HttpClient.this);
                concurrentHashMap.put("http.destination", httpDestination);
                this.connect(list, 0, concurrentHashMap);
            }

            @Override
            public void failed(Throwable throwable) {
                promise.failed(throwable);
            }

            private void connect(final List<InetSocketAddress> list, final int n2, final Map<String, Object> map) {
                map.put("http.connection.promise", new Promise.Wrapper<Connection>(promise){

                    @Override
                    public void failed(Throwable throwable) {
                        int n22 = n2 + 1;
                        if (n22 == list.size()) {
                            super.failed(throwable);
                        } else {
                            this.connect(list, n22, map);
                        }
                    }
                });
                HttpClient.this.transport.connect(list.get(n2), map);
            }
        });
    }

    private HttpConversation newConversation() {
        return new HttpConversation();
    }

    protected ProtocolHandler findProtocolHandler(Request request, Response response) {
        return this.handlers.find(request, response);
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    public void setByteBufferPool(ByteBufferPool byteBufferPool) {
        if (this.isStarted()) {
            LOG.warn("Calling setByteBufferPool() while started is deprecated", new Object[0]);
        }
        this.updateBean(this.byteBufferPool, byteBufferPool);
        this.byteBufferPool = byteBufferPool;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long l2) {
        this.connectTimeout = l2;
    }

    public long getAddressResolutionTimeout() {
        return this.addressResolutionTimeout;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public HttpField getUserAgentField() {
        return this.agentField;
    }

    public void setUserAgentField(HttpField httpField) {
        if (httpField != null && httpField.getHeader() != HttpHeader.USER_AGENT) {
            throw new IllegalArgumentException();
        }
        this.agentField = httpField;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        if (this.isStarted()) {
            LOG.warn("Calling setExecutor() while started is deprecated", new Object[0]);
        }
        this.updateBean(this.executor, executor);
        this.executor = executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        if (this.isStarted()) {
            LOG.warn("Calling setScheduler() while started is deprecated", new Object[0]);
        }
        this.updateBean(this.scheduler, scheduler);
        this.scheduler = scheduler;
    }

    public void setSocketAddressResolver(SocketAddressResolver socketAddressResolver) {
        if (this.isStarted()) {
            LOG.warn("Calling setSocketAddressResolver() while started is deprecated", new Object[0]);
        }
        this.updateBean(this.resolver, socketAddressResolver);
        this.resolver = socketAddressResolver;
    }

    public int getMaxConnectionsPerDestination() {
        return this.maxConnectionsPerDestination;
    }

    public void setMaxConnectionsPerDestination(int n2) {
        this.maxConnectionsPerDestination = n2;
    }

    public int getMaxRequestsQueuedPerDestination() {
        return this.maxRequestsQueuedPerDestination;
    }

    public void setMaxRequestsQueuedPerDestination(int n2) {
        this.maxRequestsQueuedPerDestination = n2;
    }

    public int getRequestBufferSize() {
        return this.requestBufferSize;
    }

    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public boolean isTCPNoDelay() {
        return this.tcpNoDelay;
    }

    public HttpCompliance getHttpCompliance() {
        return this.httpCompliance;
    }

    public boolean isStrictEventOrdering() {
        return this.strictEventOrdering;
    }

    public long getDestinationIdleTimeout() {
        return this.destinationIdleTimeout;
    }

    public boolean isConnectBlocking() {
        return this.connectBlocking;
    }

    public String getDefaultRequestContentType() {
        return this.defaultRequestContentType;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfig;
    }

    protected HttpField getAcceptEncodingField() {
        return this.encodingField;
    }

    public static int normalizePort(String string, int n2) {
        if (n2 > 0) {
            return n2;
        }
        if (HttpClient.isSchemeSecure(string)) {
            return 443;
        }
        return 80;
    }

    public boolean isDefaultPort(String string, int n2) {
        if (HttpClient.isSchemeSecure(string)) {
            return n2 == 443;
        }
        return n2 == 80;
    }

    static boolean isSchemeSecure(String string) {
        return HttpScheme.HTTPS.is(string) || HttpScheme.WSS.is(string);
    }

    @Deprecated
    protected ClientConnectionFactory newSslClientConnectionFactory(ClientConnectionFactory clientConnectionFactory) {
        return new SslClientConnectionFactory(this.getSslContextFactory(), this.getByteBufferPool(), this.getExecutor(), clientConnectionFactory);
    }

    protected ClientConnectionFactory newSslClientConnectionFactory(SslContextFactory sslContextFactory, ClientConnectionFactory clientConnectionFactory) {
        if (sslContextFactory == null) {
            return this.newSslClientConnectionFactory(clientConnectionFactory);
        }
        return new SslClientConnectionFactory(sslContextFactory, this.getByteBufferPool(), this.getExecutor(), clientConnectionFactory);
    }

    private class ContentDecoderFactorySet
    implements Set<ContentDecoder.Factory> {
        private final Set<ContentDecoder.Factory> set = new HashSet<ContentDecoder.Factory>();

        private ContentDecoderFactorySet() {
        }

        @Override
        public boolean add(ContentDecoder.Factory factory) {
            boolean bl2 = this.set.add(factory);
            this.invalidate();
            return bl2;
        }

        @Override
        public boolean addAll(Collection<? extends ContentDecoder.Factory> collection) {
            boolean bl2 = this.set.addAll(collection);
            this.invalidate();
            return bl2;
        }

        @Override
        public boolean remove(Object object) {
            boolean bl2 = this.set.remove(object);
            this.invalidate();
            return bl2;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl2 = this.set.removeAll(collection);
            this.invalidate();
            return bl2;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl2 = this.set.retainAll(collection);
            this.invalidate();
            return bl2;
        }

        @Override
        public void clear() {
            this.set.clear();
            this.invalidate();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.set.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.set.containsAll(collection);
        }

        @Override
        public Iterator<ContentDecoder.Factory> iterator() {
            final Iterator<ContentDecoder.Factory> iterator = this.set.iterator();
            return new Iterator<ContentDecoder.Factory>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public ContentDecoder.Factory next() {
                    return (ContentDecoder.Factory)iterator.next();
                }

                @Override
                public void remove() {
                    iterator.remove();
                    ContentDecoderFactorySet.this.invalidate();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.set.toArray(TArray);
        }

        private void invalidate() {
            if (this.set.isEmpty()) {
                HttpClient.this.encodingField = null;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                Iterator<ContentDecoder.Factory> iterator = this.set.iterator();
                while (iterator.hasNext()) {
                    ContentDecoder.Factory factory = iterator.next();
                    stringBuilder.append(factory.getEncoding());
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(",");
                }
                HttpClient.this.encodingField = new HttpField(HttpHeader.ACCEPT_ENCODING, stringBuilder.toString());
            }
        }
    }
}

