/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.impl.conn;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.logging.Log;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Wire {
    private final Log log;
    private final String id;

    public Wire(Log log, String string) {
        this.log = log;
        this.id = string;
    }

    private void wire(String string, InputStream inputStream) throws IOException {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n2 = inputStream.read()) != -1) {
            if (n2 == 13) {
                stringBuilder.append("[\\r]");
                continue;
            }
            if (n2 == 10) {
                stringBuilder.append("[\\n]\"");
                stringBuilder.insert(0, "\"");
                stringBuilder.insert(0, string);
                this.log.debug(this.id + " " + stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            if (n2 < 32 || n2 > 127) {
                stringBuilder.append("[0x");
                stringBuilder.append(Integer.toHexString(n2));
                stringBuilder.append("]");
                continue;
            }
            stringBuilder.append((char)n2);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('\"');
            stringBuilder.insert(0, '\"');
            stringBuilder.insert(0, string);
            this.log.debug(this.id + " " + stringBuilder.toString());
        }
    }

    public boolean enabled() {
        return this.log.isDebugEnabled();
    }

    public void output(byte[] byArray, int n2, int n3) throws IOException {
        Args.notNull(byArray, "Output");
        this.wire(">> ", new ByteArrayInputStream(byArray, n2, n3));
    }

    public void input(byte[] byArray, int n2, int n3) throws IOException {
        Args.notNull(byArray, "Input");
        this.wire("<< ", new ByteArrayInputStream(byArray, n2, n3));
    }

    public void output(byte[] byArray) throws IOException {
        Args.notNull(byArray, "Output");
        this.wire(">> ", new ByteArrayInputStream(byArray));
    }

    public void input(byte[] byArray) throws IOException {
        Args.notNull(byArray, "Input");
        this.wire("<< ", new ByteArrayInputStream(byArray));
    }

    public void output(int n2) throws IOException {
        this.output(new byte[]{(byte)n2});
    }

    public void input(int n2) throws IOException {
        this.input(new byte[]{(byte)n2});
    }

    public void output(String string) throws IOException {
        Args.notNull(string, "Output");
        this.output(string.getBytes());
    }

    public void input(String string) throws IOException {
        Args.notNull(string, "Input");
        this.input(string.getBytes());
    }
}

