/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestFrameworkTemplate;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestNames;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.BaseJunitTestFrameworkStrategy;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.TestFrameworkProvider;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;
import java.lang.reflect.Constructor;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestFramework;
import org.gradle.api.tasks.testing.junitplatform.JUnitPlatformOptions;

final class Junit5TestFrameworkStrategy
extends BaseJunitTestFrameworkStrategy {
    private final boolean isSpock2Used;

    public Junit5TestFrameworkStrategy(boolean bl2) {
        this.isSpock2Used = bl2;
    }

    @Override
    public TestFramework createRetrying(TestFrameworkTemplate testFrameworkTemplate, TestFramework testFramework, TestNames testNames) {
        DefaultTestFilter defaultTestFilter = this.testFilterFor(testNames, this.isSpock2Used, testFrameworkTemplate);
        return Junit5TestFrameworkProvider.testFrameworkProvider(testFrameworkTemplate, testFramework).testFrameworkFor(defaultTestFilter);
    }

    static class Junit5TestFrameworkProvider {
        static TestFrameworkProvider testFrameworkProvider(TestFrameworkTemplate testFrameworkTemplate, TestFramework testFramework) {
            if (TestFrameworkStrategy.gradleVersionIsAtLeast("8.0")) {
                return new TestFrameworkProvider.ProviderForCurrentGradleVersion(testFramework);
            }
            return new ProviderForGradleOlderThanV8(testFrameworkTemplate);
        }

        static class ProviderForGradleOlderThanV8
        implements TestFrameworkProvider {
            private final TestFrameworkTemplate template;

            ProviderForGradleOlderThanV8(TestFrameworkTemplate testFrameworkTemplate) {
                this.template = testFrameworkTemplate;
            }

            @Override
            public TestFramework testFrameworkFor(DefaultTestFilter defaultTestFilter) {
                JUnitPlatformTestFramework jUnitPlatformTestFramework = ProviderForGradleOlderThanV8.newInstance(defaultTestFilter);
                ProviderForGradleOlderThanV8.copyOptions((JUnitPlatformOptions)this.template.task.getTestFramework().getOptions(), jUnitPlatformTestFramework.getOptions());
                return jUnitPlatformTestFramework;
            }

            private static JUnitPlatformTestFramework newInstance(DefaultTestFilter defaultTestFilter) {
                try {
                    Class<JUnitPlatformTestFramework> clazz = JUnitPlatformTestFramework.class;
                    Constructor constructor = clazz.getConstructor(DefaultTestFilter.class);
                    return (JUnitPlatformTestFramework)constructor.newInstance(defaultTestFilter);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new RuntimeException(reflectiveOperationException);
                }
            }

            private static void copyOptions(JUnitPlatformOptions jUnitPlatformOptions, JUnitPlatformOptions jUnitPlatformOptions2) {
                jUnitPlatformOptions2.setIncludeEngines(jUnitPlatformOptions.getIncludeEngines());
                jUnitPlatformOptions2.setExcludeEngines(jUnitPlatformOptions.getExcludeEngines());
                jUnitPlatformOptions2.setIncludeTags(jUnitPlatformOptions.getIncludeTags());
                jUnitPlatformOptions2.setExcludeTags(jUnitPlatformOptions.getExcludeTags());
            }
        }
    }
}

